/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.ha;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.factory.HighlyAvailableGraphDatabaseFactory;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.kernel.impl.util.Listener;
import org.neo4j.test.TargetDirectory;

public class ClusterRule
extends ExternalResource
implements ClusterManager.ClusterBuilder<ClusterRule> {
    private ClusterManager.Builder clusterManagerBuilder;
    private ClusterManager clusterManager;
    private File storeDirectory;
    private final TargetDirectory.TestDirectory testDirectory;
    private ClusterManager.ManagedCluster cluster;

    public ClusterRule(Class<?> testClass) {
        this.testDirectory = TargetDirectory.testDirForTest(testClass);
        this.clusterManagerBuilder = new ClusterManager.Builder().withSharedSetting(GraphDatabaseSettings.store_internal_log_level, "DEBUG").withSharedSetting(ClusterSettings.default_timeout, "1s").withSharedSetting(HaSettings.tx_push_factor, "0").withSharedSetting(GraphDatabaseSettings.pagecache_memory, "8m").withAvailabilityChecks(new Predicate[]{ClusterManager.allSeesAllAsAvailable()});
    }

    public ClusterRule withRootDirectory(File root) {
        throw new UnsupportedOperationException();
    }

    public ClusterRule withSeedDir(File seedDir) {
        return this.set(this.clusterManagerBuilder.withSeedDir(seedDir));
    }

    public ClusterRule withStoreDirInitializer(ClusterManager.StoreDirInitializer initializer) {
        return this.set(this.clusterManagerBuilder.withStoreDirInitializer(initializer));
    }

    public ClusterRule withDbFactory(HighlyAvailableGraphDatabaseFactory dbFactory) {
        return this.set(this.clusterManagerBuilder.withDbFactory(dbFactory));
    }

    public ClusterRule withProvider(ClusterManager.Provider provider) {
        return this.set(this.clusterManagerBuilder.withProvider(provider));
    }

    public ClusterRule withInstanceConfig(Map<String, IntFunction<String>> commonConfig) {
        return this.set(this.clusterManagerBuilder.withInstanceConfig(commonConfig));
    }

    public ClusterRule withInstanceSetting(Setting<?> setting, IntFunction<String> valueFunction) {
        return this.set(this.clusterManagerBuilder.withInstanceSetting(setting, valueFunction));
    }

    public ClusterRule withSharedConfig(Map<String, String> commonConfig) {
        return this.set(this.clusterManagerBuilder.withSharedConfig(commonConfig));
    }

    public ClusterRule withSharedSetting(Setting<?> setting, String value) {
        return this.set(this.clusterManagerBuilder.withSharedSetting(setting, value));
    }

    public ClusterRule withInitialDataset(Listener<GraphDatabaseService> transactor) {
        return this.set(this.clusterManagerBuilder.withInitialDataset(transactor));
    }

    @SafeVarargs
    public final ClusterRule withAvailabilityChecks(Predicate<ClusterManager.ManagedCluster> ... checks) {
        return this.set(this.clusterManagerBuilder.withAvailabilityChecks((Predicate[])checks));
    }

    private ClusterRule set(ClusterManager.Builder builder) {
        this.clusterManagerBuilder = builder;
        return this;
    }

    public ClusterManager.ManagedCluster startCluster() throws Exception {
        if (this.cluster != null) {
            return this.cluster;
        }
        this.clusterManager = this.clusterManagerBuilder.withRootDirectory(this.storeDirectory).build();
        try {
            this.clusterManager.start();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        this.cluster = this.clusterManager.getDefaultCluster();
        return this.cluster;
    }

    public Statement apply(final Statement base, final Description description) {
        Statement testMethod = new Statement(){

            public void evaluate() throws Throwable {
                String name = description.getMethodName() != null ? description.getMethodName() : description.getClassName();
                ClusterRule.this.storeDirectory = ClusterRule.this.testDirectory.directory(name);
                base.evaluate();
            }
        };
        Statement testMethodWithBeforeAndAfter = super.apply(testMethod, description);
        return this.testDirectory.apply(testMethodWithBeforeAndAfter, description);
    }

    protected void after() {
        try {
            if (this.clusterManager != null) {
                this.clusterManager.shutdown();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public File directory(String name) {
        return this.testDirectory.directory(name);
    }

    public File cleanDirectory(String name) throws IOException {
        return this.testDirectory.cleanDirectory(name);
    }

    public static IntFunction<String> constant(String value) {
        return ClusterManager.constant((String)value);
    }

    public static IntFunction<String> intBase(int oneBasedServerId) {
        return serverId -> String.valueOf(oneBasedServerId + serverId);
    }

    public static IntFunction<String> stringWithIntBase(String prefix, int oneBasedServerId) {
        return serverId -> prefix + (oneBasedServerId + serverId);
    }
}

