/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.ha;

import java.net.URI;
import java.util.logging.Level;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.client.Clusters;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.factory.TestHighlyAvailableGraphDatabaseFactory;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.test.LoggerRule;
import org.neo4j.test.TargetDirectory;

public class ClusterTest {
    @Rule
    public LoggerRule logging = new LoggerRule(Level.OFF);
    @Rule
    public TargetDirectory.TestDirectory testDirectory = TargetDirectory.testDirForTest(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCluster() throws Throwable {
        ClusterManager clusterManager = new ClusterManager.Builder(this.testDirectory.directory("testCluster")).withProvider(ClusterManager.fromXml((URI)this.getClass().getResource("/threeinstances.xml").toURI())).withSharedConfig(MapUtil.stringMap((String[])new String[]{HaSettings.ha_server.name(), "localhost:6001-6005", HaSettings.tx_push_factor.name(), "2"})).build();
        try {
            long nodeId;
            clusterManager.start();
            clusterManager.getDefaultCluster().await(ClusterManager.allSeesAllAsAvailable());
            HighlyAvailableGraphDatabase master = clusterManager.getDefaultCluster().getMaster();
            try (Transaction tx = master.beginTx();){
                Node node = master.createNode();
                nodeId = node.getId();
                node.setProperty("foo", (Object)"bar");
                tx.success();
            }
            HighlyAvailableGraphDatabase slave = clusterManager.getDefaultCluster().getAnySlave(new HighlyAvailableGraphDatabase[0]);
            try (Transaction transaction = slave.beginTx();){
                Node node = slave.getNodeById(nodeId);
                Assert.assertThat((Object)node.getProperty("foo").toString(), (Matcher)CoreMatchers.equalTo((Object)"bar"));
            }
        }
        finally {
            clusterManager.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClusterWithHostnames() throws Throwable {
        Clusters.Cluster cluster = new Clusters.Cluster("neo4j.ha");
        for (int i = 0; i < 3; ++i) {
            cluster.getMembers().add(new Clusters.Member("localhost:" + (5001 + i), true));
        }
        Clusters clusters = new Clusters();
        clusters.getClusters().add(cluster);
        ClusterManager clusterManager = new ClusterManager.Builder(this.testDirectory.directory("testCluster")).withProvider(ClusterManager.provided((Clusters)clusters)).withSharedConfig(MapUtil.stringMap((String[])new String[]{HaSettings.ha_server.name(), "localhost:6001-6005", HaSettings.tx_push_factor.name(), "2"})).build();
        try {
            long nodeId;
            clusterManager.start();
            clusterManager.getDefaultCluster().await(ClusterManager.allSeesAllAsAvailable());
            HighlyAvailableGraphDatabase master = clusterManager.getDefaultCluster().getMaster();
            try (Transaction tx = master.beginTx();){
                Node node = master.createNode();
                nodeId = node.getId();
                node.setProperty("foo", (Object)"bar");
                tx.success();
            }
            HighlyAvailableGraphDatabase anySlave = clusterManager.getDefaultCluster().getAnySlave(new HighlyAvailableGraphDatabase[0]);
            try (Transaction ignore = anySlave.beginTx();){
                Node node = anySlave.getNodeById(nodeId);
                Assert.assertThat((Object)node.getProperty("foo").toString(), (Matcher)CoreMatchers.equalTo((Object)"bar"));
            }
        }
        finally {
            clusterManager.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClusterWithWildcardIP() throws Throwable {
        Clusters.Cluster cluster = new Clusters.Cluster("neo4j.ha");
        for (int i = 0; i < 3; ++i) {
            cluster.getMembers().add(new Clusters.Member(5001 + i, true));
        }
        Clusters clusters = new Clusters();
        clusters.getClusters().add(cluster);
        ClusterManager clusterManager = new ClusterManager.Builder(this.testDirectory.directory("testCluster")).withProvider(ClusterManager.provided((Clusters)clusters)).withSharedConfig(MapUtil.stringMap((String[])new String[]{HaSettings.ha_server.name(), "0.0.0.0:6001-6005", HaSettings.tx_push_factor.name(), "2"})).build();
        try {
            long nodeId;
            clusterManager.start();
            clusterManager.getDefaultCluster().await(ClusterManager.allSeesAllAsAvailable());
            HighlyAvailableGraphDatabase master = clusterManager.getDefaultCluster().getMaster();
            try (Transaction tx = master.beginTx();){
                Node node = master.createNode();
                nodeId = node.getId();
                node.setProperty("foo", (Object)"bar");
                tx.success();
            }
            HighlyAvailableGraphDatabase anySlave = clusterManager.getDefaultCluster().getAnySlave(new HighlyAvailableGraphDatabase[0]);
            try (Transaction ignore = anySlave.beginTx();){
                Node node = anySlave.getNodeById(nodeId);
                Assert.assertThat((Object)node.getProperty("foo").toString(), (Matcher)CoreMatchers.equalTo((Object)"bar"));
            }
        }
        finally {
            clusterManager.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore(value="JH: Ignored for by CG in March 2013, needs revisit. I added @ignore instead of commenting out to list this in static analysis.")
    public void testArbiterStartsFirstAndThenTwoInstancesJoin() throws Throwable {
        ClusterManager clusterManager = new ClusterManager.Builder(this.testDirectory.directory("testCluster")).withProvider(ClusterManager.clusterWithAdditionalArbiters((int)2, (int)1)).build();
        try {
            clusterManager.start();
            clusterManager.getDefaultCluster().await(ClusterManager.allSeesAllAsAvailable());
            HighlyAvailableGraphDatabase master = clusterManager.getDefaultCluster().getMaster();
            try (Transaction tx = master.beginTx();){
                master.createNode();
                tx.success();
            }
        }
        finally {
            clusterManager.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInstancesWithConflictingClusterPorts() throws Throwable {
        HighlyAvailableGraphDatabase first = null;
        try {
            String masterStoreDir = this.testDirectory.directory("testConflictingClusterPortsMaster").getAbsolutePath();
            first = (HighlyAvailableGraphDatabase)new TestHighlyAvailableGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(masterStoreDir).setConfig(ClusterSettings.initial_hosts, "127.0.0.1:5001").setConfig(ClusterSettings.cluster_server, "127.0.0.1:5001").setConfig(ClusterSettings.server_id, "1").setConfig(HaSettings.ha_server, "127.0.0.1:6666").newGraphDatabase();
            try {
                String slaveStoreDir = this.testDirectory.directory("testConflictingClusterPortsSlave").getAbsolutePath();
                HighlyAvailableGraphDatabase failed = (HighlyAvailableGraphDatabase)new TestHighlyAvailableGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(slaveStoreDir).setConfig(ClusterSettings.initial_hosts, "127.0.0.1:5001").setConfig(ClusterSettings.cluster_server, "127.0.0.1:5001").setConfig(ClusterSettings.server_id, "2").setConfig(HaSettings.ha_server, "127.0.0.1:6667").newGraphDatabase();
                failed.shutdown();
                Assert.fail((String)"Should not start when ports conflict");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            if (first != null) {
                first.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInstancesWithConflictingHaPorts() throws Throwable {
        HighlyAvailableGraphDatabase first = null;
        try {
            String storeDir = this.testDirectory.directory("testConflictingHaPorts").getAbsolutePath();
            first = (HighlyAvailableGraphDatabase)new TestHighlyAvailableGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(storeDir).setConfig(ClusterSettings.initial_hosts, "127.0.0.1:5001").setConfig(ClusterSettings.cluster_server, "127.0.0.1:5001").setConfig(ClusterSettings.server_id, "1").setConfig(HaSettings.ha_server, "127.0.0.1:6666").newGraphDatabase();
            try {
                HighlyAvailableGraphDatabase failed = (HighlyAvailableGraphDatabase)new TestHighlyAvailableGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(storeDir).setConfig(ClusterSettings.initial_hosts, "127.0.0.1:5001").setConfig(ClusterSettings.cluster_server, "127.0.0.1:5002").setConfig(ClusterSettings.server_id, "2").setConfig(HaSettings.ha_server, "127.0.0.1:6666").newGraphDatabase();
                failed.shutdown();
                Assert.fail((String)"Should not start when ports conflict");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            if (first != null) {
                first.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void given4instanceClusterWhenMasterGoesDownThenElectNewMaster() throws Throwable {
        ClusterManager clusterManager = new ClusterManager.Builder(this.testDirectory.directory("4instances")).withProvider(ClusterManager.fromXml((URI)this.getClass().getResource("/fourinstances.xml").toURI())).build();
        try {
            clusterManager.start();
            ClusterManager.ManagedCluster cluster = clusterManager.getDefaultCluster();
            cluster.await(ClusterManager.allSeesAllAsAvailable());
            this.logging.getLogger().info("STOPPING MASTER");
            cluster.shutdown(cluster.getMaster());
            this.logging.getLogger().info("STOPPED MASTER");
            cluster.await(ClusterManager.masterAvailable((HighlyAvailableGraphDatabase[])new HighlyAvailableGraphDatabase[0]));
            HighlyAvailableGraphDatabase master = cluster.getMaster();
            this.logging.getLogger().info("CREATE NODE");
            try (Transaction tx = master.beginTx();){
                master.createNode();
                this.logging.getLogger().info("CREATED NODE");
                tx.success();
            }
            this.logging.getLogger().info("STOPPING CLUSTER");
        }
        finally {
            clusterManager.stop();
        }
    }

    @Test
    public void givenEmptyHostListWhenClusterStartupThenFormClusterWithSingleInstance() throws Exception {
        HighlyAvailableGraphDatabase db = (HighlyAvailableGraphDatabase)new TestHighlyAvailableGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(this.testDirectory.directory("singleinstance").getAbsolutePath()).setConfig(ClusterSettings.server_id, "1").setConfig(ClusterSettings.initial_hosts, "").newGraphDatabase();
        try {
            Assert.assertTrue((String)"Single instance cluster was not formed in time", (boolean)db.isAvailable(1000L));
        }
        finally {
            db.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void givenClusterWhenMasterGoesDownAndTxIsRunningThenDontWaitToSwitch() throws Throwable {
        ClusterManager clusterManager = new ClusterManager.Builder(this.testDirectory.directory("waitfortx")).withProvider(ClusterManager.fromXml((URI)this.getClass().getResource("/threeinstances.xml").toURI())).build();
        try {
            clusterManager.start();
            ClusterManager.ManagedCluster cluster = clusterManager.getDefaultCluster();
            cluster.await(ClusterManager.allSeesAllAsAvailable());
            HighlyAvailableGraphDatabase slave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
            try (Transaction tx = slave.beginTx();){
                slave.createNode();
                cluster.shutdown(cluster.getMaster());
                cluster.await(ClusterManager.masterAvailable((HighlyAvailableGraphDatabase[])new HighlyAvailableGraphDatabase[0]));
                cluster.await(ClusterManager.masterSeesSlavesAsAvailable((int)1));
                tx.success();
            }
            catch (TransactionFailureException transactionFailureException) {
                // empty catch block
            }
        }
        finally {
            clusterManager.stop();
        }
    }
}

