/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.client.ClusterClient;
import org.neo4j.cluster.protocol.heartbeat.HeartbeatListener;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.test.ha.ClusterRule;

public class TestSlaveOnlyCluster {
    @ClassRule
    public static ClusterRule clusterRule = new ClusterRule(TestSlaveOnlyCluster.class).withInstanceSetting(HaSettings.slave_only, value -> value == 1 || value == 2 ? "true" : "false");
    private static final String PROPERTY = "foo";
    private static final String VALUE = "bar";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMasterElectionAfterMasterRecoversInSlaveOnlyCluster() throws Throwable {
        ClusterManager.ManagedCluster cluster = clusterRule.startCluster();
        Assert.assertThat((Object)cluster.getServerId(cluster.getMaster()), (Matcher)CoreMatchers.equalTo((Object)new InstanceId(3)));
        HighlyAvailableGraphDatabase master = cluster.getMaster();
        CountDownLatch masterFailedLatch = this.createMasterFailLatch(cluster);
        ClusterManager.RepairKit repairKit = cluster.fail(master);
        try {
            Assert.assertTrue((boolean)masterFailedLatch.await(60L, TimeUnit.SECONDS));
        }
        finally {
            repairKit.repair();
        }
        cluster.await(ClusterManager.allSeesAllAsAvailable());
        long nodeId = this.createNodeWithPropertyOn(cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]), PROPERTY, VALUE);
        try (Transaction ignore = master.beginTx();){
            Assert.assertThat((Object)master.getNodeById(nodeId).getProperty(PROPERTY), (Matcher)CoreMatchers.equalTo((Object)VALUE));
        }
    }

    private long createNodeWithPropertyOn(HighlyAvailableGraphDatabase db, String property, String value) {
        try (Transaction tx = db.beginTx();){
            Node node = db.createNode();
            node.setProperty(property, (Object)value);
            tx.success();
            long l = node.getId();
            return l;
        }
    }

    private CountDownLatch createMasterFailLatch(ClusterManager.ManagedCluster cluster) {
        final CountDownLatch failedLatch = new CountDownLatch(2);
        for (HighlyAvailableGraphDatabase db : cluster.getAllMembers()) {
            if (db.isMaster()) continue;
            ((ClusterClient)db.getDependencyResolver().resolveDependency(ClusterClient.class)).addHeartbeatListener(new HeartbeatListener(){

                public void failed(InstanceId server) {
                    failedLatch.countDown();
                }

                public void alive(InstanceId server) {
                }
            });
        }
        return failedLatch;
    }
}

