/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.UpdatePuller;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.test.ha.ClusterRule;

@Ignore(value="Not a test, but a tool to measure an isolation characteristic where a change will be visible in an index will see changes after being visible in the record store. This test tries to measure how big that gap is")
public class MeasureUpdatePullingRecordAndIndexGap {
    private final int numberOfIndexes = 10;
    @Rule
    public final ClusterRule clusterRule = new ClusterRule(this.getClass()).withSharedSetting((Setting<?>)HaSettings.tx_push_factor, "0");

    @Test
    public void shouldMeasureThatGap() throws Exception {
        ClusterManager.ManagedCluster cluster = this.clusterRule.startCluster();
        this.createIndexes((GraphDatabaseService)cluster.getMaster());
        cluster.sync(new HighlyAvailableGraphDatabase[0]);
        this.awaitIndexes(cluster);
        AtomicBoolean halter = new AtomicBoolean();
        AtomicLong[] highIdNodes = new AtomicLong[10];
        CountDownLatch endLatch = new CountDownLatch(11);
        for (int i = 0; i < highIdNodes.length; ++i) {
            highIdNodes[i] = new AtomicLong();
        }
        this.startLoadOn((GraphDatabaseService)cluster.getMaster(), halter, highIdNodes, endLatch);
        HighlyAvailableGraphDatabase slave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        this.startCatchingUp((GraphDatabaseAPI)slave, halter, endLatch);
        AtomicInteger good = new AtomicInteger();
        AtomicInteger bad = new AtomicInteger();
        AtomicInteger ugly = new AtomicInteger();
        this.startMeasuringTheGap(good, bad, ugly, halter, highIdNodes, (GraphDatabaseAPI)slave);
        long endTime = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(30L);
        while (System.currentTimeMillis() < endTime) {
            this.printStats(good.get(), bad.get(), ugly.get());
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        halter.set(true);
        endLatch.await();
        this.printStats(good.get(), bad.get(), ugly.get());
    }

    private void startMeasuringTheGap(final AtomicInteger good, final AtomicInteger bad, final AtomicInteger ugly, final AtomicBoolean halter, final AtomicLong[] highIdNodes, final GraphDatabaseAPI db) {
        new Thread(){

            @Override
            public void run() {
                while (!halter.get()) {
                    for (int i = 0; i < 10; ++i) {
                        long targetNodeId = highIdNodes[i].get();
                        if (targetNodeId == 0L) continue;
                        try (Transaction tx = db.beginTx();){
                            Node nodeFromStorePOV = null;
                            long nodeId = targetNodeId;
                            while (nodeFromStorePOV == null && !halter.get()) {
                                try {
                                    nodeFromStorePOV = db.getNodeById(nodeId);
                                }
                                catch (NotFoundException e) {
                                    nodeId = Math.max(nodeId - 1L, 0L);
                                    try {
                                        Thread.sleep(10L);
                                    }
                                    catch (InterruptedException e1) {
                                        throw new RuntimeException(e1);
                                    }
                                }
                            }
                            Node nodeFromIndexPOV = db.findNode(MeasureUpdatePullingRecordAndIndexGap.this.label(i), MeasureUpdatePullingRecordAndIndexGap.this.key(i), (Object)nodeId);
                            tx.success();
                            if (nodeFromIndexPOV != null) {
                                good.incrementAndGet();
                            } else {
                                bad.incrementAndGet();
                            }
                            if (nodeId == targetNodeId) continue;
                            ugly.incrementAndGet();
                            continue;
                        }
                    }
                }
            }
        }.start();
    }

    private void printStats(int good, int bad, int ugly) {
        double total = good + bad;
        System.out.printf("good: %.1f%%, bad: %.1f%%, ugly: %.1f%% (out of a total of %.0f)%n", 100.0 * (double)good / total, 100.0 * (double)bad / total, 100.0 * (double)ugly / total, total);
    }

    private void awaitIndexes(ClusterManager.ManagedCluster cluster) {
        for (GraphDatabaseService db : cluster.getAllMembers()) {
            Transaction tx = db.beginTx();
            Throwable throwable = null;
            try {
                db.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
                tx.success();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (tx == null) continue;
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                tx.close();
            }
        }
    }

    private void startCatchingUp(final GraphDatabaseAPI db, final AtomicBoolean halter, final CountDownLatch endLatch) {
        new Thread(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                try {
                    while (!halter.get()) {
                        try {
                            ((UpdatePuller)db.getDependencyResolver().resolveDependency(UpdatePuller.class)).pullUpdates();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw new RuntimeException(e);
                            return;
                        }
                    }
                }
                finally {
                    endLatch.countDown();
                }
            }
        }.start();
    }

    private void createIndexes(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            for (int i = 0; i < 10; ++i) {
                db.schema().indexFor(this.label(i)).on(this.key(i)).create();
            }
            tx.success();
        }
    }

    private String key(int i) {
        return "key-" + i;
    }

    private Label label(int i) {
        return Label.label((String)("Label" + i));
    }

    private void startLoadOn(final GraphDatabaseService db, final AtomicBoolean halter, final AtomicLong[] highIdNodes, final CountDownLatch endLatch) {
        int i = 0;
        while (i < 10) {
            final int x = i++;
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        while (!halter.get()) {
                            long nodeId;
                            try (Transaction tx = db.beginTx();){
                                Node node = db.createNode(new Label[]{MeasureUpdatePullingRecordAndIndexGap.this.label(x)});
                                nodeId = node.getId();
                                node.setProperty(MeasureUpdatePullingRecordAndIndexGap.this.key(x), (Object)nodeId);
                                tx.success();
                            }
                            highIdNodes[x].set(nodeId);
                        }
                    }
                    finally {
                        endLatch.countDown();
                    }
                }
            }.start();
        }
    }
}

