/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.IOException;
import org.neo4j.com.ComException;
import org.neo4j.com.RequestContext;
import org.neo4j.com.Response;
import org.neo4j.graphdb.TransientTransactionFailureException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.storageengine.api.TransactionApplicationMode;

public class SlaveTransactionCommitProcess
implements TransactionCommitProcess {
    private final Master master;
    private final RequestContextFactory requestContextFactory;

    public SlaveTransactionCommitProcess(Master master, RequestContextFactory requestContextFactory) {
        this.master = master;
        this.requestContextFactory = requestContextFactory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long commit(TransactionToApply batch, CommitEvent commitEvent, TransactionApplicationMode mode) throws TransactionFailureException {
        if (batch.next() != null) {
            throw new IllegalArgumentException("Only supports single-commit on slave --> master");
        }
        try {
            TransactionRepresentation representation = batch.transactionRepresentation();
            RequestContext context = this.requestContextFactory.newRequestContext(representation.getLockSessionId());
            try (Response<Long> response = this.master.commit(context, representation);){
                long l = (Long)response.response();
                return l;
            }
        }
        catch (IOException e) {
            throw new TransactionFailureException((Status)Status.Transaction.CouldNotCommit, (Throwable)e, "Could not commit transaction on the master", new Object[0]);
        }
        catch (ComException e) {
            throw new TransientTransactionFailureException("Cannot commit this transaction on the master. The master is either down, or we have network connectivity problems.", (Throwable)e);
        }
    }
}

