/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.test.ha.ClusterRule;

public class DeletionTest {
    @ClassRule
    public static ClusterRule clusterRule = new ClusterRule(DeletionTest.class).withProvider(ClusterManager.clusterOfSize(2));

    @Test
    public void shouldDeleteRecords() throws Throwable {
        Relationship rel;
        ClusterManager.ManagedCluster cluster = clusterRule.startCluster();
        HighlyAvailableGraphDatabase master = cluster.getMaster();
        HighlyAvailableGraphDatabase slave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        try (Transaction tx = slave.beginTx();){
            rel = slave.createNode().createRelationshipTo(slave.createNode(), RelationshipType.withName((String)"FOO"));
            tx.success();
        }
        var6_5 = null;
        try (Transaction transaction = master.beginTx();){
            Assert.assertNotNull((Object)master.getRelationshipById(rel.getId()));
        }
        catch (Throwable throwable) {
            var6_5 = throwable;
            throw throwable;
        }
        tx = slave.beginTx();
        var6_5 = null;
        try {
            rel.delete();
            tx.success();
        }
        catch (Throwable throwable) {
            var6_5 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var6_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var6_5.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        slave.shutdown();
        master.shutdown();
    }
}

