/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.test.ha.ClusterRule;

public class HaLoggingIT {
    @Rule
    public final ClusterRule clusterRule = new ClusterRule(this.getClass());
    protected ClusterManager.ManagedCluster cluster;

    @Before
    public void setup() throws Exception {
        this.cluster = ((ClusterRule)this.clusterRule.withProvider(ClusterManager.clusterWithAdditionalClients(2, 1)).withAvailabilityChecks(new Predicate[]{ClusterManager.masterAvailable(new HighlyAvailableGraphDatabase[0]), ClusterManager.masterSeesMembers(3), ClusterManager.allSeesAllAsJoined()})).startCluster();
    }

    @Test
    public void logging_continues_after_role_switch() throws Exception {
        String logMessage = "Just a test for that logging continues as expected";
        HighlyAvailableGraphDatabase db = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        LogService logService = (LogService)db.getDependencyResolver().resolveDependency(LogService.class);
        logService.getInternalLog(this.getClass()).info(logMessage, new Object[]{true});
        HighlyAvailableGraphDatabase master = this.cluster.getMaster();
        this.cluster.shutdown(master);
        this.cluster.await(ClusterManager.masterAvailable(master));
        this.cluster.await(ClusterManager.masterSeesMembers(2));
        logService.getInternalLog(this.getClass()).info(logMessage);
        Assert.assertEquals((long)2L, (long)this.countLoggingLines(db, logMessage));
    }

    private long countLoggingLines(HighlyAvailableGraphDatabase db, String suffix) throws IOException {
        Path logFile = Paths.get(this.cluster.getStoreDir(db).getAbsolutePath(), "messages.log");
        try (Stream<String> lines = Files.lines(logFile);){
            long l = lines.filter(line -> line.endsWith(suffix)).count();
            return l;
        }
    }
}

