/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.File;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.graphdb.factory.TestHighlyAvailableGraphDatabaseFactory;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.impl.storemigration.MigrationTestUtils;
import org.neo4j.kernel.impl.storemigration.UpgradeNotAllowedByConfigurationException;
import org.neo4j.test.TargetDirectory;

public class SlaveUpgradeTest {
    @Rule
    public final TargetDirectory.TestDirectory testDirectory = TargetDirectory.testDirForTest(this.getClass());

    @Test
    public void haShouldFailToStartWithOldStore() throws Exception {
        try {
            File dir = this.testDirectory.directory("haShouldFailToStartWithOldStore");
            MigrationTestUtils.find20FormatStoreDirectory((File)dir);
            new TestHighlyAvailableGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(dir.getAbsolutePath()).setConfig(ClusterSettings.server_id, "1").setConfig(ClusterSettings.initial_hosts, "localhost:9999").newGraphDatabase();
            Assert.fail((String)"Should exit abnormally");
        }
        catch (Exception e) {
            Throwable rootCause = Exceptions.rootCause((Throwable)e);
            Assert.assertThat((Object)rootCause, (Matcher)CoreMatchers.instanceOf(UpgradeNotAllowedByConfigurationException.class));
        }
    }
}

