/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.factory;

import java.lang.reflect.Proxy;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.DelegateInvocationHandler;
import org.neo4j.kernel.ha.factory.HighlyAvailableCommitProcessFactory;
import org.neo4j.kernel.impl.api.ReadOnlyTransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.storageengine.api.StorageEngine;

public class HighlyAvailableCommitProcessFactoryTest {
    @Test
    public void createReadOnlyCommitProcess() {
        HighlyAvailableCommitProcessFactory factory = new HighlyAvailableCommitProcessFactory(new DelegateInvocationHandler(TransactionCommitProcess.class));
        Config config = new Config(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.read_only.name(), "true"}));
        TransactionCommitProcess commitProcess = factory.create((TransactionAppender)Mockito.mock(TransactionAppender.class), (StorageEngine)Mockito.mock(StorageEngine.class), config);
        Assert.assertThat((Object)commitProcess, (Matcher)Matchers.instanceOf(ReadOnlyTransactionCommitProcess.class));
    }

    @Test
    public void createRegularCommitProcess() {
        HighlyAvailableCommitProcessFactory factory = new HighlyAvailableCommitProcessFactory(new DelegateInvocationHandler(TransactionCommitProcess.class));
        TransactionCommitProcess commitProcess = factory.create((TransactionAppender)Mockito.mock(TransactionAppender.class), (StorageEngine)Mockito.mock(StorageEngine.class), new Config());
        Assert.assertThat((Object)commitProcess, (Matcher)Matchers.not((Matcher)Matchers.instanceOf(ReadOnlyTransactionCommitProcess.class)));
        Assert.assertThat((Object)Proxy.getInvocationHandler(commitProcess), (Matcher)Matchers.instanceOf(DelegateInvocationHandler.class));
    }
}

