/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster.member;

import java.net.URI;
import java.util.Map;
import java.util.function.Function;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.protocol.cluster.Cluster;
import org.neo4j.cluster.protocol.cluster.ClusterListener;
import org.neo4j.function.Functions;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.ha.cluster.member.ClusterMember;
import org.neo4j.kernel.ha.cluster.member.ClusterMembers;
import org.neo4j.kernel.ha.com.master.Slave;
import org.neo4j.kernel.ha.com.master.SlaveFactory;
import org.neo4j.kernel.ha.com.master.Slaves;
import org.neo4j.kernel.impl.util.CopyOnWriteHashMap;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;

public class HighAvailabilitySlaves
implements Lifecycle,
Slaves {
    private final LifeSupport life = new LifeSupport();
    private final Map<ClusterMember, Slave> slaves = new CopyOnWriteHashMap();
    private final ClusterMembers clusterMembers;
    private final Cluster cluster;
    private final SlaveFactory slaveFactory;
    private HASClusterListener clusterListener;

    public HighAvailabilitySlaves(ClusterMembers clusterMembers, Cluster cluster, SlaveFactory slaveFactory) {
        this.clusterMembers = clusterMembers;
        this.cluster = cluster;
        this.slaveFactory = slaveFactory;
    }

    private Function<ClusterMember, Slave> slaveForMember() {
        return from -> {
            HighAvailabilitySlaves highAvailabilitySlaves = this;
            synchronized (highAvailabilitySlaves) {
                Slave presentSlave = this.slaves.get(from);
                if (presentSlave == null) {
                    presentSlave = this.slaveFactory.newSlave(this.life, (ClusterMember)from);
                    this.slaves.put((ClusterMember)from, presentSlave);
                }
                return presentSlave;
            }
        };
    }

    @Override
    public Iterable<Slave> getSlaves() {
        return Iterables.map((Function)Functions.withDefaults(this.slaveForMember(), (Function)Functions.map(this.slaves)), (Iterable)Iterables.filter(ClusterMembers.inRole("slave"), this.clusterMembers.getAliveMembers()));
    }

    public void init() {
        this.life.init();
        this.clusterListener = new HASClusterListener();
        this.cluster.addClusterListener((ClusterListener)this.clusterListener);
    }

    public void start() throws Throwable {
        this.life.start();
    }

    public void stop() throws Throwable {
        this.life.stop();
    }

    public void shutdown() throws Throwable {
        this.cluster.removeClusterListener((ClusterListener)this.clusterListener);
        this.life.shutdown();
        this.slaves.clear();
    }

    private class HASClusterListener
    extends ClusterListener.Adapter {
        private HASClusterListener() {
        }

        public void elected(String role, InstanceId instanceId, URI electedMember) {
            if (role.equals("coordinator")) {
                HighAvailabilitySlaves.this.life.clear();
                HighAvailabilitySlaves.this.slaves.clear();
            }
        }
    }
}

