/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.LifecycleListener;
import org.neo4j.kernel.lifecycle.LifecycleStatus;
import org.neo4j.test.ha.ClusterRule;
import org.neo4j.tooling.GlobalGraphOperations;

public class ClusterTransactionIT {
    @Rule
    public final ClusterRule clusterRule = new ClusterRule(this.getClass());
    private ClusterManager.ManagedCluster cluster;

    @Before
    public void setUp() throws Exception {
        this.cluster = ((ClusterRule)((ClusterRule)this.clusterRule.withProvider(ClusterManager.fromXml(this.getClass().getResource("/threeinstances.xml").toURI())).withSharedSetting(HaSettings.ha_server, ":6001-6005")).withSharedSetting(HaSettings.tx_push_factor, "2")).startCluster();
        this.cluster.await(ClusterManager.allSeesAllAsAvailable());
    }

    @Test
    public void givenClusterWhenShutdownMasterThenCannotStartTransactionOnSlave() throws Throwable {
        long nodeId;
        HighlyAvailableGraphDatabase master = this.cluster.getMaster();
        final HighlyAvailableGraphDatabase slave = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        try (Transaction tx = master.beginTx();){
            nodeId = master.createNode().getId();
            tx.success();
        }
        this.cluster.sync(new HighlyAvailableGraphDatabase[0]);
        final FutureTask<Boolean> result = new FutureTask<Boolean>(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try (Transaction tx = slave.beginTx();){
                    tx.acquireWriteLock((PropertyContainer)slave.getNodeById(nodeId));
                }
                catch (Exception e) {
                    return Exceptions.contains((Throwable)e, (Class[])new Class[]{TransactionFailureException.class});
                }
                return false;
            }
        });
        ((LifeSupport)master.getDependencyResolver().resolveDependency(LifeSupport.class)).addLifecycleListener(new LifecycleListener(){

            public void notifyStatusChanged(Object instance, LifecycleStatus from, LifecycleStatus to) {
                if (instance.getClass().getName().contains("DatabaseAvailability") && to == LifecycleStatus.STOPPED) {
                    result.run();
                }
            }
        });
        master.shutdown();
        Assert.assertThat((Object)result.get(), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void slaveMustConnectLockManagerToNewMasterAfterTwoOtherClusterMembersRoleSwitch() throws Throwable {
        HighlyAvailableGraphDatabase initialMaster = this.cluster.getMaster();
        HighlyAvailableGraphDatabase firstSlave = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        HighlyAvailableGraphDatabase secondSlave = this.cluster.getAnySlave(firstSlave);
        try (Transaction tx = firstSlave.beginTx();){
            firstSlave.createNode();
            tx.success();
        }
        tx = secondSlave.beginTx();
        var5_5 = null;
        try {
            secondSlave.createNode();
            tx.success();
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.cluster.sync(new HighlyAvailableGraphDatabase[0]);
        ClusterManager.RepairKit failedMaster = this.cluster.fail(initialMaster);
        this.cluster.await(ClusterManager.masterAvailable(initialMaster));
        failedMaster.repair();
        this.cluster.await(ClusterManager.masterAvailable(initialMaster));
        this.cluster.await(ClusterManager.allSeesAllAsAvailable());
        HighlyAvailableGraphDatabase slave = this.cluster.getAnySlave(initialMaster);
        try (Transaction tx = slave.beginTx();){
            slave.createNode();
            tx.success();
        }
        HighlyAvailableGraphDatabase master = this.cluster.getMaster();
        try (Transaction tx = master.beginTx();){
            GlobalGraphOperations gops = GlobalGraphOperations.at((GraphDatabaseService)master);
            Assert.assertThat((Object)IteratorUtil.count((Iterable)gops.getAllNodes()), (Matcher)Matchers.is((Object)3));
        }
    }
}

