/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha.correctness;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.function.Function;
import org.neo4j.cluster.com.message.Message;
import org.neo4j.cluster.com.message.MessageType;
import org.neo4j.ha.correctness.ClusterAction;
import org.neo4j.ha.correctness.ClusterState;
import org.neo4j.helpers.collection.Iterables;

class MessageDeliveryAction
implements ClusterAction {
    public static final Function<Message, ClusterAction> MESSAGE_TO_ACTION = MessageDeliveryAction::new;
    private final Message message;

    public MessageDeliveryAction(Message message) {
        this.message = message;
    }

    @Override
    public Iterable<ClusterAction> perform(ClusterState state) throws URISyntaxException {
        String to = this.message.getHeader("to");
        return Iterables.map(MESSAGE_TO_ACTION, state.instance(to).process(this.messageCopy()));
    }

    private Message<? extends MessageType> messageCopy() throws URISyntaxException {
        URI to = new URI(this.message.getHeader("to"));
        Message copy = Message.to((MessageType)this.message.getMessageType(), (URI)to, (Object)this.message.getPayload());
        return this.message.copyHeadersTo(copy, new String[0]);
    }

    public String toString() {
        return "(" + this.message.getHeader("from") + ")-[" + this.message.getMessageType().name() + "]->(" + this.message.getHeader("to") + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.messageEquals(this.message, ((MessageDeliveryAction)o).message);
    }

    private boolean messageEquals(Message first, Message other) {
        if (!first.getMessageType().equals(other.getMessageType())) {
            return false;
        }
        if (!first.getHeader("from").equals(other.getHeader("from"))) {
            return false;
        }
        if (!first.getHeader("to").equals(other.getHeader("to"))) {
            return false;
        }
        if (first.getPayload() instanceof Message && other.getPayload() instanceof Message) {
            return this.messageEquals((Message)first.getPayload(), (Message)other.getPayload());
        }
        return !(first.getPayload() == null ? other.getPayload() != null : !first.getPayload().equals(other.getPayload()));
    }

    public int hashCode() {
        int result = this.message.getMessageType().hashCode();
        result = 31 * result + this.message.getHeader("from").hashCode();
        result = 31 * result + this.message.getHeader("to").hashCode();
        return result;
    }
}

