/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.File;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.TestHighlyAvailableGraphDatabaseFactory;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.test.TargetDirectory;

public class ConflictingServerIdIT {
    @Rule
    public final TargetDirectory.TestDirectory testDirectory = TargetDirectory.testDirForTest(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConflictingIdDoesNotSilentlyFail() throws Exception {
        HighlyAvailableGraphDatabase master = null;
        HighlyAvailableGraphDatabase dbWithId21 = null;
        HighlyAvailableGraphDatabase dbWithId22 = null;
        try {
            GraphDatabaseBuilder masterBuilder = new TestHighlyAvailableGraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.path(1)).setConfig(ClusterSettings.initial_hosts, "127.0.0.1:5002").setConfig(ClusterSettings.cluster_server, "127.0.0.1:5002").setConfig(ClusterSettings.server_id, "1").setConfig(HaSettings.ha_server, ":8002").setConfig(HaSettings.tx_push_factor, "0");
            master = (HighlyAvailableGraphDatabase)masterBuilder.newGraphDatabase();
            GraphDatabaseBuilder db21Builder = new TestHighlyAvailableGraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.path(2)).setConfig(ClusterSettings.initial_hosts, "127.0.0.1:5002,127.0.0.1:5003").setConfig(ClusterSettings.cluster_server, "127.0.0.1:5003").setConfig(ClusterSettings.server_id, "2").setConfig(HaSettings.ha_server, ":8003").setConfig(HaSettings.tx_push_factor, "0");
            dbWithId21 = (HighlyAvailableGraphDatabase)db21Builder.newGraphDatabase();
            GraphDatabaseBuilder db22Builder = new TestHighlyAvailableGraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.path(3)).setConfig(ClusterSettings.initial_hosts, "127.0.0.1:5002").setConfig(ClusterSettings.cluster_server, "127.0.0.1:5004").setConfig(ClusterSettings.server_id, "2").setConfig(HaSettings.ha_server, ":8004").setConfig(HaSettings.tx_push_factor, "0");
            try {
                dbWithId22 = (HighlyAvailableGraphDatabase)db22Builder.newGraphDatabase();
                Assert.fail((String)"Should not be able to startup when a cluster already has my id");
            }
            catch (Exception exception) {
                // empty catch block
            }
            Assert.assertTrue((boolean)master.isMaster());
            Assert.assertTrue((!dbWithId21.isMaster() ? 1 : 0) != 0);
            try (Transaction transaction = dbWithId21.beginTx();){
                transaction.success();
            }
        }
        finally {
            if (dbWithId21 != null) {
                dbWithId21.shutdown();
            }
            if (dbWithId22 != null) {
                dbWithId22.shutdown();
            }
            if (master != null) {
                master.shutdown();
            }
        }
    }

    private File path(int i) {
        return new File(this.testDirectory.graphDbDir(), "" + i);
    }
}

