/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Supplier;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.test.LoggerRule;
import org.neo4j.test.TargetDirectory;

@RunWith(value=Parameterized.class)
public class TestFailoverWithAdditionalSlaveFailures {
    @Rule
    public LoggerRule logger = new LoggerRule();
    @Rule
    public TargetDirectory.TestDirectory dir = TargetDirectory.testDirForTest(this.getClass());
    private int clusterSize;
    private int[] slavesToFail;

    @Parameterized.Parameters(name="{index} clusterSize:{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({5, new int[]{1}}, {5, new int[]{2}}, {5, new int[]{3}}, {5, new int[]{4}}, {6, new int[]{1}}, {6, new int[]{3}}, {6, new int[]{5}}, {7, new int[]{1, 2}}, {7, new int[]{3, 4}}, {7, new int[]{5, 6}});
    }

    public TestFailoverWithAdditionalSlaveFailures(int clusterSize, int[] slavesToFail) {
        this.clusterSize = clusterSize;
        this.slavesToFail = slavesToFail;
    }

    @Test
    public void testFailoverWithAdditionalSlave() throws Throwable {
        this.testFailoverWithAdditionalSlave(this.clusterSize, this.slavesToFail);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testFailoverWithAdditionalSlave(int clusterSize, int[] slaveIndexes) throws Throwable {
        ClusterManager manager = ((ClusterManager.Builder)((ClusterManager.Builder)new ClusterManager.Builder().withRootDirectory(this.dir.cleanDirectory("testcluster")).withCluster((Supplier)ClusterManager.clusterOfSize(clusterSize))).withSharedConfig(MapUtil.stringMap((String[])new String[]{ClusterSettings.heartbeat_interval.name(), "1"}))).build();
        try {
            manager.start();
            ClusterManager.ManagedCluster cluster = manager.getCluster();
            cluster.await(ClusterManager.allSeesAllAsAvailable());
            cluster.await(ClusterManager.masterAvailable(new HighlyAvailableGraphDatabase[0]));
            ArrayList<HighlyAvailableGraphDatabase> failed = new ArrayList<HighlyAvailableGraphDatabase>();
            ArrayList<ClusterManager.RepairKit> repairKits = new ArrayList<ClusterManager.RepairKit>();
            for (int slaveIndex : slaveIndexes) {
                HighlyAvailableGraphDatabase nthSlave = this.getNthSlave(cluster, slaveIndex);
                failed.add(nthSlave);
                ClusterManager.RepairKit repairKit = cluster.fail(nthSlave, false, ClusterManager.NetworkFlag.values());
                repairKits.add(repairKit);
            }
            HighlyAvailableGraphDatabase oldMaster = cluster.getMaster();
            failed.add(oldMaster);
            repairKits.add(cluster.fail(oldMaster, false, ClusterManager.NetworkFlag.values()));
            cluster.await(ClusterManager.masterAvailable(this.toArray(failed)));
            for (ClusterManager.RepairKit repairKit : repairKits) {
                repairKit.repair();
            }
            Thread.sleep(3000L);
        }
        finally {
            manager.safeShutdown();
        }
    }

    private HighlyAvailableGraphDatabase getNthSlave(ClusterManager.ManagedCluster cluster, int slaveOrder) {
        assert (slaveOrder > 0);
        HighlyAvailableGraphDatabase slave = null;
        ArrayList<HighlyAvailableGraphDatabase> excluded = new ArrayList<HighlyAvailableGraphDatabase>();
        while (slaveOrder-- > 0) {
            slave = cluster.getAnySlave(this.toArray(excluded));
            excluded.add(slave);
        }
        return slave;
    }

    private HighlyAvailableGraphDatabase[] toArray(Collection<HighlyAvailableGraphDatabase> excluded) {
        return excluded.toArray(new HighlyAvailableGraphDatabase[excluded.size()]);
    }
}

