/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.test.ha.ClusterRule;

public class TestClusterIndexDeletion {
    @Rule
    public ClusterRule clusterRule = ((ClusterRule)new ClusterRule(this.getClass()).withSharedSetting(HaSettings.ha_server, ":6001-6005")).withSharedSetting(HaSettings.tx_push_factor, "2");

    @Test
    public void givenClusterWithCreatedIndexWhenDeleteIndexOnMasterThenIndexIsDeletedOnSlave() throws Throwable {
        ClusterManager.ManagedCluster cluster = this.clusterRule.startCluster();
        HighlyAvailableGraphDatabase master = cluster.getMaster();
        try (Transaction tx = master.beginTx();){
            master.index().forNodes("Test");
            tx.success();
        }
        HighlyAvailableGraphDatabase aSlave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        try (Transaction tx = aSlave.beginTx();){
            Assert.assertThat((Object)aSlave.index().existsForNodes("Test"), (Matcher)CoreMatchers.equalTo((Object)true));
            tx.success();
        }
        tx = master.beginTx();
        var5_7 = null;
        try {
            master.index().forNodes("Test").delete();
            tx.success();
        }
        catch (Throwable throwable) {
            var5_7 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_7 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var5_7.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        HighlyAvailableGraphDatabase anotherSlave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        try (Transaction tx = anotherSlave.beginTx();){
            Assert.assertThat((Object)anotherSlave.index().existsForNodes("Test"), (Matcher)CoreMatchers.equalTo((Object)false));
            tx.success();
        }
    }
}

