/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.com.master;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.neo4j.kernel.ha.com.master.Conversation;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.test.ThreadingRule;

@RunWith(value=MockitoJUnitRunner.class)
public class ConversationTest {
    @Mock
    private Locks.Client client;
    @InjectMocks
    private Conversation conversation;
    @Rule
    public ThreadingRule threadingRule = new ThreadingRule();

    @Test
    public void stopAlreadyClosedConversationDoNotTouchLocks() {
        this.conversation.close();
        this.conversation.stop();
        this.conversation.stop();
        this.conversation.stop();
        ((Locks.Client)Mockito.verify((Object)this.client)).close();
        Assert.assertFalse((boolean)this.conversation.isActive());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.client});
    }

    @Test
    public void stopCloseConversation() {
        this.conversation.stop();
        this.conversation.close();
        ((Locks.Client)Mockito.verify((Object)this.client)).stop();
        ((Locks.Client)Mockito.verify((Object)this.client)).close();
        Assert.assertFalse((boolean)this.conversation.isActive());
    }

    @Test(timeout=3000L)
    public void conversationCanNotBeStoppedAndClosedConcurrently() throws InterruptedException {
        CountDownLatch answerLatch = new CountDownLatch(1);
        CountDownLatch stopLatch = new CountDownLatch(1);
        CountDownLatch stopReadyLatch = new CountDownLatch(1);
        int sleepTime = 1000;
        ((Locks.Client)Mockito.doAnswer(invocation -> {
            stopReadyLatch.countDown();
            stopLatch.await();
            TimeUnit.MILLISECONDS.sleep(1000L);
            return null;
        }).when((Object)this.client)).stop();
        ((Locks.Client)Mockito.doAnswer(invocation -> {
            answerLatch.countDown();
            return null;
        }).when((Object)this.client)).close();
        this.threadingRule.execute(conversation -> {
            conversation.stop();
            return null;
        }, (Object)this.conversation);
        stopReadyLatch.await();
        this.threadingRule.execute(conversation -> {
            conversation.close();
            return null;
        }, (Object)this.conversation);
        long raceStartTime = System.currentTimeMillis();
        stopLatch.countDown();
        answerLatch.await();
        long executionTime = System.currentTimeMillis() - raceStartTime;
        Assert.assertTrue((String)String.format("Execution time should be at least equal to %d, but was %d.", 1000, executionTime), (executionTime >= 1000L ? 1 : 0) != 0);
    }
}

