/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.IOException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.neo4j.com.ObjectSerializer;
import org.neo4j.com.Protocol;
import org.neo4j.com.RequestContext;
import org.neo4j.com.Response;
import org.neo4j.com.TargetCaller;
import org.neo4j.com.storecopy.StoreWriter;
import org.neo4j.com.storecopy.ToNetworkStoreWriter;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.ha.AbstractHaRequestTypes;
import org.neo4j.kernel.ha.AquireLockCall;
import org.neo4j.kernel.ha.HaRequestTypes;
import org.neo4j.kernel.ha.com.master.HandshakeResult;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.com.slave.MasterClient;
import org.neo4j.kernel.ha.id.IdAllocation;
import org.neo4j.kernel.ha.lock.LockResult;
import org.neo4j.kernel.impl.store.id.IdRange;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.storageengine.api.lock.ResourceType;

public class HaRequestType210
extends AbstractHaRequestTypes {
    public HaRequestType210(final LogEntryReader<ReadableClosablePositionAwareChannel> entryReader) {
        this.register(HaRequestTypes.Type.ALLOCATE_IDS, (TargetCaller)new TargetCaller<Master, IdAllocation>(){

            public Response<IdAllocation> call(Master master, RequestContext context, ChannelBuffer input, ChannelBuffer target) {
                IdType idType = IdType.values()[input.readByte()];
                return master.allocateIds(context, idType);
            }
        }, (ObjectSerializer)new ObjectSerializer<IdAllocation>(){

            public void write(IdAllocation idAllocation, ChannelBuffer result) throws IOException {
                IdRange idRange = idAllocation.getIdRange();
                result.writeInt(idRange.getDefragIds().length);
                for (long id : idRange.getDefragIds()) {
                    result.writeLong(id);
                }
                result.writeLong(idRange.getRangeStart());
                result.writeInt(idRange.getRangeLength());
                result.writeLong(idAllocation.getHighestIdInUse());
                result.writeLong(idAllocation.getDefragCount());
            }
        });
        this.register(HaRequestTypes.Type.CREATE_RELATIONSHIP_TYPE, (TargetCaller)new TargetCaller<Master, Integer>(){

            public Response<Integer> call(Master master, RequestContext context, ChannelBuffer input, ChannelBuffer target) {
                return master.createRelationshipType(context, Protocol.readString((ChannelBuffer)input));
            }
        }, Protocol.INTEGER_SERIALIZER);
        this.register(HaRequestTypes.Type.ACQUIRE_EXCLUSIVE_LOCK, new AquireLockCall(){

            @Override
            protected Response<LockResult> lock(Master master, RequestContext context, ResourceType type, long ... ids) {
                return master.acquireExclusiveLock(context, type, ids);
            }
        }, MasterClient.LOCK_SERIALIZER, true);
        this.register(HaRequestTypes.Type.ACQUIRE_SHARED_LOCK, new AquireLockCall(){

            @Override
            protected Response<LockResult> lock(Master master, RequestContext context, ResourceType type, long ... ids) {
                return master.acquireSharedLock(context, type, ids);
            }
        }, MasterClient.LOCK_SERIALIZER, true);
        this.register(HaRequestTypes.Type.COMMIT, (TargetCaller)new TargetCaller<Master, Long>(){

            public Response<Long> call(Master master, RequestContext context, ChannelBuffer input, ChannelBuffer target) throws IOException, TransactionFailureException {
                Protocol.readString((ChannelBuffer)input);
                TransactionRepresentation tx = null;
                try {
                    Protocol.TransactionRepresentationDeserializer deserializer = new Protocol.TransactionRepresentationDeserializer(entryReader);
                    tx = (TransactionRepresentation)deserializer.read(input, null);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return master.commit(context, tx);
            }
        }, Protocol.LONG_SERIALIZER);
        this.register(HaRequestTypes.Type.PULL_UPDATES, (TargetCaller)new TargetCaller<Master, Void>(){

            public Response<Void> call(Master master, RequestContext context, ChannelBuffer input, ChannelBuffer target) {
                return master.pullUpdates(context);
            }
        }, Protocol.VOID_SERIALIZER);
        this.register(HaRequestTypes.Type.END_LOCK_SESSION, (TargetCaller)new TargetCaller<Master, Void>(){

            public Response<Void> call(Master master, RequestContext context, ChannelBuffer input, ChannelBuffer target) {
                return master.endLockSession(context, Protocol.readBoolean((ChannelBuffer)input));
            }
        }, Protocol.VOID_SERIALIZER, false);
        this.register(HaRequestTypes.Type.HANDSHAKE, (TargetCaller)new TargetCaller<Master, HandshakeResult>(){

            public Response<HandshakeResult> call(Master master, RequestContext context, ChannelBuffer input, ChannelBuffer target) {
                return master.handshake(input.readLong(), null);
            }
        }, (ObjectSerializer)new ObjectSerializer<HandshakeResult>(){

            public void write(HandshakeResult responseObject, ChannelBuffer result) throws IOException {
                result.writeLong(responseObject.txChecksum());
                result.writeLong(responseObject.epoch());
            }
        });
        this.register(HaRequestTypes.Type.COPY_STORE, (TargetCaller)new TargetCaller<Master, Void>(){

            public Response<Void> call(Master master, RequestContext context, ChannelBuffer input, ChannelBuffer target) {
                return master.copyStore(context, (StoreWriter)new ToNetworkStoreWriter(target, new Monitors()));
            }
        }, Protocol.VOID_SERIALIZER, false);
        this.register(HaRequestTypes.Type.NEW_LOCK_SESSION, (TargetCaller)new TargetCaller<Master, Void>(){

            public Response<Void> call(Master master, RequestContext context, ChannelBuffer input, ChannelBuffer target) throws TransactionFailureException {
                return master.newLockSession(context);
            }
        }, Protocol.VOID_SERIALIZER);
        this.register(HaRequestTypes.Type.CREATE_PROPERTY_KEY, (TargetCaller)new TargetCaller<Master, Integer>(){

            public Response<Integer> call(Master master, RequestContext context, ChannelBuffer input, ChannelBuffer target) {
                return master.createPropertyKey(context, Protocol.readString((ChannelBuffer)input));
            }
        }, Protocol.INTEGER_SERIALIZER);
        this.register(HaRequestTypes.Type.CREATE_LABEL, (TargetCaller)new TargetCaller<Master, Integer>(){

            public Response<Integer> call(Master master, RequestContext context, ChannelBuffer input, ChannelBuffer target) {
                return master.createLabel(context, Protocol.readString((ChannelBuffer)input));
            }
        }, Protocol.INTEGER_SERIALIZER);
    }
}

