/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.com.master;

import java.util.ArrayList;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.ha.com.master.Slave;
import org.neo4j.kernel.ha.com.master.SlavePriorities;
import org.neo4j.kernel.ha.com.master.SlavePriority;

public class SlavePrioritiesTest {
    @Test
    public void roundRobinWithTwoSlavesAndPushFactorTwo() {
        SlavePriority roundRobin = SlavePriorities.roundRobin();
        Iterator slaves = roundRobin.prioritize(SlavePrioritiesTest.slaves(2, 3)).iterator();
        Assert.assertEquals((long)2L, (long)((Slave)slaves.next()).getServerId());
        Assert.assertEquals((long)3L, (long)((Slave)slaves.next()).getServerId());
    }

    @Test
    public void roundRobinWithTwoSlavesAndPushFactorOne() {
        SlavePriority roundRobin = SlavePriorities.roundRobin();
        Slave slave1 = (Slave)roundRobin.prioritize(SlavePrioritiesTest.slaves(2, 3)).iterator().next();
        Slave slave2 = (Slave)roundRobin.prioritize(SlavePrioritiesTest.slaves(2, 3)).iterator().next();
        Assert.assertEquals((long)2L, (long)slave1.getServerId());
        Assert.assertEquals((long)3L, (long)slave2.getServerId());
    }

    @Test
    public void roundRobinWithTwoSlavesAndPushFactorOneWhenSlaveIsAdded() {
        SlavePriority roundRobin = SlavePriorities.roundRobin();
        Slave slave1 = (Slave)roundRobin.prioritize(SlavePrioritiesTest.slaves(2, 3)).iterator().next();
        Slave slave2 = (Slave)roundRobin.prioritize(SlavePrioritiesTest.slaves(2, 3)).iterator().next();
        Slave slave3 = (Slave)roundRobin.prioritize(SlavePrioritiesTest.slaves(2, 3, 4)).iterator().next();
        Assert.assertEquals((long)2L, (long)slave1.getServerId());
        Assert.assertEquals((long)3L, (long)slave2.getServerId());
        Assert.assertEquals((long)4L, (long)slave3.getServerId());
    }

    @Test
    public void roundRobinWithTwoSlavesAndPushFactorOneWhenSlaveIsRemoved() {
        SlavePriority roundRobin = SlavePriorities.roundRobin();
        Slave slave1 = (Slave)roundRobin.prioritize(SlavePrioritiesTest.slaves(2, 3, 4)).iterator().next();
        Slave slave2 = (Slave)roundRobin.prioritize(SlavePrioritiesTest.slaves(2, 3, 4)).iterator().next();
        Slave slave3 = (Slave)roundRobin.prioritize(SlavePrioritiesTest.slaves(2, 3)).iterator().next();
        Assert.assertEquals((long)2L, (long)slave1.getServerId());
        Assert.assertEquals((long)3L, (long)slave2.getServerId());
        Assert.assertEquals((long)2L, (long)slave3.getServerId());
    }

    @Test
    public void roundRobinWithSingleSlave() {
        SlavePriority roundRobin = SlavePriorities.roundRobin();
        Iterator slaves = roundRobin.prioritize(SlavePrioritiesTest.slaves(2)).iterator();
        Assert.assertEquals((long)2L, (long)((Slave)slaves.next()).getServerId());
    }

    @Test
    public void roundRobinWithNoSlaves() {
        SlavePriority roundRobin = SlavePriorities.roundRobin();
        Iterator slaves = roundRobin.prioritize(SlavePrioritiesTest.slaves(new int[0])).iterator();
        Assert.assertFalse((boolean)slaves.hasNext());
    }

    private static Iterable<Slave> slaves(int ... ids) {
        ArrayList<Slave> slaves = new ArrayList<Slave>(ids.length);
        for (int id : ids) {
            Slave slaveMock = (Slave)Mockito.mock(Slave.class);
            Mockito.when((Object)slaveMock.getServerId()).thenReturn((Object)id);
            slaves.add(slaveMock);
        }
        return slaves;
    }
}

