/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.File;
import java.io.IOException;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.util.StoreUtil;
import org.neo4j.logging.Log;

public enum BranchedDataPolicy {
    keep_all{

        @Override
        public void handle(File storeDir, LogService logService) throws IOException {
            Log msgLog = logService.getInternalLog(((Object)((Object)this)).getClass());
            File branchedDataDir = StoreUtil.newBranchedDataDir((File)storeDir);
            msgLog.debug("Moving store from " + storeDir + " to " + branchedDataDir);
            StoreUtil.moveAwayDb((File)storeDir, (File)branchedDataDir);
        }
    }
    ,
    keep_last{

        @Override
        public void handle(File storeDir, LogService logService) throws IOException {
            Log msgLog = logService.getInternalLog(((Object)((Object)this)).getClass());
            File branchedDataDir = StoreUtil.newBranchedDataDir((File)storeDir);
            msgLog.debug("Moving store from " + storeDir + " to " + branchedDataDir);
            StoreUtil.moveAwayDb((File)storeDir, (File)branchedDataDir);
            for (File file : StoreUtil.getBranchedDataRootDirectory((File)storeDir).listFiles()) {
                if (!StoreUtil.isBranchedDataDirectory((File)file) || file.equals(branchedDataDir)) continue;
                FileUtils.deleteRecursively((File)file);
            }
        }
    }
    ,
    keep_none{

        @Override
        public void handle(File storeDir, LogService logService) throws IOException {
            Log msgLog = logService.getInternalLog(((Object)((Object)this)).getClass());
            msgLog.debug("Removing store  " + storeDir);
            StoreUtil.cleanStoreDir((File)storeDir);
        }
    };


    public abstract void handle(File var1, LogService var2) throws IOException;
}

