/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.IOException;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.ha.transaction.TransactionPropagator;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.api.index.NodePropertyCommandsExtractor;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.state.IntegrityValidator;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.storageengine.api.lock.ResourceType;

public class MasterTransactionCommitProcess
implements TransactionCommitProcess {
    private static final Visitor<StorageCommand, IOException> REQUIRES_SHARED_SCHEMA_LOCK = command -> command instanceof Command.NodeCommand && NodePropertyCommandsExtractor.mayResultInIndexUpdates((Command.NodeCommand)((Command.NodeCommand)command)) || command instanceof Command.PropertyCommand && NodePropertyCommandsExtractor.mayResultInIndexUpdates((Command.PropertyCommand)((Command.PropertyCommand)command));
    private final TransactionCommitProcess inner;
    private final TransactionPropagator txPropagator;
    private final IntegrityValidator validator;
    private final Monitor monitor;
    private final Locks locks;
    private final boolean reacquireSharedSchemaLockOnIncomingTransactions;

    public MasterTransactionCommitProcess(TransactionCommitProcess commitProcess, TransactionPropagator txPropagator, IntegrityValidator validator, Monitor monitor, Locks locks, boolean reacquireSharedSchemaLockOnIncomingTransactions) {
        this.inner = commitProcess;
        this.txPropagator = txPropagator;
        this.validator = validator;
        this.monitor = monitor;
        this.locks = locks;
        this.reacquireSharedSchemaLockOnIncomingTransactions = reacquireSharedSchemaLockOnIncomingTransactions;
    }

    public long commit(TransactionToApply batch, CommitEvent commitEvent, TransactionApplicationMode mode) throws TransactionFailureException {
        long result;
        try (Locks.Client locks = this.validate(batch);){
            result = this.inner.commit(batch, commitEvent, mode);
        }
        int missedReplicas = this.txPropagator.committed(result, batch.transactionRepresentation().getAuthorId());
        if (missedReplicas > 0) {
            this.monitor.missedReplicas(missedReplicas);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Locks.Client validate(TransactionToApply batch) throws TransactionFailureException {
        Locks.Client locks = null;
        boolean success = false;
        try {
            while (batch != null) {
                if (this.reacquireSharedSchemaLockOnIncomingTransactions) {
                    locks = this.acquireSharedSchemaLockIfTransactionResultsInIndexUpdates(batch, locks);
                }
                this.validator.validateTransactionStartKnowledge(batch.transactionRepresentation().getLatestCommittedTxWhenStarted());
                batch = batch.next();
            }
            success = true;
            Locks.Client client = locks;
            return client;
        }
        finally {
            if (!success && locks != null) {
                locks.close();
                locks = null;
            }
        }
    }

    private Locks.Client acquireSharedSchemaLockIfTransactionResultsInIndexUpdates(TransactionToApply batch, Locks.Client locks) throws TransactionFailureException {
        try {
            if (batch.accept(REQUIRES_SHARED_SCHEMA_LOCK)) {
                if (locks == null) {
                    locks = this.locks.newClient();
                }
                locks.acquireShared((ResourceType)ResourceTypes.SCHEMA, new long[]{ResourceTypes.schemaResource()});
            }
            return locks;
        }
        catch (IOException e) {
            throw new TransactionFailureException("Weird error when trying to figure out whether or not to acquire shared schema lock", (Throwable)e);
        }
    }

    public static interface Monitor {
        public void missedReplicas(int var1);
    }
}

