/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster;

import java.net.URI;
import org.neo4j.cluster.InstanceId;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberContext;

public enum HighAvailabilityMemberState {
    PENDING{

        @Override
        public HighAvailabilityMemberState masterIsElected(HighAvailabilityMemberContext context, InstanceId masterId) {
            assert (context.getAvailableHaMaster() == null);
            if (masterId.equals((Object)context.getMyId()) && !context.isSlaveOnly()) {
                return TO_MASTER;
            }
            return PENDING;
        }

        @Override
        public HighAvailabilityMemberState masterIsAvailable(HighAvailabilityMemberContext context, InstanceId masterId, URI masterHaURI) {
            if (masterId.equals((Object)context.getMyId())) {
                throw new RuntimeException("Received a MasterIsAvailable event for my InstanceId while in PENDING state");
            }
            return TO_SLAVE;
        }

        @Override
        public HighAvailabilityMemberState slaveIsAvailable(HighAvailabilityMemberContext context, InstanceId slaveId, URI slaveUri) {
            if (slaveId.equals((Object)context.getMyId())) {
                throw new RuntimeException("Cannot go from pending to slave");
            }
            return this;
        }

        @Override
        public boolean isEligibleForElection() {
            return true;
        }

        @Override
        public boolean isAccessAllowed() {
            return false;
        }
    }
    ,
    TO_SLAVE{

        @Override
        public HighAvailabilityMemberState masterIsElected(HighAvailabilityMemberContext context, InstanceId masterId) {
            if (masterId.equals((Object)context.getElectedMasterId())) {
                return this;
            }
            if (masterId.equals((Object)context.getMyId())) {
                return TO_MASTER;
            }
            return PENDING;
        }

        @Override
        public HighAvailabilityMemberState masterIsAvailable(HighAvailabilityMemberContext context, InstanceId masterId, URI masterHaURI) {
            if (masterId.equals((Object)context.getMyId())) {
                throw new RuntimeException("i (" + context.getMyId() + ") am trying to become a slave but " + "someone said i am available as master");
            }
            if (masterId.equals((Object)context.getElectedMasterId())) {
                return this;
            }
            throw new RuntimeException("my (" + context.getMyId() + ") current master is " + context.getAvailableHaMaster() + " (elected as " + context.getElectedMasterId() + " but i got a " + "masterIsAvailable event for " + masterHaURI);
        }

        @Override
        public HighAvailabilityMemberState slaveIsAvailable(HighAvailabilityMemberContext context, InstanceId slaveId, URI slaveUri) {
            if (slaveId.equals((Object)context.getMyId())) {
                return SLAVE;
            }
            return this;
        }

        @Override
        public boolean isEligibleForElection() {
            return false;
        }

        @Override
        public boolean isAccessAllowed() {
            return false;
        }
    }
    ,
    TO_MASTER{

        @Override
        public HighAvailabilityMemberState masterIsElected(HighAvailabilityMemberContext context, InstanceId masterId) {
            assert (context.getAvailableHaMaster() == null);
            if (masterId.equals((Object)context.getMyId())) {
                return this;
            }
            return PENDING;
        }

        @Override
        public HighAvailabilityMemberState masterIsAvailable(HighAvailabilityMemberContext context, InstanceId masterId, URI masterHaURI) {
            if (masterId.equals((Object)context.getMyId())) {
                return MASTER;
            }
            throw new RuntimeException("Received a MasterIsAvailable event for instance " + masterId + " while in TO_MASTER state");
        }

        @Override
        public HighAvailabilityMemberState slaveIsAvailable(HighAvailabilityMemberContext context, InstanceId slaveId, URI slaveUri) {
            if (slaveId.equals((Object)context.getMyId())) {
                throw new RuntimeException("Cannot be transitioning to master and slave at the same time");
            }
            return this;
        }

        @Override
        public boolean isEligibleForElection() {
            return true;
        }

        @Override
        public boolean isAccessAllowed() {
            return false;
        }
    }
    ,
    MASTER{

        @Override
        public HighAvailabilityMemberState masterIsElected(HighAvailabilityMemberContext context, InstanceId masterId) {
            if (masterId.equals((Object)context.getMyId())) {
                return this;
            }
            return PENDING;
        }

        @Override
        public HighAvailabilityMemberState masterIsAvailable(HighAvailabilityMemberContext context, InstanceId masterId, URI masterHaURI) {
            if (masterId.equals((Object)context.getMyId())) {
                return this;
            }
            throw new RuntimeException("I, " + context.getMyId() + " got a masterIsAvailable for " + masterHaURI + " (id is " + masterId + " ) while in MASTER state. Probably missed a " + "MasterIsElected event.");
        }

        @Override
        public HighAvailabilityMemberState slaveIsAvailable(HighAvailabilityMemberContext context, InstanceId slaveId, URI slaveUri) {
            if (slaveId.equals((Object)context.getMyId())) {
                throw new RuntimeException("Cannot be master and transition to slave at the same time");
            }
            return this;
        }

        @Override
        public boolean isEligibleForElection() {
            return true;
        }

        @Override
        public boolean isAccessAllowed() {
            return true;
        }
    }
    ,
    SLAVE{

        @Override
        public HighAvailabilityMemberState masterIsElected(HighAvailabilityMemberContext context, InstanceId masterId) {
            if (masterId.equals((Object)context.getMyId())) {
                return TO_MASTER;
            }
            if (masterId.equals((Object)context.getElectedMasterId())) {
                return this;
            }
            return PENDING;
        }

        @Override
        public HighAvailabilityMemberState masterIsAvailable(HighAvailabilityMemberContext context, InstanceId masterId, URI masterHaURI) {
            if (masterId.equals((Object)context.getMyId())) {
                throw new RuntimeException("Cannot transition to MASTER directly from SLAVE state");
            }
            if (masterId.equals((Object)context.getElectedMasterId())) {
                return this;
            }
            throw new RuntimeException("Received a MasterIsAvailable event for " + masterId + " which is different from the current master (" + context.getElectedMasterId() + ") while in the SLAVE state (probably missed a MasterIsElected event)");
        }

        @Override
        public HighAvailabilityMemberState slaveIsAvailable(HighAvailabilityMemberContext context, InstanceId slaveId, URI slaveUri) {
            return this;
        }

        @Override
        public boolean isEligibleForElection() {
            return true;
        }

        @Override
        public boolean isAccessAllowed() {
            return true;
        }
    };


    public abstract HighAvailabilityMemberState masterIsElected(HighAvailabilityMemberContext var1, InstanceId var2);

    public abstract HighAvailabilityMemberState masterIsAvailable(HighAvailabilityMemberContext var1, InstanceId var2, URI var3);

    public abstract HighAvailabilityMemberState slaveIsAvailable(HighAvailabilityMemberContext var1, InstanceId var2, URI var3);

    public abstract boolean isEligibleForElection();

    public abstract boolean isAccessAllowed();
}

