/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster.modeswitch;

import org.neo4j.kernel.ha.DelegateInvocationHandler;
import org.neo4j.kernel.ha.cluster.modeswitch.ComponentSwitcher;

public abstract class AbstractComponentSwitcher<T>
implements ComponentSwitcher {
    private final DelegateInvocationHandler<T> delegate;

    protected AbstractComponentSwitcher(DelegateInvocationHandler<T> delegate) {
        this.delegate = delegate;
    }

    protected abstract T getMasterImpl();

    protected abstract T getSlaveImpl();

    @Override
    public void switchToMaster() {
        this.shutdownCurrent();
        T component = this.getMasterImpl();
        this.updateDelegate(component);
    }

    @Override
    public void switchToSlave() {
        this.shutdownCurrent();
        T component = this.getSlaveImpl();
        this.updateDelegate(component);
    }

    @Override
    public void switchToPending() {
        this.shutdownCurrent();
    }

    protected void shutdownCurrent() {
        this.updateDelegate(null);
    }

    private void updateDelegate(T newValue) {
        this.delegate.setDelegate(newValue);
    }
}

