/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster.modeswitch;

import org.neo4j.kernel.ha.DelegateInvocationHandler;
import org.neo4j.kernel.ha.PullerFactory;
import org.neo4j.kernel.ha.SlaveUpdatePuller;
import org.neo4j.kernel.ha.UpdatePuller;
import org.neo4j.kernel.ha.cluster.modeswitch.AbstractComponentSwitcher;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;

public class UpdatePullerSwitcher
extends AbstractComponentSwitcher<UpdatePuller> {
    private final PullerFactory pullerFactory;
    private volatile LifeSupport life;

    public UpdatePullerSwitcher(DelegateInvocationHandler<UpdatePuller> delegate, PullerFactory pullerFactory) {
        super(delegate);
        this.pullerFactory = pullerFactory;
    }

    @Override
    protected UpdatePuller getMasterImpl() {
        return UpdatePuller.NONE;
    }

    @Override
    protected UpdatePuller getSlaveImpl() {
        SlaveUpdatePuller slaveUpdatePuller = this.pullerFactory.createSlaveUpdatePuller();
        this.startUpdatePuller(slaveUpdatePuller);
        return slaveUpdatePuller;
    }

    @Override
    protected void shutdownCurrent() {
        super.shutdownCurrent();
        this.shutdownCurrentPuller();
    }

    private void shutdownCurrentPuller() {
        if (this.life != null) {
            this.life.shutdown();
            this.life = null;
        }
    }

    private void startUpdatePuller(SlaveUpdatePuller slaveUpdatePuller) {
        this.life = new LifeSupport();
        this.life.add((Lifecycle)slaveUpdatePuller);
        this.life.start();
    }
}

