/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Supplier;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.test.LoggerRule;
import org.neo4j.test.TargetDirectory;

@RunWith(value=Parameterized.class)
public class ClusterFailoverIT {
    @Rule
    public LoggerRule logger = new LoggerRule();
    @Rule
    public TargetDirectory.TestDirectory dir = TargetDirectory.testDirForTest(this.getClass());
    private int clusterSize;

    @Parameterized.Parameters(name="clusterSize:{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({3}, {4}, {5}, {6}, {7});
    }

    public ClusterFailoverIT(int clusterSize) {
        this.clusterSize = clusterSize;
    }

    private void testFailOver(int clusterSize) throws Throwable {
        ClusterManager clusterManager = ((ClusterManager.Builder)((ClusterManager.Builder)new ClusterManager.Builder().withRootDirectory(this.dir.cleanDirectory("failover")).withCluster((Supplier)ClusterManager.clusterOfSize(clusterSize))).withSharedConfig(MapUtil.stringMap((String[])new String[]{ClusterSettings.heartbeat_interval.name(), "1"}))).build();
        clusterManager.start();
        ClusterManager.ManagedCluster cluster = clusterManager.getCluster();
        cluster.await(ClusterManager.allSeesAllAsAvailable());
        HighlyAvailableGraphDatabase oldMaster = cluster.getMaster();
        long start = System.nanoTime();
        ClusterManager.RepairKit repairKit = cluster.fail(oldMaster);
        this.logger.getLogger().warning("Shut down master");
        cluster.await(ClusterManager.masterAvailable(oldMaster));
        long end = System.nanoTime();
        this.logger.getLogger().warning("Failover took:" + (end - start) / 1000000L + "ms");
        repairKit.repair();
        Thread.sleep(3000L);
        clusterManager.safeShutdown();
    }

    @Test
    public void testFailOver() throws Throwable {
        this.testFailOver(this.clusterSize);
    }
}

