/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.util.ArrayList;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.InstanceId;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.test.LoggerRule;
import org.neo4j.test.TargetDirectory;

public class ClusterPartitionTestIT {
    @Rule
    public LoggerRule logger = new LoggerRule();
    @Rule
    public TargetDirectory.TestDirectory dir = TargetDirectory.testDirForTest(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void isolatedMasterShouldRemoveSelfFromCluster() throws Throwable {
        int clusterSize = 3;
        ClusterManager manager = ((ClusterManager.Builder)((ClusterManager.Builder)new ClusterManager.Builder().withRootDirectory(this.dir.cleanDirectory("testcluster")).withCluster((Supplier)ClusterManager.clusterOfSize(clusterSize))).withSharedConfig(MapUtil.stringMap((String[])new String[]{ClusterSettings.heartbeat_interval.name(), "1"}))).build();
        try {
            manager.start();
            ClusterManager.ManagedCluster cluster = manager.getCluster();
            cluster.await(ClusterManager.allSeesAllAsAvailable());
            cluster.await(ClusterManager.masterAvailable(new HighlyAvailableGraphDatabase[0]));
            ArrayList<HighlyAvailableGraphDatabase> failed = new ArrayList<HighlyAvailableGraphDatabase>();
            ArrayList<ClusterManager.RepairKit> repairKits = new ArrayList<ClusterManager.RepairKit>();
            HighlyAvailableGraphDatabase oldMaster = cluster.getMaster();
            failed.add(oldMaster);
            repairKits.add(cluster.fail(oldMaster, false, ClusterManager.NetworkFlag.values()));
            cluster.await(this.oldMasterEvicted(oldMaster), 20);
        }
        finally {
            manager.safeShutdown();
        }
    }

    private Predicate<ClusterManager.ManagedCluster> oldMasterEvicted(HighlyAvailableGraphDatabase oldMaster) {
        return managedCluster -> {
            InstanceId oldMasterServerId = managedCluster.getServerId(oldMaster);
            Iterable<HighlyAvailableGraphDatabase> members = managedCluster.getAllMembers(new HighlyAvailableGraphDatabase[0]);
            for (HighlyAvailableGraphDatabase member : members) {
                if (!oldMasterServerId.equals((Object)managedCluster.getServerId(member)) || !member.role().equals("UNKNOWN")) continue;
                return true;
            }
            return false;
        };
    }
}

