/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory;

import java.util.Collections;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.factory.HighlyAvailableGraphDatabaseFactory;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.ha.ClusterManager;

public class TestHighlyAvailableGraphDatabaseFactory
extends HighlyAvailableGraphDatabaseFactory {
    protected void configure(GraphDatabaseBuilder builder) {
        super.configure(builder);
        builder.setConfig(ClusterManager.CONFIG_FOR_SINGLE_JVM_CLUSTER);
        builder.setConfig(GraphDatabaseSettings.store_internal_log_level, "DEBUG");
    }

    public TestHighlyAvailableGraphDatabaseFactory addKernelExtensions(Iterable<KernelExtensionFactory<?>> newKernelExtensions) {
        this.getCurrentState().addKernelExtensions(newKernelExtensions);
        return this;
    }

    public TestHighlyAvailableGraphDatabaseFactory addKernelExtension(KernelExtensionFactory<?> newKernelExtension) {
        return this.addKernelExtensions(Collections.singletonList(newKernelExtension));
    }

    public TestHighlyAvailableGraphDatabaseFactory setKernelExtensions(Iterable<KernelExtensionFactory<?>> newKernelExtensions) {
        this.getCurrentState().setKernelExtensions(newKernelExtensions);
        return this;
    }
}

