/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.InstanceId;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.UpdatePuller;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.test.ha.ClusterRule;

public class UpdatePullerSwitchIT {
    @Rule
    public final ClusterRule clusterRule = new ClusterRule(this.getClass());
    private ClusterManager.ManagedCluster managedCluster;

    @Before
    public void setup() throws Exception {
        this.managedCluster = ((ClusterRule)((ClusterRule)((ClusterRule)this.clusterRule.withCluster((Supplier)ClusterManager.clusterOfSize(2))).withSharedSetting(HaSettings.tx_push_factor, "0")).withSharedSetting(HaSettings.pull_interval, "100s")).withFirstInstanceId(6).startCluster();
    }

    @Test
    public void updatePullerSwitchOnNodeModeSwitch() throws Throwable {
        String masterLabel = "masterLabel";
        this.createLabeledNodeOnMaster(masterLabel);
        this.pullUpdatesOnSlave();
        this.checkLabeledNodeExistanceOnSlave(masterLabel);
        this.verifyUpdatePullerThreads();
        ClusterManager.RepairKit initialMasterRepairKit = this.managedCluster.shutdown(this.managedCluster.getMaster());
        this.managedCluster.await(ClusterManager.masterAvailable(new HighlyAvailableGraphDatabase[0]));
        String pretenderMasterLabel = "pretenderMasterLabel";
        this.createLabeledNodeOnMaster(pretenderMasterLabel);
        initialMasterRepairKit.repair();
        this.managedCluster.await(ClusterManager.masterSeesSlavesAsAvailable(1));
        this.pullUpdatesOnSlave();
        this.checkLabeledNodeExistanceOnSlave(pretenderMasterLabel);
        this.verifyUpdatePullerThreads();
        ClusterManager.RepairKit justiceRepairKit = this.managedCluster.shutdown(this.managedCluster.getMaster());
        this.managedCluster.await(ClusterManager.masterAvailable(new HighlyAvailableGraphDatabase[0]));
        String justicePrevailedLabel = "justice prevailed";
        this.createLabeledNodeOnMaster(justicePrevailedLabel);
        justiceRepairKit.repair();
        this.managedCluster.await(ClusterManager.masterSeesSlavesAsAvailable(1));
        this.pullUpdatesOnSlave();
        this.checkLabeledNodeExistanceOnSlave(justicePrevailedLabel);
        this.verifyUpdatePullerThreads();
    }

    private void verifyUpdatePullerThreads() {
        InstanceId masterId = (InstanceId)((Config)this.managedCluster.getMaster().getDependencyResolver().resolveDependency(Config.class)).get(ClusterSettings.server_id);
        InstanceId slaveId = (InstanceId)((Config)this.managedCluster.getAnySlave(new HighlyAvailableGraphDatabase[0]).getDependencyResolver().resolveDependency(Config.class)).get(ClusterSettings.server_id);
        Map<Thread, StackTraceElement[]> allStackTraces = Thread.getAllStackTraces();
        Set<Thread> threads = allStackTraces.keySet();
        Assert.assertNull((String)"Master should not have any puller threads", (Object)this.findThreadWithPrefix(threads, "UpdatePuller@" + masterId));
        Assert.assertNotNull((String)"Slave should have active puller thread", (Object)this.findThreadWithPrefix(threads, "UpdatePuller@" + slaveId));
    }

    private String findThreadWithPrefix(Set<Thread> threads, String prefix) {
        for (Thread thread : threads) {
            if (!thread.getName().startsWith(prefix)) continue;
            return thread.getName();
        }
        return null;
    }

    private void pullUpdatesOnSlave() throws InterruptedException {
        UpdatePuller updatePuller = (UpdatePuller)this.managedCluster.getAnySlave(new HighlyAvailableGraphDatabase[0]).getDependencyResolver().resolveDependency(UpdatePuller.class);
        Assert.assertTrue((String)"We should always have some updates to pull", (boolean)updatePuller.tryPullUpdates());
    }

    private void checkLabeledNodeExistanceOnSlave(String label) {
        HighlyAvailableGraphDatabase slave = this.managedCluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        try (Transaction transaction = slave.beginTx();){
            this.checkNodeWithLabelExists(slave, label);
        }
    }

    private void createLabeledNodeOnMaster(String label) {
        HighlyAvailableGraphDatabase master = this.managedCluster.getMaster();
        try (Transaction transaction = master.beginTx();){
            Node masterNode = master.createNode();
            masterNode.addLabel(Label.label((String)label));
            transaction.success();
        }
    }

    private void checkNodeWithLabelExists(HighlyAvailableGraphDatabase database, String label) {
        ResourceIterator slaveNodes = database.findNodes(Label.label((String)label));
        Assert.assertEquals((long)1L, (long)Iterators.asList((Iterator)slaveNodes).size());
    }
}

