/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.lock;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.com.ComException;
import org.neo4j.com.RequestContext;
import org.neo4j.com.Response;
import org.neo4j.graphdb.TransientDatabaseFailureException;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.lock.DistributedLockFailureException;
import org.neo4j.kernel.ha.lock.LocalDeadlockDetectedException;
import org.neo4j.kernel.ha.lock.LockResult;
import org.neo4j.kernel.impl.locking.LockClientStoppedException;
import org.neo4j.kernel.impl.locking.LockType;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.storageengine.api.lock.AcquireLockTimeoutException;
import org.neo4j.storageengine.api.lock.ResourceType;

class SlaveLocksClient
implements Locks.Client {
    private final Master master;
    private final Locks.Client client;
    private final Locks localLockManager;
    private final RequestContextFactory requestContextFactory;
    private final AvailabilityGuard availabilityGuard;
    private final Map<ResourceType, Map<Long, AtomicInteger>> sharedLocks;
    private final Map<ResourceType, Map<Long, AtomicInteger>> exclusiveLocks;
    private final Log log;
    private final boolean txTerminationAwareLocks;
    private boolean initialized;
    private volatile boolean stopped;

    public SlaveLocksClient(Master master, Locks.Client local, Locks localLockManager, RequestContextFactory requestContextFactory, AvailabilityGuard availabilityGuard, LogProvider logProvider, boolean txTerminationAwareLocks) {
        this.master = master;
        this.client = local;
        this.localLockManager = localLockManager;
        this.requestContextFactory = requestContextFactory;
        this.availabilityGuard = availabilityGuard;
        this.log = logProvider.getLog(this.getClass());
        this.txTerminationAwareLocks = txTerminationAwareLocks;
        this.sharedLocks = new HashMap<ResourceType, Map<Long, AtomicInteger>>();
        this.exclusiveLocks = new HashMap<ResourceType, Map<Long, AtomicInteger>>();
    }

    private Map<Long, AtomicInteger> getLockMap(Map<ResourceType, Map<Long, AtomicInteger>> resourceMap, ResourceType resourceType) {
        Map<Long, AtomicInteger> lockMap = resourceMap.get(resourceType);
        if (lockMap == null) {
            lockMap = new HashMap<Long, AtomicInteger>();
            resourceMap.put(resourceType, lockMap);
        }
        return lockMap;
    }

    public void acquireShared(ResourceType resourceType, long resourceId) throws AcquireLockTimeoutException {
        this.assertNotStopped();
        Map<Long, AtomicInteger> lockMap = this.getLockMap(this.sharedLocks, resourceType);
        AtomicInteger preExistingLock = lockMap.get(resourceId);
        if (preExistingLock != null) {
            preExistingLock.incrementAndGet();
        } else if (this.getReadLockOnMaster(resourceType, resourceId)) {
            if (this.client.trySharedLock(resourceType, resourceId)) {
                lockMap.put(resourceId, new AtomicInteger(1));
            } else {
                throw new LocalDeadlockDetectedException(this.client, this.localLockManager, resourceType, resourceId, LockType.READ);
            }
        }
    }

    public void acquireExclusive(ResourceType resourceType, long resourceId) throws AcquireLockTimeoutException {
        this.assertNotStopped();
        Map<Long, AtomicInteger> lockMap = this.getLockMap(this.exclusiveLocks, resourceType);
        AtomicInteger preExistingLock = lockMap.get(resourceId);
        if (preExistingLock != null) {
            preExistingLock.incrementAndGet();
        } else if (this.acquireExclusiveOnMaster(resourceType, resourceId)) {
            if (this.client.tryExclusiveLock(resourceType, resourceId)) {
                lockMap.put(resourceId, new AtomicInteger(1));
            } else {
                throw new LocalDeadlockDetectedException(this.client, this.localLockManager, resourceType, resourceId, LockType.WRITE);
            }
        }
    }

    public boolean tryExclusiveLock(ResourceType resourceType, long resourceId) {
        throw this.newUnsupportedDirectTryLockUsageException();
    }

    public boolean trySharedLock(ResourceType resourceType, long resourceId) {
        throw this.newUnsupportedDirectTryLockUsageException();
    }

    public void releaseShared(ResourceType resourceType, long resourceId) {
        this.assertNotStopped();
        Map<Long, AtomicInteger> lockMap = this.getLockMap(this.sharedLocks, resourceType);
        AtomicInteger counter = lockMap.get(resourceId);
        if (counter == null) {
            throw new IllegalStateException(this + " cannot release lock it does not hold: SHARED " + resourceType + "[" + resourceId + "]");
        }
        if (counter.decrementAndGet() == 0) {
            lockMap.remove(resourceId);
            this.client.releaseShared(resourceType, resourceId);
        }
    }

    public void releaseExclusive(ResourceType resourceType, long resourceId) {
        this.assertNotStopped();
        Map<Long, AtomicInteger> lockMap = this.getLockMap(this.exclusiveLocks, resourceType);
        AtomicInteger counter = lockMap.get(resourceId);
        if (counter == null) {
            throw new IllegalStateException(this + " cannot release lock it does not hold: EXCLUSIVE " + resourceType + "[" + resourceId + "]");
        }
        if (counter.decrementAndGet() == 0) {
            lockMap.remove(resourceId);
            this.client.releaseExclusive(resourceType, resourceId);
        }
    }

    public void stop() {
        if (this.txTerminationAwareLocks) {
            this.client.stop();
            this.stopLockSessionOnMaster();
            this.stopped = true;
        }
    }

    public void close() {
        this.client.close();
        this.sharedLocks.clear();
        this.exclusiveLocks.clear();
        if (this.initialized) {
            if (!this.stopped) {
                this.closeLockSessionOnMaster();
                this.stopped = true;
            }
            this.initialized = false;
        }
    }

    public int getLockSessionId() {
        this.assertNotStopped();
        return this.initialized ? this.client.getLockSessionId() : -1;
    }

    private void stopLockSessionOnMaster() {
        try {
            this.endLockSessionOnMaster(false);
        }
        catch (Throwable t) {
            this.log.warn("Unable to stop lock session on master", t);
        }
    }

    private void closeLockSessionOnMaster() {
        this.endLockSessionOnMaster(true);
    }

    private void endLockSessionOnMaster(boolean success) {
        try {
            Response<Void> ignored = this.master.endLockSession(this.newRequestContextFor(this.client), success);
            Throwable throwable = null;
            if (ignored != null) {
                if (throwable != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    ignored.close();
                }
            }
        }
        catch (ComException e) {
            throw new DistributedLockFailureException("Failed to end the lock session on the master (which implies releasing all held locks)", this.master, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean getReadLockOnMaster(ResourceType resourceType, long resourceId) {
        if (resourceType != ResourceTypes.NODE && resourceType != ResourceTypes.RELATIONSHIP && resourceType != ResourceTypes.GRAPH_PROPS) {
            if (resourceType != ResourceTypes.LEGACY_INDEX) return true;
        }
        this.makeSureTxHasBeenInitialized();
        RequestContext requestContext = this.newRequestContextFor(this);
        try (Response<LockResult> response = this.master.acquireSharedLock(requestContext, resourceType, resourceId);){
            boolean bl = this.receiveLockResponse(response);
            return bl;
        }
        catch (ComException e) {
            throw new DistributedLockFailureException("Cannot get shared lock on master", this.master, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean acquireExclusiveOnMaster(ResourceType resourceType, long resourceId) {
        this.makeSureTxHasBeenInitialized();
        RequestContext requestContext = this.newRequestContextFor(this);
        try (Response<LockResult> response = this.master.acquireExclusiveLock(requestContext, resourceType, resourceId);){
            boolean bl = this.receiveLockResponse(response);
            return bl;
        }
        catch (ComException e) {
            throw new DistributedLockFailureException("Cannot get exclusive lock on master", this.master, e);
        }
    }

    private boolean receiveLockResponse(Response<LockResult> response) {
        LockResult result = (LockResult)response.response();
        switch (result.getStatus()) {
            case DEAD_LOCKED: {
                throw new DeadlockDetectedException(result.getMessage());
            }
            case NOT_LOCKED: {
                throw new UnsupportedOperationException();
            }
            case OK_LOCKED: {
                break;
            }
            default: {
                throw new UnsupportedOperationException(result.toString());
            }
        }
        return true;
    }

    private void makeSureTxHasBeenInitialized() {
        try {
            this.availabilityGuard.checkAvailable();
        }
        catch (AvailabilityGuard.UnavailableException e) {
            throw new TransientDatabaseFailureException("Database not available", (Throwable)e);
        }
        if (!this.initialized) {
            try {
                Response<Void> ignored = this.master.newLockSession(this.newRequestContextFor(this.client));
                Throwable throwable = null;
                if (ignored != null) {
                    if (throwable != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        ignored.close();
                    }
                }
            }
            catch (Exception exception) {
                ComException e = exception instanceof ComException ? (ComException)((Object)exception) : new ComException((Throwable)exception);
                throw new DistributedLockFailureException("Failed to start a new lock session on master", this.master, e);
            }
            this.initialized = true;
        }
    }

    private RequestContext newRequestContextFor(Locks.Client client) {
        return this.requestContextFactory.newRequestContext(client.getLockSessionId());
    }

    private void assertNotStopped() {
        if (this.stopped) {
            throw new LockClientStoppedException((Locks.Client)this);
        }
    }

    private UnsupportedOperationException newUnsupportedDirectTryLockUsageException() {
        return new UnsupportedOperationException("Distributed tryLocks are not supported. They only work with local lock managers.");
    }
}

