/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.lock;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.test.ha.ClusterRule;

public class ClusterLocksIT {
    private static final long TIMEOUT_MILLIS = 120000L;
    @Rule
    public final ClusterRule clusterRule = new ClusterRule(this.getClass());
    private ClusterManager.ManagedCluster cluster;
    private Label testLabel = Label.label((String)"testLabel");

    @Before
    public void setUp() throws Exception {
        this.cluster = ((ClusterRule)this.clusterRule.withSharedSetting(HaSettings.tx_push_factor, "2")).startCluster();
    }

    @Test(timeout=120000L)
    public void lockCleanupOnModeSwitch() throws Throwable {
        HighlyAvailableGraphDatabase master = this.cluster.getMaster();
        this.createNodeOnMaster(this.testLabel, master);
        HighlyAvailableGraphDatabase slave = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        ClusterManager.RepairKit repairKit = this.takeExclusiveLockAndKillSlave(this.testLabel, slave);
        repairKit.repair();
        this.cluster.await(ClusterManager.allSeesAllAsAvailable());
        HighlyAvailableGraphDatabase clusterMaster = this.cluster.getMaster();
        this.takeExclusiveLockOnSameNodeAfterSwitch(this.testLabel, master, clusterMaster);
    }

    @Test
    public void aPendingMemberShouldBeAbleToServeReads() throws Throwable {
        this.createNodeOnMaster(this.testLabel, this.cluster.getMaster());
        this.cluster.sync(new HighlyAvailableGraphDatabase[0]);
        final HighlyAvailableGraphDatabase slave = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        final AtomicBoolean run = new AtomicBoolean(true);
        final AtomicReference ref = new AtomicReference();
        Thread thread = new Thread(){

            @Override
            public void run() {
                while (run.get()) {
                    try {
                        Transaction tx = slave.beginTx();
                        Throwable throwable = null;
                        try {
                            Node single = (Node)Iterables.single((Iterable)slave.getAllNodes());
                            Label label = (Label)Iterables.single((Iterable)single.getLabels());
                            Assert.assertEquals((Object)ClusterLocksIT.this.testLabel, (Object)label);
                            tx.success();
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (tx == null) continue;
                            if (throwable != null) {
                                try {
                                    tx.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            tx.close();
                        }
                    }
                    catch (TransactionTerminatedException tx) {
                    }
                    catch (Throwable t) {
                        ref.compareAndSet(null, t);
                    }
                }
            }
        };
        thread.start();
        this.cluster.fail(slave, ClusterManager.NetworkFlag.values());
        this.cluster.await(ClusterManager.instanceEvicted(slave), 20);
        run.set(false);
        thread.join();
        Assert.assertNull(ref.get());
    }

    private void takeExclusiveLockOnSameNodeAfterSwitch(Label testLabel, HighlyAvailableGraphDatabase master, HighlyAvailableGraphDatabase db) throws EntityNotFoundException {
        try (Transaction transaction = db.beginTx();){
            Node node = this.getNode(master, testLabel);
            transaction.acquireWriteLock((PropertyContainer)node);
            node.setProperty("key", (Object)"value");
            transaction.success();
        }
    }

    private ClusterManager.RepairKit takeExclusiveLockAndKillSlave(Label testLabel, HighlyAvailableGraphDatabase db) throws EntityNotFoundException {
        Transaction transaction = db.beginTx();
        Node node = this.getNode(db, testLabel);
        transaction.acquireWriteLock((PropertyContainer)node);
        return this.cluster.shutdown(db);
    }

    private void createNodeOnMaster(Label testLabel, HighlyAvailableGraphDatabase master) {
        try (Transaction transaction = master.beginTx();){
            master.createNode(new Label[]{testLabel});
            transaction.success();
        }
    }

    private Node getNode(HighlyAvailableGraphDatabase db, Label testLabel) throws EntityNotFoundException {
        return (Node)db.findNodes(testLabel).stream().findFirst().orElseThrow(() -> new EntityNotFoundException(EntityType.NODE, 0L));
    }
}

