/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.TransactionTemplate;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.configuration.Settings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.test.ha.ClusterRule;

public class BiggerThanLogTxIT {
    private static final String ROTATION_THRESHOLD = "1M";
    @Rule
    public ClusterRule clusterRule = new ClusterRule(this.getClass()).withSharedSetting(GraphDatabaseSettings.logical_log_rotation_threshold, "1M");
    protected ClusterManager.ManagedCluster cluster;
    private TransactionTemplate template = new TransactionTemplate().retries(10).backoff(3L, TimeUnit.SECONDS);

    @Before
    public void setup() throws Exception {
        this.cluster = this.clusterRule.startCluster();
    }

    @Test
    public void shouldHandleSlaveCommittingLargeTx() throws Exception {
        HighlyAvailableGraphDatabase slave = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        long initialNodeCount = this.nodeCount((GraphDatabaseService)slave);
        this.cluster.info("Before commit large");
        int nodeCount = this.commitLargeTx((GraphDatabaseService)slave);
        this.cluster.info("Before sync");
        this.cluster.sync(new HighlyAvailableGraphDatabase[0]);
        this.cluster.info("After sync");
        this.assertAllMembersHasNodeCount(initialNodeCount + (long)nodeCount);
        this.cluster.info("Before commit small");
        this.commitSmallTx((GraphDatabaseService)this.cluster.getMaster());
        this.cluster.info("Before sync small");
        this.cluster.sync(new HighlyAvailableGraphDatabase[0]);
        this.cluster.info("After sync small");
        this.assertAllMembersHasNodeCount(initialNodeCount + (long)nodeCount + 1L);
    }

    @Test
    public void shouldHandleMasterCommittingLargeTx() throws Exception {
        HighlyAvailableGraphDatabase slave = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        long initialNodeCount = this.nodeCount((GraphDatabaseService)slave);
        int nodeCount = this.commitLargeTx((GraphDatabaseService)this.cluster.getMaster());
        this.cluster.sync(new HighlyAvailableGraphDatabase[0]);
        this.assertAllMembersHasNodeCount(initialNodeCount + (long)nodeCount);
        this.commitSmallTx((GraphDatabaseService)this.cluster.getMaster());
        this.cluster.sync(new HighlyAvailableGraphDatabase[0]);
        this.assertAllMembersHasNodeCount(initialNodeCount + (long)nodeCount + 1L);
    }

    private void commitSmallTx(GraphDatabaseService db) {
        try (Transaction transaction = db.beginTx();){
            db.createNode();
            transaction.success();
        }
    }

    private long nodeCount(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            long count = Iterables.count((Iterable)db.getAllNodes());
            tx.success();
            long l = count;
            return l;
        }
    }

    private void assertAllMembersHasNodeCount(long expectedNodeCount) {
        for (GraphDatabaseService graphDatabaseService : this.cluster.getAllMembers(new HighlyAvailableGraphDatabase[0])) {
            if (expectedNodeCount != this.nodeCount(graphDatabaseService)) {
                for (int i = 0; i < 100; ++i) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    long count = this.nodeCount(graphDatabaseService);
                    if (expectedNodeCount == count) break;
                    try {
                        this.cluster.sync(new HighlyAvailableGraphDatabase[0]);
                        continue;
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            Assert.assertEquals((long)expectedNodeCount, (long)this.nodeCount(graphDatabaseService));
        }
    }

    private int commitLargeTx(GraphDatabaseService db) {
        return (Integer)this.template.with(db).execute(transaction -> {
            long rotationThreshold = Settings.parseLongWithUnit((String)ROTATION_THRESHOLD);
            int nodeCount = 100;
            byte[] arrayProperty = new byte[(int)(rotationThreshold / (long)nodeCount)];
            for (int i = 0; i < nodeCount; ++i) {
                Node node = db.createNode();
                node.setProperty("name", (Object)("big" + i));
                node.setProperty("data", (Object)arrayProperty);
            }
            return nodeCount;
        });
    }
}

