/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory;

import java.io.File;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.factory.TestHighlyAvailableGraphDatabaseFactory;
import org.neo4j.test.rule.TargetDirectory;

public class PlatformConstraintGraphDatabaseFactoryTest {
    @Rule
    public TargetDirectory.TestDirectory storeDir = TargetDirectory.testDirForTest(this.getClass());
    private File workingDir;

    @Before
    public void setup() {
        this.workingDir = this.storeDir.directory("working");
    }

    @Test
    public void shouldFailToStartWithCustomIOConfigurationTest() {
        try {
            this.createGraphDatabaseService();
            Assert.fail((String)"Should not have created database with custom IO configuration and HA mode.");
        }
        catch (RuntimeException ex) {
            Assert.assertEquals((Object)"HA mode not allowed with custom IO integrations", (Object)ex.getMessage());
        }
    }

    private GraphDatabaseService createGraphDatabaseService() {
        return new TestHighlyAvailableGraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.workingDir).setConfig(GraphDatabaseSettings.pagecache_swapper, "custom").setConfig(ClusterSettings.initial_hosts, "127.0.0.1:5001").setConfig(ClusterSettings.server_id, "1").newGraphDatabase();
    }
}

