/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ha;

import java.util.concurrent.Future;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.api.integrationtest.UniquenessConstraintValidationConcurrencyIT;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.kernel.impl.util.Listener;
import org.neo4j.test.ha.ClusterRule;
import org.neo4j.test.rule.concurrent.OtherThreadRule;

public class UniquenessConstraintValidationHAIT {
    private static final Label LABEL = Label.label((String)"Label1");
    private static final String PROPERTY_KEY = "key1";
    @Rule
    public final OtherThreadRule<Void> otherThread = new OtherThreadRule();
    @ClassRule
    public static final ClusterRule clusterRule = new ClusterRule(UniquenessConstraintValidationHAIT.class).withInitialDataset((Listener)UniquenessConstraintValidationHAIT.uniquenessConstraint(LABEL, "key1"));

    @Test
    public void shouldAllowCreationOfNonConflictingDataOnSeparateHosts() throws Exception {
        Future created;
        ClusterManager.ManagedCluster cluster = clusterRule.startCluster();
        HighlyAvailableGraphDatabase slave1 = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        HighlyAvailableGraphDatabase slave2 = cluster.getAnySlave(slave1);
        try (Transaction tx = slave1.beginTx();){
            slave1.createNode(new Label[]{LABEL}).setProperty(PROPERTY_KEY, (Object)"value1");
            created = this.otherThread.execute(UniquenessConstraintValidationConcurrencyIT.createNode((GraphDatabaseService)slave2, (String)LABEL.name(), (String)PROPERTY_KEY, (Object)"value2"));
            tx.success();
        }
        Assert.assertTrue((String)"creating non-conflicting data should pass", (boolean)((Boolean)created.get()));
    }

    @Test
    public void shouldPreventConcurrentCreationOfConflictingDataOnSeparateHosts() throws Exception {
        Future created;
        ClusterManager.ManagedCluster cluster = clusterRule.startCluster();
        HighlyAvailableGraphDatabase slave1 = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        HighlyAvailableGraphDatabase slave2 = cluster.getAnySlave(slave1);
        try (Transaction tx = slave1.beginTx();){
            slave1.createNode(new Label[]{LABEL}).setProperty(PROPERTY_KEY, (Object)"value3");
            created = this.otherThread.execute(UniquenessConstraintValidationConcurrencyIT.createNode((GraphDatabaseService)slave2, (String)LABEL.name(), (String)PROPERTY_KEY, (Object)"value3"));
            Assert.assertThat(this.otherThread, (Matcher)OtherThreadRule.isWaiting());
            tx.success();
        }
        Assert.assertFalse((String)"creating violating data should fail", (boolean)((Boolean)created.get()));
    }

    @Test
    public void shouldPreventConcurrentCreationOfConflictingNonStringPropertyOnMasterAndSlave() throws Exception {
        Future created;
        ClusterManager.ManagedCluster cluster = clusterRule.startCluster();
        HighlyAvailableGraphDatabase master = cluster.getMaster();
        HighlyAvailableGraphDatabase slave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        try (Transaction tx = master.beginTx();){
            master.createNode(new Label[]{LABEL}).setProperty(PROPERTY_KEY, (Object)39372);
            created = this.otherThread.execute(UniquenessConstraintValidationConcurrencyIT.createNode((GraphDatabaseService)slave, (String)LABEL.name(), (String)PROPERTY_KEY, (Object)39372));
            Assert.assertThat(this.otherThread, (Matcher)OtherThreadRule.isWaiting());
            tx.success();
        }
        Assert.assertFalse((String)"creating violating data should fail", (boolean)((Boolean)created.get()));
    }

    @Test
    public void shouldAllowOtherHostToCompleteIfFirstHostRollsBackTransaction() throws Exception {
        Future created;
        ClusterManager.ManagedCluster cluster = clusterRule.startCluster();
        HighlyAvailableGraphDatabase slave1 = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        HighlyAvailableGraphDatabase slave2 = cluster.getAnySlave(slave1);
        try (Transaction tx = slave1.beginTx();){
            slave1.createNode(new Label[]{LABEL}).setProperty(PROPERTY_KEY, (Object)"value4");
            created = this.otherThread.execute(UniquenessConstraintValidationConcurrencyIT.createNode((GraphDatabaseService)slave2, (String)LABEL.name(), (String)PROPERTY_KEY, (Object)"value4"));
            Assert.assertThat(this.otherThread, (Matcher)OtherThreadRule.isWaiting());
            tx.failure();
        }
        Assert.assertTrue((String)"creating data that conflicts only with rolled back data should pass", (boolean)((Boolean)created.get()));
    }

    private static Listener<GraphDatabaseService> uniquenessConstraint(Label label, String propertyKey) {
        return db -> {
            try (Transaction tx = db.beginTx();){
                db.schema().constraintFor(label).assertPropertyIsUnique(propertyKey).create();
                tx.success();
            }
        };
    }
}

