/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster.modeswitch;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.kernel.ha.DelegateInvocationHandler;
import org.neo4j.kernel.ha.cluster.modeswitch.AbstractComponentSwitcher;

public class AbstractComponentSwitcherTest {
    @Test
    public void switchesToMaster() throws Throwable {
        DelegateInvocationHandler delegate = new DelegateInvocationHandler(Component.class);
        TestComponentSwitcher switcher = new TestComponentSwitcher((DelegateInvocationHandler<Component>)delegate);
        switcher.switchToMaster();
        Assert.assertEquals(AbstractComponentSwitcherTest.delegateClass(delegate), MasterComponent.class);
    }

    @Test
    public void switchesToSlave() throws Throwable {
        DelegateInvocationHandler delegate = new DelegateInvocationHandler(Component.class);
        TestComponentSwitcher switcher = new TestComponentSwitcher((DelegateInvocationHandler<Component>)delegate);
        switcher.switchToSlave();
        Assert.assertEquals(AbstractComponentSwitcherTest.delegateClass(delegate), SlaveComponent.class);
    }

    @Test
    public void switchesToPending() {
        DelegateInvocationHandler delegate = new DelegateInvocationHandler(Component.class);
        TestComponentSwitcher switcher = new TestComponentSwitcher((DelegateInvocationHandler<Component>)delegate);
        switcher.switchToPending();
        try {
            AbstractComponentSwitcherTest.delegateClass(delegate);
            Assert.fail((String)"Exception expected");
        }
        catch (Throwable throwable) {
            Assert.assertThat((Object)throwable, (Matcher)Matchers.instanceOf(TransactionFailureException.class));
        }
    }

    private static Class<?> delegateClass(DelegateInvocationHandler<?> invocationHandler) throws Throwable {
        return (Class)invocationHandler.invoke(new Object(), Object.class.getMethod("getClass", new Class[0]), new Object[0]);
    }

    private static class SlaveComponent
    implements Component {
        private SlaveComponent() {
        }
    }

    private static class MasterComponent
    implements Component {
        private MasterComponent() {
        }
    }

    private static interface Component {
    }

    private static class TestComponentSwitcher
    extends AbstractComponentSwitcher<Component> {
        TestComponentSwitcher(DelegateInvocationHandler<Component> delegate) {
            super(delegate);
        }

        protected Component getMasterImpl() {
            return new MasterComponent();
        }

        protected Component getSlaveImpl() {
            return new SlaveComponent();
        }
    }
}

