/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.jboss.netty.buffer.ChannelBuffer;
import org.neo4j.com.Client;
import org.neo4j.com.Deserializer;
import org.neo4j.com.Protocol;
import org.neo4j.com.Protocol201;
import org.neo4j.com.ProtocolVersion;
import org.neo4j.com.RequestContext;
import org.neo4j.com.RequestType;
import org.neo4j.com.Response;
import org.neo4j.com.Serializer;
import org.neo4j.com.monitor.RequestMonitor;
import org.neo4j.com.storecopy.ResponseUnpacker;
import org.neo4j.com.storecopy.StoreWriter;
import org.neo4j.kernel.ha.HaRequestType210;
import org.neo4j.kernel.ha.HaRequestTypes;
import org.neo4j.kernel.ha.com.master.HandshakeResult;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.com.slave.MasterClient;
import org.neo4j.kernel.ha.id.IdAllocation;
import org.neo4j.kernel.ha.lock.LockResult;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.store.id.IdRange;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.monitoring.ByteCounterMonitor;
import org.neo4j.logging.LogProvider;
import org.neo4j.storageengine.api.lock.ResourceType;

public class MasterClient210
extends Client<Master>
implements MasterClient {
    public static final ProtocolVersion PROTOCOL_VERSION = new ProtocolVersion(7, 2);
    private final long lockReadTimeoutMillis;
    private final HaRequestTypes requestTypes;

    public MasterClient210(String destinationHostNameOrIp, int destinationPort, String originHostNameOrIp, LogProvider logProvider, StoreId storeId, long readTimeoutMillis, long lockReadTimeoutMillis, int maxConcurrentChannels, int chunkSize, ResponseUnpacker responseUnpacker, ByteCounterMonitor byteCounterMonitor, RequestMonitor requestMonitor, LogEntryReader<ReadableClosablePositionAwareChannel> entryReader) {
        super(destinationHostNameOrIp, destinationPort, originHostNameOrIp, logProvider, storeId, 0x1000000, PROTOCOL_VERSION, readTimeoutMillis, maxConcurrentChannels, chunkSize, responseUnpacker, byteCounterMonitor, requestMonitor, entryReader);
        this.lockReadTimeoutMillis = lockReadTimeoutMillis;
        this.requestTypes = new HaRequestType210(entryReader);
    }

    MasterClient210(String destinationHostNameOrIp, int destinationPort, String originHostNameOrIp, LogProvider logProvider, StoreId storeId, long readTimeoutMillis, long lockReadTimeoutMillis, int maxConcurrentChannels, int chunkSize, ProtocolVersion protocolVersion, ResponseUnpacker responseUnpacker, ByteCounterMonitor byteCounterMonitor, RequestMonitor requestMonitor, LogEntryReader<ReadableClosablePositionAwareChannel> entryReader) {
        super(destinationHostNameOrIp, destinationPort, originHostNameOrIp, logProvider, storeId, 0x1000000, protocolVersion, readTimeoutMillis, maxConcurrentChannels, chunkSize, responseUnpacker, byteCounterMonitor, requestMonitor, entryReader);
        this.lockReadTimeoutMillis = lockReadTimeoutMillis;
        this.requestTypes = new HaRequestType210(entryReader);
    }

    protected Protocol createProtocol(int chunkSize, byte applicationProtocolVersion) {
        return new Protocol201(chunkSize, applicationProtocolVersion, this.getInternalProtocolVersion());
    }

    protected long getReadTimeout(RequestType<Master> type, long readTimeout) {
        if (HaRequestTypes.Type.ACQUIRE_EXCLUSIVE_LOCK.is(type) || HaRequestTypes.Type.ACQUIRE_SHARED_LOCK.is(type)) {
            return this.lockReadTimeoutMillis;
        }
        if (HaRequestTypes.Type.COPY_STORE.is(type)) {
            return readTimeout * 2L;
        }
        return readTimeout;
    }

    protected boolean shouldCheckStoreId(RequestType<Master> type) {
        return !HaRequestTypes.Type.COPY_STORE.is(type);
    }

    @Override
    public Response<IdAllocation> allocateIds(RequestContext context, final IdType idType) {
        return this.sendRequest(this.requestTypes.type(HaRequestTypes.Type.ALLOCATE_IDS), context, new Serializer(){

            public void write(ChannelBuffer buffer) throws IOException {
                buffer.writeByte(idType.ordinal());
            }
        }, (Deserializer)new Deserializer<IdAllocation>(){

            public IdAllocation read(ChannelBuffer buffer, ByteBuffer temporaryBuffer) {
                return MasterClient210.readIdAllocation(buffer);
            }
        });
    }

    @Override
    public Response<Integer> createRelationshipType(RequestContext context, final String name) {
        return this.sendRequest(this.requestTypes.type(HaRequestTypes.Type.CREATE_RELATIONSHIP_TYPE), context, new Serializer(){

            public void write(ChannelBuffer buffer) throws IOException {
                Protocol.writeString((ChannelBuffer)buffer, (String)name);
            }
        }, (Deserializer)new Deserializer<Integer>(){

            public Integer read(ChannelBuffer buffer, ByteBuffer temporaryBuffer) throws IOException {
                return buffer.readInt();
            }
        });
    }

    @Override
    public Response<Integer> createPropertyKey(RequestContext context, final String name) {
        return this.sendRequest(this.requestTypes.type(HaRequestTypes.Type.CREATE_PROPERTY_KEY), context, new Serializer(){

            public void write(ChannelBuffer buffer) throws IOException {
                Protocol.writeString((ChannelBuffer)buffer, (String)name);
            }
        }, (Deserializer)new Deserializer<Integer>(){

            public Integer read(ChannelBuffer buffer, ByteBuffer temporaryBuffer) throws IOException {
                return buffer.readInt();
            }
        });
    }

    @Override
    public Response<Integer> createLabel(RequestContext context, final String name) {
        return this.sendRequest(this.requestTypes.type(HaRequestTypes.Type.CREATE_LABEL), context, new Serializer(){

            public void write(ChannelBuffer buffer) throws IOException {
                Protocol.writeString((ChannelBuffer)buffer, (String)name);
            }
        }, (Deserializer)new Deserializer<Integer>(){

            public Integer read(ChannelBuffer buffer, ByteBuffer temporaryBuffer) throws IOException {
                return buffer.readInt();
            }
        });
    }

    @Override
    public Response<Void> newLockSession(RequestContext context) {
        return this.sendRequest(this.requestTypes.type(HaRequestTypes.Type.NEW_LOCK_SESSION), context, Protocol.EMPTY_SERIALIZER, Protocol.VOID_DESERIALIZER);
    }

    @Override
    public Response<LockResult> acquireSharedLock(RequestContext context, ResourceType type, long ... resourceIds) {
        return this.sendRequest(this.requestTypes.type(HaRequestTypes.Type.ACQUIRE_SHARED_LOCK), context, new AcquireLockSerializer(type, resourceIds), LOCK_RESULT_DESERIALIZER);
    }

    @Override
    public Response<LockResult> acquireExclusiveLock(RequestContext context, ResourceType type, long ... resourceIds) {
        return this.sendRequest(this.requestTypes.type(HaRequestTypes.Type.ACQUIRE_EXCLUSIVE_LOCK), context, new AcquireLockSerializer(type, resourceIds), LOCK_RESULT_DESERIALIZER);
    }

    @Override
    public Response<Long> commit(RequestContext context, TransactionRepresentation tx) {
        return this.sendRequest(this.requestTypes.type(HaRequestTypes.Type.COMMIT), context, (Serializer)new Protocol.TransactionSerializer(tx), (Deserializer)new Deserializer<Long>(){

            public Long read(ChannelBuffer buffer, ByteBuffer temporaryBuffer) throws IOException {
                return buffer.readLong();
            }
        });
    }

    @Override
    public Response<Void> endLockSession(RequestContext context, final boolean success) {
        return this.sendRequest(this.requestTypes.type(HaRequestTypes.Type.END_LOCK_SESSION), context, new Serializer(){

            public void write(ChannelBuffer buffer) throws IOException {
                buffer.writeByte(success ? 1 : 0);
            }
        }, Protocol.VOID_DESERIALIZER);
    }

    @Override
    public Response<Void> pullUpdates(RequestContext context) {
        return this.pullUpdates(context, ResponseUnpacker.NO_OP_TX_HANDLER);
    }

    @Override
    public Response<Void> pullUpdates(RequestContext context, ResponseUnpacker.TxHandler txHandler) {
        return this.sendRequest(this.requestTypes.type(HaRequestTypes.Type.PULL_UPDATES), context, Protocol.EMPTY_SERIALIZER, Protocol.VOID_DESERIALIZER, null, txHandler);
    }

    @Override
    public Response<HandshakeResult> handshake(final long txId, StoreId storeId) {
        return this.sendRequest(this.requestTypes.type(HaRequestTypes.Type.HANDSHAKE), RequestContext.EMPTY, new Serializer(){

            public void write(ChannelBuffer buffer) throws IOException {
                buffer.writeLong(txId);
            }
        }, (Deserializer)new Deserializer<HandshakeResult>(){

            public HandshakeResult read(ChannelBuffer buffer, ByteBuffer temporaryBuffer) throws IOException {
                return new HandshakeResult(buffer.readLong(), buffer.readLong());
            }
        }, storeId, ResponseUnpacker.NO_OP_TX_HANDLER);
    }

    @Override
    public Response<Void> copyStore(RequestContext context, StoreWriter writer) {
        context = this.stripFromTransactions(context);
        return this.sendRequest(this.requestTypes.type(HaRequestTypes.Type.COPY_STORE), context, Protocol.EMPTY_SERIALIZER, (Deserializer)new Protocol.FileStreamsDeserializer(writer));
    }

    private RequestContext stripFromTransactions(RequestContext context) {
        return new RequestContext(context.getEpoch(), context.machineId(), context.getEventIdentifier(), 0L, context.getChecksum());
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return PROTOCOL_VERSION;
    }

    protected static IdAllocation readIdAllocation(ChannelBuffer buffer) {
        int numberOfDefragIds = buffer.readInt();
        long[] defragIds = new long[numberOfDefragIds];
        for (int i = 0; i < numberOfDefragIds; ++i) {
            defragIds[i] = buffer.readLong();
        }
        long rangeStart = buffer.readLong();
        int rangeLength = buffer.readInt();
        long highId = buffer.readLong();
        long defragCount = buffer.readLong();
        return new IdAllocation(new IdRange(defragIds, rangeStart, rangeLength), highId, defragCount);
    }

    protected static class AcquireLockSerializer
    implements Serializer {
        private final ResourceType type;
        private final long[] resourceIds;

        AcquireLockSerializer(ResourceType type, long ... resourceIds) {
            this.type = type;
            this.resourceIds = resourceIds;
        }

        public void write(ChannelBuffer buffer) throws IOException {
            buffer.writeInt(this.type.typeId());
            buffer.writeInt(this.resourceIds.length);
            for (long entity : this.resourceIds) {
                buffer.writeLong(entity);
            }
        }
    }
}

