/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster.modeswitch;

import org.neo4j.function.Factory;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.ha.DelegateInvocationHandler;
import org.neo4j.kernel.ha.cluster.modeswitch.AbstractComponentSwitcher;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.lock.SlaveLockManager;
import org.neo4j.kernel.impl.locking.Locks;

public class LockManagerSwitcher
extends AbstractComponentSwitcher<Locks> {
    private final DelegateInvocationHandler<Master> master;
    private final RequestContextFactory requestContextFactory;
    private final AvailabilityGuard availabilityGuard;
    private final Factory<Locks> locksFactory;
    private volatile Locks currentLocks;

    public LockManagerSwitcher(DelegateInvocationHandler<Locks> delegate, DelegateInvocationHandler<Master> master, RequestContextFactory requestContextFactory, AvailabilityGuard availabilityGuard, Factory<Locks> locksFactory) {
        super(delegate);
        this.master = master;
        this.requestContextFactory = requestContextFactory;
        this.availabilityGuard = availabilityGuard;
        this.locksFactory = locksFactory;
    }

    @Override
    protected Locks getMasterImpl() {
        this.currentLocks = (Locks)this.locksFactory.newInstance();
        return this.currentLocks;
    }

    @Override
    protected Locks getSlaveImpl() {
        this.currentLocks = new SlaveLockManager((Locks)this.locksFactory.newInstance(), this.requestContextFactory, this.master.cement(), this.availabilityGuard);
        return this.currentLocks;
    }

    @Override
    protected void shutdownCurrent() {
        super.shutdownCurrent();
        this.closeCurrentLocks();
    }

    private void closeCurrentLocks() {
        if (this.currentLocks != null) {
            this.currentLocks.close();
            this.currentLocks = null;
        }
    }
}

