/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.register.Registers;
import org.neo4j.test.ha.ClusterRule;

public class HACountsPropagationTest {
    private static final int PULL_INTERVAL = 100;
    @ClassRule
    public static ClusterRule clusterRule = new ClusterRule(HACountsPropagationTest.class).withSharedSetting(HaSettings.pull_interval, "100ms");

    @Test
    public void shouldPropagateNodeCountsInHA() throws Throwable {
        ClusterManager.ManagedCluster cluster = clusterRule.startCluster();
        HighlyAvailableGraphDatabase master = cluster.getMaster();
        try (Transaction tx = master.beginTx();){
            master.createNode();
            master.createNode(new Label[]{Label.label((String)"A")});
            tx.success();
        }
        cluster.sync(new HighlyAvailableGraphDatabase[0]);
        for (HighlyAvailableGraphDatabase db : cluster.getAllMembers(new HighlyAvailableGraphDatabase[0])) {
            CountsTracker counts = this.counts((GraphDatabaseAPI)db);
            Assert.assertEquals((long)2L, (long)counts.nodeCount(-1, Registers.newDoubleLongRegister()).readSecond());
            Assert.assertEquals((long)1L, (long)counts.nodeCount(0, Registers.newDoubleLongRegister()).readSecond());
        }
    }

    private CountsTracker counts(GraphDatabaseAPI db) {
        return ((RecordStorageEngine)db.getDependencyResolver().resolveDependency(RecordStorageEngine.class)).testAccessNeoStores().getCounts();
    }

    @Test
    public void shouldPropagateRelationshipCountsInHA() throws Throwable {
        ClusterManager.ManagedCluster cluster = clusterRule.startCluster();
        HighlyAvailableGraphDatabase master = cluster.getMaster();
        try (Transaction tx = master.beginTx();){
            Node left = master.createNode();
            Node right = master.createNode(new Label[]{Label.label((String)"A")});
            left.createRelationshipTo(right, RelationshipType.withName((String)"Type"));
            tx.success();
        }
        cluster.sync(new HighlyAvailableGraphDatabase[0]);
        for (HighlyAvailableGraphDatabase db : cluster.getAllMembers(new HighlyAvailableGraphDatabase[0])) {
            CountsTracker counts = this.counts((GraphDatabaseAPI)db);
            Assert.assertEquals((long)1L, (long)counts.relationshipCount(-1, -1, -1, Registers.newDoubleLongRegister()).readSecond());
            Assert.assertEquals((long)1L, (long)counts.relationshipCount(-1, -1, 0, Registers.newDoubleLongRegister()).readSecond());
            Assert.assertEquals((long)1L, (long)counts.relationshipCount(-1, 0, -1, Registers.newDoubleLongRegister()).readSecond());
            Assert.assertEquals((long)1L, (long)counts.relationshipCount(-1, 0, 0, Registers.newDoubleLongRegister()).readSecond());
        }
    }
}

