/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.util.function.Supplier;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.cluster.InstanceId;
import org.neo4j.function.Suppliers;
import org.neo4j.kernel.ha.UpdatePuller;
import org.neo4j.kernel.ha.UpdatePullingTransactionObligationFulfiller;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberChangeEvent;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberListener;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberStateMachine;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;

public class UpdatePullingTransactionObligationFulfillerTest {
    private final UpdatePuller updatePuller = (UpdatePuller)Mockito.mock(UpdatePuller.class);
    private final HighAvailabilityMemberStateMachine machine = (HighAvailabilityMemberStateMachine)Mockito.mock(HighAvailabilityMemberStateMachine.class);
    private final InstanceId serverId = new InstanceId(42);

    @Before
    public void setup() throws Throwable {
        ((UpdatePuller)Mockito.doAnswer(invocation -> ((UpdatePuller.Condition)invocation.getArguments()[0]).evaluate(33, 34)).when((Object)this.updatePuller)).pullUpdates((UpdatePuller.Condition)Matchers.any(UpdatePuller.Condition.class), Matchers.anyBoolean());
    }

    @Test
    public void shouldNotThrowNPEWhenAskedToFulFilledButNotYetHavingARoleAssigned() throws Throwable {
        UpdatePullingTransactionObligationFulfiller fulfiller = new UpdatePullingTransactionObligationFulfiller(this.updatePuller, this.machine, this.serverId, Suppliers.singleton((Object)Mockito.mock(TransactionIdStore.class)));
        fulfiller.fulfill(1L);
    }

    @Test
    public void shouldUpdateTransactionIdStoreCorrectly() throws Throwable {
        TransactionIdStore store1 = (TransactionIdStore)Mockito.mock(TransactionIdStore.class);
        TransactionIdStore store2 = (TransactionIdStore)Mockito.mock(TransactionIdStore.class);
        Supplier supplier = (Supplier)Mockito.mock(Supplier.class);
        Mockito.when(supplier.get()).thenReturn((Object)store1, (Object[])new TransactionIdStore[]{store2});
        ((HighAvailabilityMemberStateMachine)Mockito.doAnswer(invocation -> {
            ((HighAvailabilityMemberListener)invocation.getArguments()[0]).slaveIsAvailable(new HighAvailabilityMemberChangeEvent(null, null, this.serverId, null, true));
            return null;
        }).when((Object)this.machine)).addHighAvailabilityMemberListener((HighAvailabilityMemberListener)Matchers.any(HighAvailabilityMemberListener.class));
        ((HighAvailabilityMemberStateMachine)Mockito.doAnswer(invocation -> {
            ((HighAvailabilityMemberListener)invocation.getArguments()[0]).instanceStops(new HighAvailabilityMemberChangeEvent(null, null, this.serverId, null, true));
            return null;
        }).when((Object)this.machine)).removeHighAvailabilityMemberListener((HighAvailabilityMemberListener)Matchers.any(HighAvailabilityMemberListener.class));
        UpdatePullingTransactionObligationFulfiller fulfiller = new UpdatePullingTransactionObligationFulfiller(this.updatePuller, this.machine, this.serverId, supplier);
        fulfiller.start();
        fulfiller.fulfill(1L);
        fulfiller.stop();
        fulfiller.fulfill(2L);
        fulfiller.start();
        fulfiller.fulfill(3L);
        fulfiller.stop();
        fulfiller.fulfill(4L);
        ((TransactionIdStore)Mockito.verify((Object)store1, (VerificationMode)Mockito.times((int)1))).getLastClosedTransactionId();
        ((TransactionIdStore)Mockito.verify((Object)store2, (VerificationMode)Mockito.times((int)1))).getLastClosedTransactionId();
    }
}

