/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.lock;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.stubbing.OngoingStubbing;
import org.mockito.verification.VerificationMode;
import org.neo4j.com.ComException;
import org.neo4j.com.RequestContext;
import org.neo4j.com.ResourceReleaser;
import org.neo4j.com.Response;
import org.neo4j.com.TransactionStream;
import org.neo4j.com.TransactionStreamResponse;
import org.neo4j.graphdb.TransientDatabaseFailureException;
import org.neo4j.graphdb.TransientFailureException;
import org.neo4j.helpers.Clock;
import org.neo4j.helpers.FakeClock;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.lock.DistributedLockFailureException;
import org.neo4j.kernel.ha.lock.LockResult;
import org.neo4j.kernel.ha.lock.LockStatus;
import org.neo4j.kernel.ha.lock.SlaveLocksClient;
import org.neo4j.kernel.impl.locking.LockClientStoppedException;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.kernel.impl.locking.community.CommunityLockManger;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;
import org.neo4j.storageengine.api.lock.ResourceType;

public class SlaveLocksClientTest {
    private Master master;
    private Locks lockManager;
    private Locks.Client local;
    private SlaveLocksClient client;
    private AvailabilityGuard availabilityGuard;

    @Before
    public void setUp() throws Exception {
        this.master = (Master)Mockito.mock(Master.class);
        this.availabilityGuard = new AvailabilityGuard((Clock)new FakeClock(), (Log)NullLog.getInstance());
        this.lockManager = new CommunityLockManger();
        this.local = (Locks.Client)Mockito.spy((Object)this.lockManager.newClient());
        LockResult lockResultOk = new LockResult(LockStatus.OK_LOCKED);
        TransactionStreamResponse responseOk = new TransactionStreamResponse((Object)lockResultOk, null, TransactionStream.EMPTY, ResourceReleaser.NO_OP);
        this.whenMasterAcquireShared().thenReturn((Object)responseOk);
        this.whenMasterAcquireExclusive().thenReturn((Object)responseOk);
        this.client = this.newSlaveLocksClient(this.lockManager, true);
    }

    private OngoingStubbing<Response<LockResult>> whenMasterAcquireShared() {
        return Mockito.when((Object)this.master.acquireSharedLock((RequestContext)org.mockito.Matchers.any(RequestContext.class), (ResourceType)org.mockito.Matchers.any(ResourceType.class), (long[])org.mockito.Matchers.anyVararg()));
    }

    private OngoingStubbing<Response<LockResult>> whenMasterAcquireExclusive() {
        return Mockito.when((Object)this.master.acquireExclusiveLock((RequestContext)org.mockito.Matchers.any(RequestContext.class), (ResourceType)org.mockito.Matchers.any(ResourceType.class), (long[])org.mockito.Matchers.anyVararg()));
    }

    @After
    public void tearDown() {
        this.local.close();
    }

    @Test
    public void shouldNotTakeSharedLockOnMasterIfWeAreAlreadyHoldingSaidLock() {
        this.client.acquireShared((ResourceType)ResourceTypes.NODE, 1L);
        this.client.acquireShared((ResourceType)ResourceTypes.NODE, 1L);
        ((Master)Mockito.verify((Object)this.master)).acquireSharedLock(null, (ResourceType)ResourceTypes.NODE, new long[]{1L});
    }

    @Test
    public void shouldNotTakeExclusiveLockOnMasterIfWeAreAlreadyHoldingSaidLock() {
        this.client.acquireExclusive((ResourceType)ResourceTypes.NODE, 1L);
        this.client.acquireExclusive((ResourceType)ResourceTypes.NODE, 1L);
        ((Master)Mockito.verify((Object)this.master)).acquireExclusiveLock(null, (ResourceType)ResourceTypes.NODE, new long[]{1L});
    }

    @Test
    public void shouldAllowAcquiringReleasingAndReacquiringExclusive() throws Exception {
        this.client.acquireExclusive((ResourceType)ResourceTypes.NODE, 1L);
        this.client.releaseExclusive((ResourceType)ResourceTypes.NODE, 1L);
        this.client.acquireExclusive((ResourceType)ResourceTypes.NODE, 1L);
        this.client.releaseExclusive((ResourceType)ResourceTypes.NODE, 1L);
        ((Locks.Client)Mockito.verify((Object)this.local, (VerificationMode)Mockito.times((int)2))).tryExclusiveLock((ResourceType)ResourceTypes.NODE, 1L);
        ((Locks.Client)Mockito.verify((Object)this.local, (VerificationMode)Mockito.times((int)2))).releaseExclusive((ResourceType)ResourceTypes.NODE, 1L);
    }

    @Test
    public void shouldAllowAcquiringReleasingAndReacquiringShared() throws Exception {
        this.client.acquireShared((ResourceType)ResourceTypes.NODE, 1L);
        this.client.releaseShared((ResourceType)ResourceTypes.NODE, 1L);
        this.client.acquireShared((ResourceType)ResourceTypes.NODE, 1L);
        this.client.releaseShared((ResourceType)ResourceTypes.NODE, 1L);
        ((Locks.Client)Mockito.verify((Object)this.local, (VerificationMode)Mockito.times((int)2))).trySharedLock((ResourceType)ResourceTypes.NODE, 1L);
        ((Locks.Client)Mockito.verify((Object)this.local, (VerificationMode)Mockito.times((int)2))).releaseShared((ResourceType)ResourceTypes.NODE, 1L);
    }

    @Test
    public void shouldNotTalkToLocalLocksOnReentrancyExclusive() throws Exception {
        this.client.acquireExclusive((ResourceType)ResourceTypes.NODE, 1L);
        this.client.acquireExclusive((ResourceType)ResourceTypes.NODE, 1L);
        this.client.releaseExclusive((ResourceType)ResourceTypes.NODE, 1L);
        ((Locks.Client)Mockito.verify((Object)this.local, (VerificationMode)Mockito.times((int)1))).tryExclusiveLock((ResourceType)ResourceTypes.NODE, 1L);
        ((Locks.Client)Mockito.verify((Object)this.local, (VerificationMode)Mockito.times((int)0))).releaseExclusive((ResourceType)ResourceTypes.NODE, 1L);
    }

    @Test
    public void shouldNotTalkToLocalLocksOnReentrancyShared() throws Exception {
        this.client.acquireShared((ResourceType)ResourceTypes.NODE, 1L);
        this.client.acquireShared((ResourceType)ResourceTypes.NODE, 1L);
        this.client.releaseShared((ResourceType)ResourceTypes.NODE, 1L);
        ((Locks.Client)Mockito.verify((Object)this.local, (VerificationMode)Mockito.times((int)1))).trySharedLock((ResourceType)ResourceTypes.NODE, 1L);
        ((Locks.Client)Mockito.verify((Object)this.local, (VerificationMode)Mockito.times((int)0))).releaseShared((ResourceType)ResourceTypes.NODE, 1L);
    }

    @Test
    public void shouldReturnNoLockSessionIfNotInitialized() throws Exception {
        int lockSessionId = this.client.getLockSessionId();
        MatcherAssert.assertThat((Object)lockSessionId, (Matcher)CoreMatchers.equalTo((Object)-1));
    }

    @Test
    public void shouldReturnDelegateIdIfInitialized() throws Exception {
        this.client.acquireExclusive((ResourceType)ResourceTypes.NODE, 1L);
        int lockSessionId = this.client.getLockSessionId();
        MatcherAssert.assertThat((Object)lockSessionId, (Matcher)CoreMatchers.equalTo((Object)this.local.getLockSessionId()));
    }

    @Test(expected=DistributedLockFailureException.class)
    public void mustThrowIfStartingNewLockSessionOnMasterThrowsComException() throws Exception {
        Mockito.when((Object)this.master.newLockSession((RequestContext)org.mockito.Matchers.any(RequestContext.class))).thenThrow(new Throwable[]{new ComException()});
        this.client.acquireShared((ResourceType)ResourceTypes.NODE, 1L);
    }

    @Test(expected=DistributedLockFailureException.class)
    public void mustThrowIfStartingNewLockSessionOnMasterThrowsTransactionFailureException() throws Exception {
        Mockito.when((Object)this.master.newLockSession((RequestContext)org.mockito.Matchers.any(RequestContext.class))).thenThrow(new Throwable[]{new TransactionFailureException((Status)Status.General.DatabaseUnavailable, "Not now", new Object[0])});
        this.client.acquireShared((ResourceType)ResourceTypes.NODE, 1L);
    }

    @Test(expected=DistributedLockFailureException.class)
    public void acquireSharedMustThrowIfMasterThrows() throws Exception {
        this.whenMasterAcquireShared().thenThrow(new Throwable[]{new ComException()});
        this.client.acquireShared((ResourceType)ResourceTypes.NODE, 1L);
    }

    @Test(expected=DistributedLockFailureException.class)
    public void acquireExclusiveMustThrowIfMasterThrows() throws Exception {
        this.whenMasterAcquireExclusive().thenThrow(new Throwable[]{new ComException()});
        this.client.acquireExclusive((ResourceType)ResourceTypes.NODE, 1L);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void tryExclusiveMustBeUnsupported() throws Exception {
        this.client.tryExclusiveLock((ResourceType)ResourceTypes.NODE, 1L);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void trySharedMustBeUnsupported() throws Exception {
        this.client.trySharedLock((ResourceType)ResourceTypes.NODE, 1L);
    }

    @Test(expected=DistributedLockFailureException.class)
    public void closeMustThrowIfMasterThrows() throws Exception {
        Mockito.when((Object)this.master.endLockSession((RequestContext)org.mockito.Matchers.any(RequestContext.class), org.mockito.Matchers.anyBoolean())).thenThrow(new Throwable[]{new ComException()});
        this.client.acquireExclusive((ResourceType)ResourceTypes.NODE, 1L);
        this.client.close();
    }

    @Test
    public void mustCloseLocalClientEvenIfMasterThrows() throws Exception {
        Mockito.when((Object)this.master.endLockSession((RequestContext)org.mockito.Matchers.any(RequestContext.class), org.mockito.Matchers.anyBoolean())).thenThrow(new Throwable[]{new ComException()});
        try {
            this.client.acquireExclusive((ResourceType)ResourceTypes.NODE, 1L);
            this.client.close();
            Assert.fail((String)"Expected client.close to throw");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((Locks.Client)Mockito.verify((Object)this.local)).close();
    }

    @Test(expected=TransientDatabaseFailureException.class)
    public void mustThrowTransientTransactionFailureIfDatabaseUnavailable() throws Exception {
        this.availabilityGuard.shutdown();
        this.client.acquireExclusive((ResourceType)ResourceTypes.NODE, 1L);
    }

    @Test
    public void shouldFailWithTransientErrorOnDbUnavailable() throws Exception {
        this.availabilityGuard.shutdown();
        try {
            this.client.acquireExclusive((ResourceType)ResourceTypes.NODE, 0L);
            Assert.fail((String)"Should fail");
        }
        catch (TransientFailureException transientFailureException) {
            // empty catch block
        }
    }

    @Test(expected=LockClientStoppedException.class)
    public void acquireSharedFailsWhenClientStopped() {
        this.stoppedClient().acquireShared((ResourceType)ResourceTypes.NODE, 1L);
    }

    @Test(expected=LockClientStoppedException.class)
    public void releaseSharedFailsWhenClientStopped() {
        this.stoppedClient().releaseShared((ResourceType)ResourceTypes.NODE, 1L);
    }

    @Test(expected=LockClientStoppedException.class)
    public void acquireExclusiveFailsWhenClientStopped() {
        this.stoppedClient().acquireExclusive((ResourceType)ResourceTypes.NODE, 1L);
    }

    @Test(expected=LockClientStoppedException.class)
    public void releaseExclusiveFailsWhenClientStopped() {
        this.stoppedClient().releaseExclusive((ResourceType)ResourceTypes.NODE, 1L);
    }

    @Test(expected=LockClientStoppedException.class)
    public void getLockSessionIdWhenClientStopped() {
        this.stoppedClient().getLockSessionId();
    }

    @Test
    public void stopLocalLocksAndEndLockSessionOnMasterWhenStopped() {
        this.client.acquireShared((ResourceType)ResourceTypes.NODE, 1L);
        this.client.stop();
        ((Locks.Client)Mockito.verify((Object)this.local)).stop();
        ((Master)Mockito.verify((Object)this.master)).endLockSession((RequestContext)org.mockito.Matchers.any(RequestContext.class), org.mockito.Matchers.eq((boolean)false));
    }

    @Test
    public void closeLocalLocksAndEndLockSessionOnMasterWhenClosed() {
        this.client.acquireShared((ResourceType)ResourceTypes.NODE, 1L);
        this.client.close();
        ((Locks.Client)Mockito.verify((Object)this.local)).close();
        ((Master)Mockito.verify((Object)this.master)).endLockSession((RequestContext)org.mockito.Matchers.any(RequestContext.class), org.mockito.Matchers.eq((boolean)true));
    }

    @Test
    public void closeAfterStopped() {
        this.client.acquireShared((ResourceType)ResourceTypes.NODE, 1L);
        this.client.stop();
        this.client.close();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.master, this.local});
        ((Master)inOrder.verify((Object)this.master)).endLockSession((RequestContext)org.mockito.Matchers.any(RequestContext.class), org.mockito.Matchers.eq((boolean)false));
        ((Locks.Client)inOrder.verify((Object)this.local)).close();
    }

    @Test
    public void closeWhenNotInitialized() {
        this.client.close();
        ((Locks.Client)Mockito.verify((Object)this.local)).close();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.master});
    }

    @Test
    public void stopThrowsWhenMasterCommunicationThrowsComException() {
        ComException error = new ComException("Communication failure");
        Mockito.when((Object)this.master.endLockSession((RequestContext)org.mockito.Matchers.any(RequestContext.class), org.mockito.Matchers.anyBoolean())).thenThrow(new Throwable[]{error});
        try {
            this.client.stop();
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)e, (Matcher)Matchers.instanceOf(DistributedLockFailureException.class));
        }
    }

    @Test
    public void stopThrowsWhenMasterCommunicationThrows() {
        IllegalArgumentException error = new IllegalArgumentException("Wrong params");
        Mockito.when((Object)this.master.endLockSession((RequestContext)org.mockito.Matchers.any(RequestContext.class), org.mockito.Matchers.anyBoolean())).thenThrow(new Throwable[]{error});
        try {
            this.client.stop();
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertEquals((Object)error, (Object)e);
        }
    }

    @Test
    public void stopDoesNothingWhenLocksAreNotTxTerminationAware() {
        SlaveLocksClient client = this.newSlaveLocksClient(this.lockManager, false);
        client.stop();
        ((Locks.Client)Mockito.verify((Object)this.local, (VerificationMode)Mockito.never())).stop();
        ((Master)Mockito.verify((Object)this.master, (VerificationMode)Mockito.never())).endLockSession((RequestContext)org.mockito.Matchers.any(RequestContext.class), org.mockito.Matchers.anyBoolean());
    }

    private SlaveLocksClient newSlaveLocksClient(Locks lockManager, boolean txTerminationAwareLocks) {
        return new SlaveLocksClient(this.master, this.local, lockManager, (RequestContextFactory)Mockito.mock(RequestContextFactory.class), this.availabilityGuard, txTerminationAwareLocks);
    }

    private SlaveLocksClient stoppedClient() {
        this.client.stop();
        return this.client;
    }
}

