/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.util.logging.Level;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.test.ha.ClusterRule;
import org.neo4j.test.rule.LoggerRule;

public class TestBasicHaOperations {
    @ClassRule
    public static LoggerRule logger = new LoggerRule(Level.OFF);
    @ClassRule
    public static ClusterRule clusterRule = new ClusterRule(TestBasicHaOperations.class).withSharedSetting(HaSettings.tx_push_factor, "2");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasicFailover() throws Throwable {
        ClusterManager.ManagedCluster cluster = clusterRule.startCluster();
        HighlyAvailableGraphDatabase master = cluster.getMaster();
        HighlyAvailableGraphDatabase slave1 = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        HighlyAvailableGraphDatabase slave2 = cluster.getAnySlave(slave1);
        long start = System.nanoTime();
        ClusterManager.RepairKit repair = cluster.shutdown(master);
        try {
            logger.getLogger().warning("Shut down master");
            cluster.await(ClusterManager.masterAvailable(new HighlyAvailableGraphDatabase[0]));
            long end = System.nanoTime();
            logger.getLogger().warning("Failover took:" + (end - start) / 1000000L + "ms");
            boolean slave1Master = slave1.isMaster();
            boolean slave2Master = slave2.isMaster();
            if (slave1Master) {
                Assert.assertFalse((boolean)slave2Master);
            } else {
                Assert.assertTrue((boolean)slave2Master);
            }
        }
        finally {
            repair.repair();
        }
    }

    @Test
    public void testBasicPropagationFromSlaveToMaster() throws Throwable {
        long nodeId;
        ClusterManager.ManagedCluster cluster = clusterRule.startCluster();
        HighlyAvailableGraphDatabase master = cluster.getMaster();
        HighlyAvailableGraphDatabase slave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        try (Transaction tx = master.beginTx();){
            Node node = master.createNode();
            nodeId = node.getId();
            node.setProperty("foo", (Object)"bar");
            tx.success();
        }
        cluster.sync(new HighlyAvailableGraphDatabase[0]);
        tx = slave.beginTx();
        var7_5 = null;
        try {
            slave.getNodeById(nodeId).setProperty("foo", (Object)"bar2");
            tx.success();
        }
        catch (Throwable throwable) {
            var7_5 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var7_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var7_5.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = master.beginTx();
        var7_5 = null;
        try {
            Assert.assertEquals((Object)"bar2", (Object)master.getNodeById(nodeId).getProperty("foo"));
            tx.success();
        }
        catch (Throwable throwable) {
            var7_5 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var7_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var7_5.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void testBasicPropagationFromMasterToSlave() throws Throwable {
        String value;
        ClusterManager.ManagedCluster cluster = clusterRule.startCluster();
        long nodeId = 4L;
        HighlyAvailableGraphDatabase master = cluster.getMaster();
        try (Transaction tx = master.beginTx();){
            Node node = master.createNode();
            node.setProperty("Hello", (Object)"World");
            nodeId = node.getId();
            tx.success();
        }
        HighlyAvailableGraphDatabase slave1 = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        try (Transaction tx = slave1.beginTx();){
            value = slave1.getNodeById(nodeId).getProperty("Hello").toString();
            logger.getLogger().info("Hello=" + value);
            Assert.assertEquals((Object)"World", (Object)value);
            tx.success();
        }
        HighlyAvailableGraphDatabase slave2 = cluster.getAnySlave(slave1);
        try (Transaction tx = slave2.beginTx();){
            value = slave2.getNodeById(nodeId).getProperty("Hello").toString();
            logger.getLogger().info("Hello=" + value);
            Assert.assertEquals((Object)"World", (Object)value);
            tx.success();
        }
    }
}

