/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.ha;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.neo4j.backup.OnlineBackupSettings;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.client.Cluster;
import org.neo4j.cluster.client.ClusterClient;
import org.neo4j.cluster.client.ClusterClientModule;
import org.neo4j.cluster.com.NetworkReceiver;
import org.neo4j.cluster.com.NetworkSender;
import org.neo4j.cluster.member.ClusterMemberEvents;
import org.neo4j.cluster.member.ClusterMemberListener;
import org.neo4j.cluster.protocol.cluster.Cluster;
import org.neo4j.cluster.protocol.election.ElectionCredentialsProvider;
import org.neo4j.cluster.protocol.election.NotElectableElectionCredentialsProvider;
import org.neo4j.cluster.protocol.heartbeat.Heartbeat;
import org.neo4j.consistency.store.StoreAssertions;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.factory.HighlyAvailableGraphDatabaseFactory;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.UpdatePuller;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberState;
import org.neo4j.kernel.ha.cluster.member.ClusterMember;
import org.neo4j.kernel.ha.cluster.member.ClusterMembers;
import org.neo4j.kernel.ha.cluster.member.ObservedClusterMembers;
import org.neo4j.kernel.ha.com.master.Slaves;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.NullLogService;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.impl.util.Listener;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;
import org.neo4j.storageengine.api.StorageEngine;

public class ClusterManager
extends LifecycleAdapter {
    private static final int CLUSTER_MIN_PORT = 11000;
    private static final int CLUSTER_MAX_PORT = 21000;
    private static final int HA_MIN_PORT = 21001;
    private static final int HA_MAX_PORT = 31001;
    public static final long DEFAULT_TIMEOUT_SECONDS = 60L;
    public static final Map<String, String> CONFIG_FOR_SINGLE_JVM_CLUSTER = Collections.unmodifiableMap(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.pagecache_memory.name(), "8m"}));
    private final String localAddress = ClusterManager.getLocalAddress();
    private final File root;
    private final Map<String, IntFunction<String>> commonConfig;
    private final Supplier<org.neo4j.cluster.client.Cluster> clustersProvider;
    private final HighlyAvailableGraphDatabaseFactory dbFactory;
    private final StoreDirInitializer storeDirInitializer;
    private final Listener<GraphDatabaseService> initialDatasetCreator;
    private final List<Predicate<ManagedCluster>> availabilityChecks;
    private ManagedCluster managedCluster;
    private final boolean consistencyCheck;
    LifeSupport life;

    public static IntFunction<String> constant(String value) {
        return ignored -> value;
    }

    private ClusterManager(Builder builder) {
        this.clustersProvider = builder.provider;
        this.root = builder.root;
        this.commonConfig = this.withDefaults(builder.commonConfig);
        this.dbFactory = builder.factory;
        this.storeDirInitializer = builder.initializer;
        this.initialDatasetCreator = builder.initialDatasetCreator;
        this.availabilityChecks = builder.availabilityChecks;
        this.consistencyCheck = builder.consistencyCheck;
    }

    private Map<String, IntFunction<String>> withDefaults(Map<String, IntFunction<String>> commonConfig) {
        HashMap<String, IntFunction<String>> result = new HashMap<String, IntFunction<String>>();
        for (Map.Entry<String, String> conf : CONFIG_FOR_SINGLE_JVM_CLUSTER.entrySet()) {
            result.put(conf.getKey(), ClusterManager.constant(conf.getValue()));
        }
        result.putAll(commonConfig);
        return result;
    }

    private static String getLocalAddress() {
        try {
            return InetAddress.getByName(null).getHostAddress();
        }
        catch (UnknownHostException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static Supplier<org.neo4j.cluster.client.Cluster> clusterOfSize(int memberCount) {
        return ClusterManager.clusterOfSize(ClusterManager.getLocalAddress(), memberCount);
    }

    public static Supplier<org.neo4j.cluster.client.Cluster> clusterOfSize(String hostname, int memberCount) {
        return () -> {
            org.neo4j.cluster.client.Cluster cluster = new org.neo4j.cluster.client.Cluster();
            HashSet<Integer> takenPorts = new HashSet<Integer>();
            try {
                for (int i = 0; i < memberCount; ++i) {
                    int port = ClusterManager.findFreePort(11000, 21000, takenPorts);
                    takenPorts.add(port);
                    cluster.getMembers().add(new Cluster.Member(hostname + ":" + port, true));
                }
            }
            catch (IOException e) {
                throw new AssertionError((Object)"Failed to find an open port");
            }
            return cluster;
        };
    }

    private static int findFreePort(int minPort, int maxPort, Set<Integer> except) throws IOException {
        for (int port = minPort; port <= maxPort; ++port) {
            ServerSocket ss;
            if (except.contains(port)) continue;
            try {
                ss = new ServerSocket();
                ss.setReuseAddress(false);
                ss.bind(new InetSocketAddress(port));
                ss.close();
            }
            catch (IOException e) {
                except.add(port);
                continue;
            }
            try {
                ss = new ServerSocket();
                ss.setReuseAddress(false);
                ss.bind(new InetSocketAddress(InetAddress.getLoopbackAddress(), port));
                ss.close();
            }
            catch (IOException e) {
                except.add(port);
                continue;
            }
            try {
                Socket socket = new Socket(InetAddress.getLoopbackAddress(), port);
                socket.close();
                except.add(port);
                continue;
            }
            catch (IOException ex) {
                return port;
            }
        }
        throw new IOException("No open port could be found");
    }

    public static Supplier<org.neo4j.cluster.client.Cluster> clusterWithAdditionalClients(int haMemberCount, int additionalClientCount) {
        return () -> {
            org.neo4j.cluster.client.Cluster cluster = new org.neo4j.cluster.client.Cluster();
            HashSet<Integer> takenPorts = new HashSet<Integer>();
            try {
                int port;
                int i;
                for (i = 0; i < haMemberCount; ++i) {
                    port = ClusterManager.findFreePort(11000, 21000, takenPorts);
                    takenPorts.add(port);
                    cluster.getMembers().add(new Cluster.Member(port, true));
                }
                for (i = 0; i < additionalClientCount; ++i) {
                    port = ClusterManager.findFreePort(11000, 21000, takenPorts);
                    takenPorts.add(port);
                    cluster.getMembers().add(new Cluster.Member(port, false));
                }
            }
            catch (IOException e) {
                throw new AssertionError((Object)"Failed to find an open port");
            }
            return cluster;
        };
    }

    public static Supplier<org.neo4j.cluster.client.Cluster> clusterWithAdditionalArbiters(int haMemberCount, int arbiterCount) {
        return () -> {
            org.neo4j.cluster.client.Cluster cluster = new org.neo4j.cluster.client.Cluster();
            HashSet<Integer> takenPorts = new HashSet<Integer>();
            try {
                int port;
                int i;
                for (i = 0; i < arbiterCount; ++i) {
                    port = ClusterManager.findFreePort(11000, 21000, takenPorts);
                    takenPorts.add(port);
                    cluster.getMembers().add(new Cluster.Member(port, false));
                }
                for (i = 0; i < haMemberCount; ++i) {
                    port = ClusterManager.findFreePort(11000, 21000, takenPorts);
                    takenPorts.add(port);
                    cluster.getMembers().add(new Cluster.Member(port, true));
                }
            }
            catch (IOException e) {
                throw new AssertionError((Object)"Failed to find an open port");
            }
            return cluster;
        };
    }

    public static Predicate<ManagedCluster> masterSeesSlavesAsAvailable(final int count) {
        return new Predicate<ManagedCluster>(){

            @Override
            public boolean test(ManagedCluster cluster) {
                return Iterables.count((Iterable)((Slaves)cluster.getMaster().getDependencyResolver().resolveDependency(Slaves.class)).getSlaves()) >= (long)count;
            }

            public String toString() {
                return "Master should see " + count + " slaves as available";
            }
        };
    }

    public static Predicate<ManagedCluster> masterSeesAllSlavesAsAvailable() {
        return new Predicate<ManagedCluster>(){

            @Override
            public boolean test(ManagedCluster cluster) {
                return Iterables.count((Iterable)((Slaves)cluster.getMaster().getDependencyResolver().resolveDependency(Slaves.class)).getSlaves()) >= (long)(cluster.size() - 1);
            }

            public String toString() {
                return "Master should see all slaves as available";
            }
        };
    }

    public static Predicate<ManagedCluster> masterAvailable(HighlyAvailableGraphDatabase ... except) {
        final List<HighlyAvailableGraphDatabase> excludedNodes = Arrays.asList(except);
        return new Predicate<ManagedCluster>(){

            @Override
            public boolean test(ManagedCluster cluster) {
                Predicate<HighlyAvailableGraphDatabase> filterMasterPredicate = node -> !excludedNodes.contains(node) && node.isAvailable(0L) && node.isMaster();
                return Iterables.filter(filterMasterPredicate, cluster.getAllMembers(new HighlyAvailableGraphDatabase[0])).iterator().hasNext();
            }

            public String toString() {
                return "There's an available master";
            }
        };
    }

    public static Predicate<ManagedCluster> masterSeesMembers(final int count) {
        return new Predicate<ManagedCluster>(){

            @Override
            public boolean test(ManagedCluster cluster) {
                ClusterMembers members = (ClusterMembers)cluster.getMaster().getDependencyResolver().resolveDependency(ClusterMembers.class);
                return Iterables.count((Iterable)members.getMembers()) == (long)count;
            }

            public String toString() {
                return "Master should see " + count + " members";
            }
        };
    }

    public static Predicate<ManagedCluster> allSeesAllAsAvailable() {
        return new Predicate<ManagedCluster>(){

            @Override
            public boolean test(ManagedCluster cluster) {
                if (!ClusterManager.allSeesAllAsJoined().test(cluster)) {
                    return false;
                }
                for (HighlyAvailableGraphDatabase database : cluster.getAllMembers(new HighlyAvailableGraphDatabase[0])) {
                    ClusterMembers members = (ClusterMembers)database.getDependencyResolver().resolveDependency(ClusterMembers.class);
                    for (ClusterMember clusterMember : members.getMembers()) {
                        if (cluster.isAvailable(clusterMember)) continue;
                        return false;
                    }
                }
                for (HighlyAvailableGraphDatabase database : cluster.getAllMembers(new HighlyAvailableGraphDatabase[0])) {
                    Log log = ((LogService)database.getDependencyResolver().resolveDependency(LogService.class)).getInternalLog(this.getClass());
                    log.debug(this.toString());
                }
                return true;
            }

            public String toString() {
                return "All instances should see all others as available";
            }
        };
    }

    public static Predicate<ManagedCluster> allSeesAllAsJoined() {
        return new Predicate<ManagedCluster>(){

            @Override
            public boolean test(ManagedCluster cluster) {
                int clusterSize = cluster.size();
                for (HighlyAvailableGraphDatabase database : cluster.getAllMembers(new HighlyAvailableGraphDatabase[0])) {
                    ClusterMembers members = (ClusterMembers)database.getDependencyResolver().resolveDependency(ClusterMembers.class);
                    if (Iterables.count((Iterable)members.getMembers()) >= (long)clusterSize) continue;
                    return false;
                }
                for (ObservedClusterMembers arbiter : cluster.getArbiters()) {
                    if (Iterables.count((Iterable)arbiter.getMembers()) >= (long)clusterSize) continue;
                    return false;
                }
                return true;
            }

            public String toString() {
                return "All instances should see all others as joined";
            }
        };
    }

    public static Predicate<ManagedCluster> allAvailabilityGuardsReleased() {
        return item -> {
            for (HighlyAvailableGraphDatabase member : item.getAllMembers(new HighlyAvailableGraphDatabase[0])) {
                try {
                    member.beginTx().close();
                }
                catch (TransactionFailureException e) {
                    return false;
                }
            }
            return true;
        };
    }

    public static Predicate<ManagedCluster> instanceEvicted(final HighlyAvailableGraphDatabase instance) {
        return new Predicate<ManagedCluster>(){

            @Override
            public boolean test(ManagedCluster managedCluster) {
                InstanceId instanceId = managedCluster.getServerId(instance);
                Iterable<HighlyAvailableGraphDatabase> members = managedCluster.getAllMembers(new HighlyAvailableGraphDatabase[0]);
                for (HighlyAvailableGraphDatabase member : members) {
                    if (!instanceId.equals((Object)managedCluster.getServerId(member)) || !member.role().equals("UNKNOWN")) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Predicate<ManagedCluster> memberSeesOtherMemberAsFailed(HighlyAvailableGraphDatabase observer, HighlyAvailableGraphDatabase observed) {
        return cluster -> {
            InstanceId observedServerId = (InstanceId)((Config)observed.getDependencyResolver().resolveDependency(Config.class)).get(ClusterSettings.server_id);
            for (ClusterMember member : ((ClusterMembers)observer.getDependencyResolver().resolveDependency(ClusterMembers.class)).getMembers()) {
                if (!member.getInstanceId().equals((Object)observedServerId)) continue;
                return !member.isAlive();
            }
            throw new IllegalStateException(observed + " not a member according to " + observer);
        };
    }

    public static Predicate<ManagedCluster> entireClusterSeesMemberAsNotAvailable(HighlyAvailableGraphDatabase observed) {
        return cluster -> {
            InstanceId observedServerId = (InstanceId)((Config)observed.getDependencyResolver().resolveDependency(Config.class)).get(ClusterSettings.server_id);
            for (HighlyAvailableGraphDatabase observer : cluster.getAllMembers(observed)) {
                for (ClusterMember member : ((ClusterMembers)observer.getDependencyResolver().resolveDependency(ClusterMembers.class)).getMembers()) {
                    if (!member.getInstanceId().equals((Object)observedServerId) || !cluster.isAvailable(member)) continue;
                    return false;
                }
            }
            return true;
        };
    }

    public static Predicate<ManagedCluster> memberThinksItIsRole(HighlyAvailableGraphDatabase member, String role) {
        return cluster -> role.equals(member.role());
    }

    public static String stateToString(ManagedCluster cluster) {
        StringBuilder buf = new StringBuilder("\n");
        for (HighlyAvailableGraphDatabase database : cluster.getAllMembers(new HighlyAvailableGraphDatabase[0])) {
            ClusterClient client = (ClusterClient)database.getDependencyResolver().resolveDependency(ClusterClient.class);
            buf.append("Instance ").append(client.getServerId()).append(":State ").append(database.getInstanceState()).append(" (").append(client.getClusterServer()).append("):").append("\n");
            ClusterMembers members = (ClusterMembers)database.getDependencyResolver().resolveDependency(ClusterMembers.class);
            buf.append(members);
        }
        return buf.toString();
    }

    public void start() throws Throwable {
        org.neo4j.cluster.client.Cluster cluster = this.clustersProvider.get();
        this.life = new LifeSupport();
        this.life.start();
        this.managedCluster = new ManagedCluster(cluster);
        this.life.add((Lifecycle)this.managedCluster);
        this.availabilityChecks.forEach(this.managedCluster::await);
        if (this.initialDatasetCreator != null) {
            this.initialDatasetCreator.receive((Object)this.managedCluster.getMaster());
            this.managedCluster.sync(new HighlyAvailableGraphDatabase[0]);
        }
    }

    public void stop() throws Throwable {
        this.life.stop();
    }

    public void shutdown() throws Throwable {
        this.life.shutdown();
    }

    public void safeShutdown() {
        try {
            this.shutdown();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public ManagedCluster getCluster() {
        return this.managedCluster;
    }

    private class StartDatabaseAgainKit
    implements RepairKit {
        private final InstanceId serverId;
        private final ManagedCluster cluster;

        public StartDatabaseAgainKit(ManagedCluster cluster, InstanceId serverId) {
            this.cluster = cluster;
            this.serverId = serverId;
        }

        @Override
        public HighlyAvailableGraphDatabase repair() throws Throwable {
            this.cluster.startMember(this.serverId);
            return this.cluster.getMemberByServerId(this.serverId);
        }
    }

    private class StartNetworkAgainKit
    implements RepairKit {
        private final HighlyAvailableGraphDatabase db;
        private final NetworkReceiver networkReceiver;
        private final NetworkSender networkSender;
        private final NetworkFlag[] flags;

        StartNetworkAgainKit(HighlyAvailableGraphDatabase db, NetworkReceiver networkReceiver, NetworkSender networkSender, NetworkFlag ... flags) {
            this.db = db;
            this.networkReceiver = networkReceiver;
            this.networkSender = networkSender;
            this.flags = flags;
        }

        @Override
        public HighlyAvailableGraphDatabase repair() throws Throwable {
            if (ArrayUtil.contains((Object[])this.flags, (Object)((Object)NetworkFlag.OUT))) {
                this.networkSender.setPaused(false);
            }
            if (ArrayUtil.contains((Object[])this.flags, (Object)((Object)NetworkFlag.IN))) {
                this.networkReceiver.setPaused(false);
            }
            return this.db;
        }
    }

    public class ManagedCluster
    extends LifecycleAdapter {
        private final org.neo4j.cluster.client.Cluster spec;
        private final String name;
        private final Map<InstanceId, HighlyAvailableGraphDatabaseProxy> members = new ConcurrentHashMap<InstanceId, HighlyAvailableGraphDatabaseProxy>();
        private final List<ObservedClusterMembers> arbiters = new ArrayList<ObservedClusterMembers>();
        private final Set<RepairKit> pendingRepairs = Collections.synchronizedSet(new HashSet());
        private final HashSet<Integer> takenHaPorts = new HashSet();

        ManagedCluster(org.neo4j.cluster.client.Cluster spec) throws URISyntaxException, IOException {
            this.spec = spec;
            this.name = spec.getName();
            for (int i = 0; i < spec.getMembers().size(); ++i) {
                this.startMember(new InstanceId(i + 1));
            }
            for (HighlyAvailableGraphDatabaseProxy member : this.members.values()) {
                HighlyAvailableGraphDatabase graphDatabase = member.get(60L);
                Config config = (Config)graphDatabase.getDependencyResolver().resolveDependency(Config.class);
            }
        }

        public String getInitialHostsConfigString() {
            StringBuilder result = new StringBuilder();
            for (HighlyAvailableGraphDatabase member : this.getAllMembers(new HighlyAvailableGraphDatabase[0])) {
                result.append(result.length() > 0 ? "," : "").append(ClusterManager.this.localAddress).append(":").append(((ClusterClient)member.getDependencyResolver().resolveDependency(ClusterClient.class)).getClusterServer().getPort());
            }
            return result.toString();
        }

        public void stop() throws Throwable {
            for (HighlyAvailableGraphDatabaseProxy member : this.members.values()) {
                HighlyAvailableGraphDatabase memberDb = member.get(60L);
                File storeDir = memberDb.getStoreDirectory();
                memberDb.shutdown();
                if (!ClusterManager.this.consistencyCheck) continue;
                this.consistencyCheck(storeDir);
            }
        }

        private void consistencyCheck(File storeDir) throws Throwable {
            StoreAssertions.assertConsistentStore((File)storeDir);
        }

        public Iterable<HighlyAvailableGraphDatabase> getAllMembers(HighlyAvailableGraphDatabase ... except) {
            HashSet<HighlyAvailableGraphDatabase> exceptSet = new HashSet<HighlyAvailableGraphDatabase>(Arrays.asList(except));
            return this.members.values().stream().map(proxy -> proxy.get(60L)).filter(db -> !exceptSet.contains(db)).collect(Collectors.toList());
        }

        public Iterable<ObservedClusterMembers> getArbiters() {
            return this.arbiters;
        }

        public boolean isArbiter(ClusterMember clusterMember) {
            for (ObservedClusterMembers arbiter : this.arbiters) {
                if (!arbiter.getCurrentMember().getInstanceId().equals((Object)clusterMember.getInstanceId())) continue;
                return true;
            }
            return false;
        }

        public boolean isAvailable(ClusterMember clusterMember) {
            if (this.isArbiter(clusterMember)) {
                return clusterMember.isAlive();
            }
            return clusterMember.isAlive() && !clusterMember.getHARole().equals("UNKNOWN");
        }

        public HighlyAvailableGraphDatabase getMaster() {
            for (HighlyAvailableGraphDatabase graphDatabaseService : this.getAllMembers(new HighlyAvailableGraphDatabase[0])) {
                if (!graphDatabaseService.isAvailable(0L) || !graphDatabaseService.isMaster()) continue;
                return graphDatabaseService;
            }
            throw new IllegalStateException("No master found in cluster " + this.name + ClusterManager.stateToString(this));
        }

        public HighlyAvailableGraphDatabase getAnySlave(HighlyAvailableGraphDatabase ... except) {
            HashSet<HighlyAvailableGraphDatabase> exceptSet = new HashSet<HighlyAvailableGraphDatabase>(Arrays.asList(except));
            for (HighlyAvailableGraphDatabase graphDatabaseService : this.getAllMembers(new HighlyAvailableGraphDatabase[0])) {
                if (graphDatabaseService.getInstanceState() != HighAvailabilityMemberState.SLAVE || exceptSet.contains(graphDatabaseService)) continue;
                return graphDatabaseService;
            }
            throw new IllegalStateException("No slave found in cluster " + this.name + ClusterManager.stateToString(this));
        }

        public HighlyAvailableGraphDatabase getMemberByServerId(InstanceId serverId) {
            HighlyAvailableGraphDatabase db = this.members.get(serverId).get(60L);
            if (db == null) {
                throw new IllegalStateException("Db " + serverId + " not found at the moment in " + this.name + ClusterManager.stateToString(this));
            }
            return db;
        }

        public RepairKit shutdown(HighlyAvailableGraphDatabase db) {
            this.assertMember(db);
            InstanceId serverId = (InstanceId)((Config)db.getDependencyResolver().resolveDependency(Config.class)).get(ClusterSettings.server_id);
            this.members.remove(serverId);
            ClusterManager.this.life.remove((Object)db);
            db.shutdown();
            this.await(ClusterManager.entireClusterSeesMemberAsNotAvailable(db));
            return this.wrap(new StartDatabaseAgainKit(this, serverId));
        }

        private void assertMember(HighlyAvailableGraphDatabase db) {
            for (HighlyAvailableGraphDatabaseProxy highlyAvailableGraphDatabaseProxy : this.members.values()) {
                if (!highlyAvailableGraphDatabaseProxy.get(60L).equals(db)) continue;
                return;
            }
            throw new IllegalArgumentException("Db " + db + " not a member of this cluster " + this.name + ClusterManager.stateToString(this));
        }

        public RepairKit fail(HighlyAvailableGraphDatabase db) throws Throwable {
            return this.fail(db, NetworkFlag.values());
        }

        public RepairKit fail(HighlyAvailableGraphDatabase db, NetworkFlag ... flags) throws Throwable {
            return this.fail(db, true, flags);
        }

        public RepairKit fail(HighlyAvailableGraphDatabase db, boolean waitUntilDown, NetworkFlag ... flags) throws Throwable {
            this.assertMember(db);
            NetworkReceiver networkReceiver = (NetworkReceiver)db.getDependencyResolver().resolveDependency(NetworkReceiver.class);
            NetworkSender networkSender = (NetworkSender)db.getDependencyResolver().resolveDependency(NetworkSender.class);
            if (ArrayUtil.contains((Object[])flags, (Object)((Object)NetworkFlag.IN))) {
                networkReceiver.setPaused(true);
            }
            if (ArrayUtil.contains((Object[])flags, (Object)((Object)NetworkFlag.OUT))) {
                networkSender.setPaused(true);
            }
            if (waitUntilDown) {
                this.await(ClusterManager.entireClusterSeesMemberAsNotAvailable(db));
            }
            return this.wrap(new StartNetworkAgainKit(db, networkReceiver, networkSender, flags));
        }

        private RepairKit wrap(RepairKit actual) {
            this.pendingRepairs.add(actual);
            return () -> {
                try {
                    HighlyAvailableGraphDatabase highlyAvailableGraphDatabase = actual.repair();
                    return highlyAvailableGraphDatabase;
                }
                finally {
                    this.pendingRepairs.remove(actual);
                }
            };
        }

        private void startMember(InstanceId serverId) throws URISyntaxException, IOException {
            Cluster.Member member = (Cluster.Member)this.spec.getMembers().get(serverId.toIntegerIndex() - 1);
            StringBuilder initialHosts = new StringBuilder();
            for (int i = 0; i < this.spec.getMembers().size(); ++i) {
                URI uri;
                if (i > 0) {
                    initialHosts.append(",");
                }
                if ((uri = new URI("cluster://" + ((Cluster.Member)this.spec.getMembers().get(i)).getHost())).getHost() == null || uri.getHost().isEmpty() || uri.getHost().equals("0.0.0.0")) {
                    initialHosts.append(ClusterManager.this.localAddress).append(":").append(uri.getPort());
                    continue;
                }
                initialHosts.append(uri.getHost()).append(":").append(uri.getPort());
            }
            File parent = new File(ClusterManager.this.root, this.name);
            URI clusterUri = new URI("cluster://" + member.getHost());
            if (member.isFullHaMember()) {
                int clusterPort = clusterUri.getPort();
                int haPort = ClusterManager.findFreePort(21001, 31001, this.takenHaPorts);
                this.takenHaPorts.add(haPort);
                File storeDir = new File(parent, "server" + serverId);
                if (ClusterManager.this.storeDirInitializer != null) {
                    ClusterManager.this.storeDirInitializer.initializeStoreDir(serverId.toIntegerIndex(), storeDir);
                }
                GraphDatabaseBuilder builder = ClusterManager.this.dbFactory.newEmbeddedDatabaseBuilder(storeDir.getAbsoluteFile());
                builder.setConfig(ClusterSettings.cluster_name, this.name);
                builder.setConfig(ClusterSettings.initial_hosts, initialHosts.toString());
                builder.setConfig(ClusterSettings.server_id, serverId + "");
                builder.setConfig(ClusterSettings.cluster_server, "0.0.0.0:" + clusterPort);
                builder.setConfig(HaSettings.ha_server, clusterUri.getHost() + ":" + haPort);
                builder.setConfig(OnlineBackupSettings.online_backup_enabled, "false");
                for (Map.Entry conf : ClusterManager.this.commonConfig.entrySet()) {
                    builder.setConfig((String)conf.getKey(), (String)((IntFunction)conf.getValue()).apply(serverId.toIntegerIndex()));
                }
                final HighlyAvailableGraphDatabaseProxy graphDatabase = new HighlyAvailableGraphDatabaseProxy(builder);
                this.members.put(serverId, graphDatabase);
                ClusterManager.this.life.add((Lifecycle)new LifecycleAdapter(){

                    public void stop() throws Throwable {
                        graphDatabase.get(60L).shutdown();
                    }
                });
            } else {
                Map config = MapUtil.stringMap((String[])new String[]{ClusterSettings.cluster_name.name(), this.name, ClusterSettings.initial_hosts.name(), initialHosts.toString(), ClusterSettings.server_id.name(), serverId + "", ClusterSettings.cluster_server.name(), "0.0.0.0:" + clusterUri.getPort()});
                Config config1 = new Config(config, new Class[]{GraphDatabaseFacadeFactory.Configuration.class, GraphDatabaseSettings.class});
                LifeSupport clusterClientLife = new LifeSupport();
                NullLogService logService = NullLogService.getInstance();
                ClusterClientModule clusterClientModule = new ClusterClientModule(clusterClientLife, new Dependencies(), new Monitors(), config1, (LogService)logService, (ElectionCredentialsProvider)new NotElectableElectionCredentialsProvider());
                this.arbiters.add(new ObservedClusterMembers(logService.getInternalLogProvider(), (Cluster)clusterClientModule.clusterClient, (Heartbeat)clusterClientModule.clusterClient, new ClusterMemberEvents(){

                    public void addClusterMemberListener(ClusterMemberListener listener) {
                    }

                    public void removeClusterMemberListener(ClusterMemberListener listener) {
                    }
                }, clusterClientModule.clusterClient.getServerId()));
                ClusterManager.this.life.add(new FutureLifecycleAdapter<LifeSupport>(clusterClientLife));
            }
        }

        public void await(Predicate<ManagedCluster> predicate) {
            this.await(predicate, 60);
        }

        public void await(Predicate<ManagedCluster> predicate, int maxSeconds) {
            long end = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(maxSeconds);
            while (System.currentTimeMillis() < end) {
                if (predicate.test(this)) {
                    return;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            String state = ClusterManager.stateToString(this);
            throw new IllegalStateException(String.format("Awaited condition never met, waited %s seconds for %s:%n%s", maxSeconds, predicate, state));
        }

        public int size() {
            return this.spec.getMembers().size();
        }

        public InstanceId getServerId(HighlyAvailableGraphDatabase member) {
            this.assertMember(member);
            return (InstanceId)((Config)member.getDependencyResolver().resolveDependency(Config.class)).get(ClusterSettings.server_id);
        }

        public File getStoreDir(HighlyAvailableGraphDatabase member) {
            this.assertMember(member);
            return member.getStoreDirectory();
        }

        public void sync(HighlyAvailableGraphDatabase ... except) throws InterruptedException {
            HashSet<HighlyAvailableGraphDatabase> exceptSet = new HashSet<HighlyAvailableGraphDatabase>(Arrays.asList(except));
            for (HighlyAvailableGraphDatabase db : this.getAllMembers(new HighlyAvailableGraphDatabase[0])) {
                if (exceptSet.contains(db)) continue;
                UpdatePuller updatePuller = (UpdatePuller)db.getDependencyResolver().resolveDependency(UpdatePuller.class);
                try {
                    if (!db.isAvailable(60000L)) continue;
                    updatePuller.pullUpdates();
                }
                catch (Exception e) {
                    throw new IllegalStateException(ClusterManager.stateToString(this), e);
                }
            }
        }

        public void force(HighlyAvailableGraphDatabase ... except) {
            HashSet<HighlyAvailableGraphDatabase> exceptSet = new HashSet<HighlyAvailableGraphDatabase>(Arrays.asList(except));
            for (HighlyAvailableGraphDatabase db : this.getAllMembers(new HighlyAvailableGraphDatabase[0])) {
                if (exceptSet.contains(db)) continue;
                IOLimiter limiter = IOLimiter.unlimited();
                ((StorageEngine)db.getDependencyResolver().resolveDependency(StorageEngine.class)).flushAndForce(limiter);
            }
        }

        public void info(String message) {
            for (HighlyAvailableGraphDatabase db : this.getAllMembers(new HighlyAvailableGraphDatabase[0])) {
                LogService logService = (LogService)db.getDependencyResolver().resolveDependency(LogService.class);
                Log messagesLog = logService.getInternalLog(HighlyAvailableGraphDatabase.class);
                messagesLog.info(message);
            }
        }

        public void applyOnAll(Function<GraphDatabaseService, Void> function) {
            for (HighlyAvailableGraphDatabase db : this.getAllMembers(new HighlyAvailableGraphDatabase[0])) {
                function.apply((GraphDatabaseService)db);
            }
        }

        public void repairAll() throws Throwable {
            for (RepairKit repair : this.pendingRepairs) {
                repair.repair();
            }
            this.pendingRepairs.clear();
        }
    }

    private static final class FutureLifecycleAdapter<T extends Lifecycle>
    extends LifecycleAdapter {
        private final T wrapped;
        private final ExecutorService starter;
        private Future<Void> currentFuture;

        public FutureLifecycleAdapter(T toWrap) {
            this.wrapped = toWrap;
            this.starter = Executors.newFixedThreadPool(1);
        }

        public void init() throws Throwable {
            this.currentFuture = this.starter.submit(() -> {
                try {
                    this.wrapped.init();
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
                return null;
            });
        }

        public void start() throws Throwable {
            this.currentFuture.get();
            this.currentFuture = this.starter.submit(() -> {
                try {
                    this.wrapped.start();
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
                return null;
            });
        }

        public void stop() throws Throwable {
            this.currentFuture.get();
            this.currentFuture = this.starter.submit(() -> {
                try {
                    this.wrapped.stop();
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
                return null;
            });
        }

        public void shutdown() throws Throwable {
            this.currentFuture = this.starter.submit(() -> {
                try {
                    this.wrapped.shutdown();
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
                return null;
            });
            this.currentFuture.get();
            this.starter.shutdownNow();
        }
    }

    private static final class HighlyAvailableGraphDatabaseProxy {
        private final ExecutorService executor;
        private GraphDatabaseService result;
        private final Future<GraphDatabaseService> untilThen;

        public HighlyAvailableGraphDatabaseProxy(GraphDatabaseBuilder graphDatabaseBuilder) {
            Callable<GraphDatabaseService> starter = () -> ((GraphDatabaseBuilder)graphDatabaseBuilder).newGraphDatabase();
            this.executor = Executors.newFixedThreadPool(1);
            this.untilThen = this.executor.submit(starter);
        }

        public HighlyAvailableGraphDatabase get(long timeoutSeconds) {
            if (this.result == null) {
                try {
                    this.result = this.untilThen.get(timeoutSeconds, TimeUnit.SECONDS);
                }
                catch (InterruptedException | ExecutionException | TimeoutException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    this.executor.shutdownNow();
                }
            }
            return (HighlyAvailableGraphDatabase)this.result;
        }
    }

    public static class Builder
    implements ClusterBuilder<Builder> {
        private File root;
        private Supplier<org.neo4j.cluster.client.Cluster> provider = ClusterManager.clusterOfSize(3);
        private final Map<String, IntFunction<String>> commonConfig = new HashMap<String, IntFunction<String>>();
        private HighlyAvailableGraphDatabaseFactory factory = new HighlyAvailableGraphDatabaseFactory();
        private StoreDirInitializer initializer;
        private Listener<GraphDatabaseService> initialDatasetCreator;
        private List<Predicate<ManagedCluster>> availabilityChecks = Collections.emptyList();
        private boolean consistencyCheck;

        public Builder(File root) {
            this.root = root;
        }

        public Builder() {
        }

        @Override
        public Builder withRootDirectory(File root) {
            this.root = root;
            return this;
        }

        @Override
        public Builder withSeedDir(File seedDir) {
            return this.withStoreDirInitializer((serverId, storeDir) -> FileUtils.copyRecursively((File)seedDir, (File)storeDir));
        }

        @Override
        public Builder withStoreDirInitializer(StoreDirInitializer initializer) {
            this.initializer = initializer;
            return this;
        }

        @Override
        public Builder withDbFactory(HighlyAvailableGraphDatabaseFactory dbFactory) {
            this.factory = dbFactory;
            return this;
        }

        @Override
        public Builder withCluster(Supplier<org.neo4j.cluster.client.Cluster> provider) {
            this.provider = provider;
            return this;
        }

        @Override
        public Builder withInstanceConfig(Map<String, IntFunction<String>> commonConfig) {
            this.commonConfig.putAll(commonConfig);
            return this;
        }

        @Override
        public Builder withInstanceSetting(Setting<?> setting, IntFunction<String> valueFunction) {
            this.commonConfig.put(setting.name(), valueFunction);
            return this;
        }

        @Override
        public Builder withSharedConfig(Map<String, String> commonConfig) {
            HashMap<String, IntFunction<String>> dynamic = new HashMap<String, IntFunction<String>>();
            for (Map.Entry<String, String> entry : commonConfig.entrySet()) {
                dynamic.put(entry.getKey(), ClusterManager.constant(entry.getValue()));
            }
            return this.withInstanceConfig(dynamic);
        }

        @Override
        public Builder withSharedSetting(Setting<?> setting, String value) {
            return this.withInstanceSetting((Setting)setting, (IntFunction)ClusterManager.constant(value));
        }

        @Override
        public Builder withInitialDataset(Listener<GraphDatabaseService> transactor) {
            this.initialDatasetCreator = transactor;
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder withAvailabilityChecks(Predicate<ManagedCluster> ... checks) {
            this.availabilityChecks = Arrays.asList(checks);
            return this;
        }

        @Override
        public Builder withConsistencyCheckAfterwards() {
            this.consistencyCheck = true;
            return this;
        }

        public ClusterManager build() {
            if (this.provider == null) {
                this.provider = ClusterManager.clusterOfSize(3);
            }
            return new ClusterManager(this);
        }
    }

    public static interface ClusterBuilder<SELF> {
        public SELF withRootDirectory(File var1);

        public SELF withSeedDir(File var1);

        public SELF withStoreDirInitializer(StoreDirInitializer var1);

        public SELF withDbFactory(HighlyAvailableGraphDatabaseFactory var1);

        public SELF withCluster(Supplier<org.neo4j.cluster.client.Cluster> var1);

        public SELF withInstanceConfig(Map<String, IntFunction<String>> var1);

        public SELF withInstanceSetting(Setting<?> var1, IntFunction<String> var2);

        public SELF withSharedConfig(Map<String, String> var1);

        public SELF withSharedSetting(Setting<?> var1, String var2);

        public SELF withInitialDataset(Listener<GraphDatabaseService> var1);

        public SELF withAvailabilityChecks(Predicate<ManagedCluster> ... var1);

        public SELF withConsistencyCheckAfterwards();
    }

    public static interface RepairKit {
        public HighlyAvailableGraphDatabase repair() throws Throwable;
    }

    public static interface StoreDirInitializer {
        public void initializeStoreDir(int var1, File var2) throws IOException;
    }

    public static enum NetworkFlag {
        OUT,
        IN;

    }
}

