/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.lock;

import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.test.ha.ClusterRule;

public class ClusterLocksIT {
    private static final long TIMEOUT_MILLIS = 120000L;
    @Rule
    public final ClusterRule clusterRule = new ClusterRule(this.getClass());
    private ClusterManager.ManagedCluster cluster;

    @Before
    public void setUp() throws Exception {
        this.cluster = ((ClusterRule)this.clusterRule.withSharedSetting(HaSettings.tx_push_factor, "2")).startCluster();
    }

    @Test(timeout=120000L)
    public void lockCleanupOnModeSwitch() throws Throwable {
        Label testLabel = Label.label((String)"testLabel");
        HighlyAvailableGraphDatabase master = this.cluster.getMaster();
        this.createNodeOnMaster(testLabel, master);
        HighlyAvailableGraphDatabase slave = this.cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        ClusterManager.RepairKit repairKit = this.takeExclusiveLockAndKillSlave(testLabel, slave);
        repairKit.repair();
        this.cluster.await(ClusterManager.allSeesAllAsAvailable());
        HighlyAvailableGraphDatabase clusterMaster = this.cluster.getMaster();
        this.takeExclusiveLockOnSameNodeAfterSwitch(testLabel, master, clusterMaster);
    }

    private void takeExclusiveLockOnSameNodeAfterSwitch(Label testLabel, HighlyAvailableGraphDatabase master, HighlyAvailableGraphDatabase db) throws EntityNotFoundException {
        try (Transaction transaction = db.beginTx();){
            Node node = this.getNode(master, testLabel);
            transaction.acquireWriteLock((PropertyContainer)node);
            node.setProperty("key", (Object)"value");
            transaction.success();
        }
    }

    private ClusterManager.RepairKit takeExclusiveLockAndKillSlave(Label testLabel, HighlyAvailableGraphDatabase db) throws EntityNotFoundException {
        Transaction transaction = db.beginTx();
        Node node = this.getNode(db, testLabel);
        transaction.acquireWriteLock((PropertyContainer)node);
        return this.cluster.shutdown(db);
    }

    private void createNodeOnMaster(Label testLabel, HighlyAvailableGraphDatabase master) {
        try (Transaction transaction = master.beginTx();){
            master.createNode(new Label[]{testLabel});
            transaction.success();
        }
    }

    private Node getNode(HighlyAvailableGraphDatabase db, Label testLabel) throws EntityNotFoundException {
        return (Node)db.findNodes(testLabel).stream().findFirst().orElseThrow(() -> new EntityNotFoundException(EntityType.NODE, 0L));
    }
}

