/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.File;
import java.io.IOException;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.impl.util.StoreUtil;

public enum BranchedDataPolicy {
    keep_all{

        @Override
        public void handle(File storeDir) throws IOException {
            StoreUtil.moveAwayDb((File)storeDir, (File)StoreUtil.newBranchedDataDir((File)storeDir));
        }
    }
    ,
    keep_last{

        @Override
        public void handle(File storeDir) throws IOException {
            File branchedDataDir = StoreUtil.newBranchedDataDir((File)storeDir);
            StoreUtil.moveAwayDb((File)storeDir, (File)branchedDataDir);
            for (File file : StoreUtil.getBranchedDataRootDirectory((File)storeDir).listFiles()) {
                if (!StoreUtil.isBranchedDataDirectory((File)file) || file.equals(branchedDataDir)) continue;
                FileUtils.deleteRecursively((File)file);
            }
        }
    }
    ,
    keep_none{

        @Override
        public void handle(File storeDir) throws IOException {
            StoreUtil.cleanStoreDir((File)storeDir);
        }
    };


    public abstract void handle(File var1) throws IOException;
}

