/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.ha.transaction.TransactionPropagator;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.transaction.state.IntegrityValidator;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.storageengine.api.TransactionApplicationMode;

public class MasterTransactionCommitProcess
implements TransactionCommitProcess {
    private final TransactionPropagator txPropagator;
    private final IntegrityValidator validator;
    private final TransactionCommitProcess inner;

    public MasterTransactionCommitProcess(TransactionCommitProcess commitProcess, TransactionPropagator txPropagator, IntegrityValidator validator) {
        this.inner = commitProcess;
        this.txPropagator = txPropagator;
        this.validator = validator;
    }

    public long commit(TransactionToApply batch, CommitEvent commitEvent, TransactionApplicationMode mode) throws TransactionFailureException {
        this.validate(batch);
        long result = this.inner.commit(batch, commitEvent, mode);
        this.txPropagator.committed(result, batch.transactionRepresentation().getAuthorId());
        return result;
    }

    private void validate(TransactionToApply batch) throws TransactionFailureException {
        while (batch != null) {
            this.validator.validateTransactionStartKnowledge(batch.transactionRepresentation().getLatestCommittedTxWhenStarted());
            batch = batch.next();
        }
    }
}

