/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.util.concurrent.CountDownLatch;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.TransientDatabaseFailureException;
import org.neo4j.ha.TestRunConditions;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberChangeEvent;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberListener;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberState;
import org.neo4j.kernel.ha.cluster.HighAvailabilityMemberStateMachine;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.test.rule.LoggerRule;
import org.neo4j.test.rule.TestDirectory;

public class ClusterPartitionIT {
    @Rule
    public LoggerRule logger = new LoggerRule();
    @Rule
    public TestDirectory dir = TestDirectory.testDirectory();
    private final String testPropKey = "testPropKey";
    private final String testPropValue = "testPropValue";
    private long testNodeId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void isolatedMasterShouldRemoveSelfFromClusterAndBecomeReadOnly() throws Throwable {
        int clusterSize = 3;
        ClusterManager manager = ((ClusterManager.Builder)((ClusterManager.Builder)new ClusterManager.Builder().withRootDirectory(this.dir.cleanDirectory("testcluster")).withCluster((Supplier)ClusterManager.clusterOfSize(clusterSize))).withSharedConfig(MapUtil.stringMap((String[])new String[]{ClusterSettings.heartbeat_interval.name(), "1"}))).build();
        try {
            manager.start();
            ClusterManager.ManagedCluster cluster = manager.getCluster();
            cluster.await(ClusterManager.allSeesAllAsAvailable());
            cluster.await(ClusterManager.masterAvailable(new HighlyAvailableGraphDatabase[0]));
            HighlyAvailableGraphDatabase oldMaster = cluster.getMaster();
            CountDownLatch masterTransitionLatch = new CountDownLatch(1);
            this.setupForWaitOnSwitchToDetached(oldMaster, masterTransitionLatch);
            this.addSomeData(oldMaster);
            ClusterManager.RepairKit fail = cluster.fail(oldMaster, ClusterManager.NetworkFlag.values());
            cluster.await(ClusterManager.instanceEvicted(oldMaster), 20);
            masterTransitionLatch.await();
            this.ensureInstanceIsReadOnlyInPendingState(oldMaster);
            fail.repair();
            cluster.await(ClusterManager.allSeesAllAsAvailable());
            this.ensureInstanceIsWritable(oldMaster);
        }
        finally {
            manager.safeShutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void isolatedSlaveShouldRemoveSelfFromClusterAndBecomeReadOnly() throws Throwable {
        int clusterSize = 3;
        ClusterManager manager = ((ClusterManager.Builder)((ClusterManager.Builder)new ClusterManager.Builder().withRootDirectory(this.dir.cleanDirectory("testcluster")).withCluster((Supplier)ClusterManager.clusterOfSize(clusterSize))).withSharedConfig(MapUtil.stringMap((String[])new String[]{ClusterSettings.heartbeat_interval.name(), "1"}))).build();
        try {
            manager.start();
            ClusterManager.ManagedCluster cluster = manager.getCluster();
            cluster.await(ClusterManager.allSeesAllAsAvailable());
            cluster.await(ClusterManager.masterAvailable(new HighlyAvailableGraphDatabase[0]));
            HighlyAvailableGraphDatabase slave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
            CountDownLatch slaveTransitionLatch = new CountDownLatch(1);
            this.setupForWaitOnSwitchToDetached(slave, slaveTransitionLatch);
            this.addSomeData(slave);
            ClusterManager.RepairKit fail = cluster.fail(slave, ClusterManager.NetworkFlag.values());
            cluster.await(ClusterManager.instanceEvicted(slave), 20);
            slaveTransitionLatch.await();
            this.ensureInstanceIsReadOnlyInPendingState(slave);
            fail.repair();
            cluster.await(ClusterManager.allSeesAllAsAvailable());
            this.ensureInstanceIsWritable(slave);
        }
        finally {
            manager.safeShutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void losingQuorumIncrementallyShouldMakeAllInstancesPendingAndReadOnly() throws Throwable {
        int clusterSize = 5;
        Assume.assumeTrue((boolean)TestRunConditions.shouldRunAtClusterSize(clusterSize));
        ClusterManager manager = ((ClusterManager.Builder)((ClusterManager.Builder)new ClusterManager.Builder().withRootDirectory(this.dir.cleanDirectory("testcluster")).withCluster((Supplier)ClusterManager.clusterOfSize(clusterSize))).withSharedConfig(MapUtil.stringMap((String[])new String[]{ClusterSettings.heartbeat_interval.name(), "1", HaSettings.tx_push_factor.name(), "4"}))).build();
        try {
            manager.start();
            ClusterManager.ManagedCluster cluster = manager.getCluster();
            cluster.await(ClusterManager.allSeesAllAsAvailable());
            cluster.await(ClusterManager.masterAvailable(new HighlyAvailableGraphDatabase[0]));
            HighlyAvailableGraphDatabase master = cluster.getMaster();
            this.addSomeData(master);
            HighlyAvailableGraphDatabase failed1 = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
            HighlyAvailableGraphDatabase failed2 = cluster.getAnySlave(failed1);
            HighlyAvailableGraphDatabase failed3 = cluster.getAnySlave(failed1, failed2);
            HighlyAvailableGraphDatabase remainingSlave = cluster.getAnySlave(failed1, failed2, failed3);
            CountDownLatch masterTransitionLatch = new CountDownLatch(1);
            CountDownLatch slaveTransitionLatch = new CountDownLatch(1);
            this.setupForWaitOnSwitchToDetached(master, masterTransitionLatch);
            this.setupForWaitOnSwitchToDetached(remainingSlave, slaveTransitionLatch);
            ClusterManager.RepairKit rk1 = this.killIncrementally(cluster, failed1, failed2, failed3);
            cluster.await(ClusterManager.memberSeesOtherMemberAsFailed(remainingSlave, failed1));
            cluster.await(ClusterManager.memberSeesOtherMemberAsFailed(remainingSlave, failed2));
            cluster.await(ClusterManager.memberSeesOtherMemberAsFailed(remainingSlave, failed3));
            cluster.await(ClusterManager.memberSeesOtherMemberAsFailed(master, failed1));
            cluster.await(ClusterManager.memberSeesOtherMemberAsFailed(master, failed2));
            cluster.await(ClusterManager.memberSeesOtherMemberAsFailed(master, failed3));
            masterTransitionLatch.await();
            slaveTransitionLatch.await();
            this.ensureInstanceIsReadOnlyInPendingState(master);
            this.ensureInstanceIsReadOnlyInPendingState(remainingSlave);
            rk1.repair();
            cluster.await(ClusterManager.masterAvailable(failed2, failed3));
            cluster.await(ClusterManager.masterSeesSlavesAsAvailable(2));
            this.ensureInstanceIsWritable(master);
            this.ensureInstanceIsWritable(remainingSlave);
            this.ensureInstanceIsWritable(failed1);
        }
        finally {
            manager.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void losingQuorumAbruptlyShouldMakeAllInstancesPendingAndReadOnly() throws Throwable {
        int clusterSize = 5;
        Assume.assumeTrue((boolean)TestRunConditions.shouldRunAtClusterSize(clusterSize));
        ClusterManager manager = ((ClusterManager.Builder)((ClusterManager.Builder)new ClusterManager.Builder().withRootDirectory(this.dir.cleanDirectory("testcluster")).withCluster((Supplier)ClusterManager.clusterOfSize(clusterSize))).withSharedConfig(MapUtil.stringMap((String[])new String[]{ClusterSettings.heartbeat_interval.name(), "1", HaSettings.tx_push_factor.name(), "4"}))).build();
        try {
            manager.start();
            ClusterManager.ManagedCluster cluster = manager.getCluster();
            cluster.await(ClusterManager.allSeesAllAsAvailable());
            cluster.await(ClusterManager.masterAvailable(new HighlyAvailableGraphDatabase[0]));
            HighlyAvailableGraphDatabase master = cluster.getMaster();
            this.addSomeData(master);
            HighlyAvailableGraphDatabase failed1 = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
            HighlyAvailableGraphDatabase failed2 = cluster.getAnySlave(failed1);
            HighlyAvailableGraphDatabase failed3 = cluster.getAnySlave(failed1, failed2);
            HighlyAvailableGraphDatabase remainingSlave = cluster.getAnySlave(failed1, failed2, failed3);
            CountDownLatch masterTransitionLatch = new CountDownLatch(1);
            CountDownLatch slaveTransitionLatch = new CountDownLatch(1);
            this.setupForWaitOnSwitchToDetached(master, masterTransitionLatch);
            this.setupForWaitOnSwitchToDetached(remainingSlave, slaveTransitionLatch);
            ClusterManager.RepairKit rk1 = this.killAbruptly(cluster, failed1, failed2, failed3);
            cluster.await(ClusterManager.memberSeesOtherMemberAsFailed(remainingSlave, failed1));
            cluster.await(ClusterManager.memberSeesOtherMemberAsFailed(remainingSlave, failed2));
            cluster.await(ClusterManager.memberSeesOtherMemberAsFailed(remainingSlave, failed3));
            cluster.await(ClusterManager.memberSeesOtherMemberAsFailed(master, failed1));
            cluster.await(ClusterManager.memberSeesOtherMemberAsFailed(master, failed2));
            cluster.await(ClusterManager.memberSeesOtherMemberAsFailed(master, failed3));
            masterTransitionLatch.await();
            slaveTransitionLatch.await();
            this.ensureInstanceIsReadOnlyInPendingState(master);
            this.ensureInstanceIsReadOnlyInPendingState(remainingSlave);
            rk1.repair();
            cluster.await(ClusterManager.masterAvailable(failed2, failed3));
            cluster.await(ClusterManager.masterSeesSlavesAsAvailable(2));
            this.ensureInstanceIsWritable(master);
            this.ensureInstanceIsWritable(remainingSlave);
            this.ensureInstanceIsWritable(failed1);
        }
        finally {
            manager.shutdown();
        }
    }

    private ClusterManager.RepairKit killAbruptly(ClusterManager.ManagedCluster cluster, HighlyAvailableGraphDatabase failed1, HighlyAvailableGraphDatabase failed2, HighlyAvailableGraphDatabase failed3) throws Throwable {
        ClusterManager.RepairKit firstFailure = cluster.fail(failed1);
        cluster.fail(failed2);
        cluster.fail(failed3);
        cluster.await(ClusterManager.instanceEvicted(failed1));
        cluster.await(ClusterManager.instanceEvicted(failed2));
        cluster.await(ClusterManager.instanceEvicted(failed3));
        return firstFailure;
    }

    private ClusterManager.RepairKit killIncrementally(ClusterManager.ManagedCluster cluster, HighlyAvailableGraphDatabase failed1, HighlyAvailableGraphDatabase failed2, HighlyAvailableGraphDatabase failed3) throws Throwable {
        ClusterManager.RepairKit firstFailure = cluster.fail(failed1);
        cluster.await(ClusterManager.instanceEvicted(failed1));
        cluster.fail(failed2);
        cluster.await(ClusterManager.instanceEvicted(failed2));
        cluster.fail(failed3);
        cluster.await(ClusterManager.instanceEvicted(failed3));
        return firstFailure;
    }

    private void addSomeData(HighlyAvailableGraphDatabase instance) {
        try (Transaction tx = instance.beginTx();){
            Node testNode = instance.createNode();
            this.testNodeId = testNode.getId();
            testNode.setProperty("testPropKey", (Object)"testPropValue");
            tx.success();
        }
    }

    private void ensureInstanceIsReadOnlyInPendingState(HighlyAvailableGraphDatabase instance) {
        Assert.assertEquals((Object)HighAvailabilityMemberState.PENDING, (Object)instance.getInstanceState());
        try (Transaction tx = instance.beginTx();){
            Assert.assertEquals((Object)"testPropValue", (Object)instance.getNodeById(this.testNodeId).getProperty("testPropKey"));
            tx.success();
        }
        try {
            var3_4 = null;
            try (Transaction ignored = instance.beginTx();){
                instance.getNodeById(this.testNodeId).delete();
                Assert.fail((String)"Should not be able to do write transactions when detached");
            }
            catch (Throwable throwable) {
                var3_4 = throwable;
                throw throwable;
            }
        }
        catch (TransactionFailureException | TransientDatabaseFailureException throwable) {
            // empty catch block
        }
    }

    private void ensureInstanceIsWritable(HighlyAvailableGraphDatabase instance) {
        try (Transaction tx = instance.beginTx();){
            instance.createNode().setProperty("testPropKey", (Object)"testPropValue");
            tx.success();
        }
    }

    private void setupForWaitOnSwitchToDetached(HighlyAvailableGraphDatabase db, final CountDownLatch latch) {
        ((HighAvailabilityMemberStateMachine)db.getDependencyResolver().resolveDependency(HighAvailabilityMemberStateMachine.class)).addHighAvailabilityMemberListener((HighAvailabilityMemberListener)new HighAvailabilityMemberListener.Adapter(){

            public void instanceDetached(HighAvailabilityMemberChangeEvent event) {
                latch.countDown();
            }
        });
    }
}

