/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster.modeswitch;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.ha.DelegateInvocationHandler;
import org.neo4j.kernel.ha.PullerFactory;
import org.neo4j.kernel.ha.SlaveUpdatePuller;
import org.neo4j.kernel.ha.UpdatePuller;
import org.neo4j.kernel.ha.cluster.modeswitch.UpdatePullerSwitcher;

public class UpdatePullerSwitcherTest {
    private UpdatePullerSwitcher modeSwitcher;
    private SlaveUpdatePuller slaveUpdatePuller;

    @Before
    public void setUp() {
        DelegateInvocationHandler invocationHandler = (DelegateInvocationHandler)Mockito.mock(DelegateInvocationHandler.class);
        PullerFactory pullerFactory = (PullerFactory)Mockito.mock(PullerFactory.class);
        this.slaveUpdatePuller = (SlaveUpdatePuller)Mockito.mock(SlaveUpdatePuller.class);
        Mockito.when((Object)pullerFactory.createSlaveUpdatePuller()).thenReturn((Object)this.slaveUpdatePuller);
        this.modeSwitcher = new UpdatePullerSwitcher(invocationHandler, pullerFactory);
    }

    @Test
    public void masterUpdatePuller() {
        UpdatePuller masterPuller = this.modeSwitcher.getMasterImpl();
        Assert.assertEquals((Object)UpdatePuller.NONE, (Object)masterPuller);
    }

    @Test
    public void slaveUpdatePuller() throws Throwable {
        UpdatePuller updatePuller = this.modeSwitcher.getSlaveImpl();
        Assert.assertSame((Object)this.slaveUpdatePuller, (Object)updatePuller);
        ((SlaveUpdatePuller)Mockito.verify((Object)this.slaveUpdatePuller)).start();
    }
}

