/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.backup.OnlineBackupKernelExtension;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.member.ClusterMemberAvailability;
import org.neo4j.com.Response;
import org.neo4j.com.StoreIdTestFactory;
import org.neo4j.com.storecopy.StoreCopyClient;
import org.neo4j.com.storecopy.TransactionCommittingResponseUnpacker;
import org.neo4j.com.storecopy.TransactionObligationFulfiller;
import org.neo4j.function.Suppliers;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.helpers.CancellationRequest;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.BranchedDataException;
import org.neo4j.kernel.ha.BranchedDataPolicy;
import org.neo4j.kernel.ha.DelegateInvocationHandler;
import org.neo4j.kernel.ha.MasterClient310;
import org.neo4j.kernel.ha.PullerFactory;
import org.neo4j.kernel.ha.SlaveUpdatePuller;
import org.neo4j.kernel.ha.UpdatePuller;
import org.neo4j.kernel.ha.UpdatePullerScheduler;
import org.neo4j.kernel.ha.cluster.SwitchToSlave;
import org.neo4j.kernel.ha.cluster.member.ClusterMember;
import org.neo4j.kernel.ha.cluster.member.ClusterMembers;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.HandshakeResult;
import org.neo4j.kernel.ha.com.slave.MasterClient;
import org.neo4j.kernel.ha.com.slave.MasterClientResolver;
import org.neo4j.kernel.ha.com.slave.SlaveServer;
import org.neo4j.kernel.ha.id.HaIdGeneratorFactory;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.NullLogService;
import org.neo4j.kernel.impl.store.MismatchingStoreIdException;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.store.TransactionId;
import org.neo4j.kernel.impl.transaction.TransactionStats;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.state.DataSourceManager;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.internal.StoreLockerLifecycleAdapter;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class SwitchToSlaveTest {
    private final UpdatePuller updatePuller = (UpdatePuller)this.mockWithLifecycle(SlaveUpdatePuller.class);
    private final PullerFactory pullerFactory = (PullerFactory)Mockito.mock(PullerFactory.class);
    private final FileSystemAbstraction fs = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
    private final MasterClient masterClient = (MasterClient)Mockito.mock(MasterClient.class);
    private final RequestContextFactory requestContextFactory = (RequestContextFactory)Mockito.mock(RequestContextFactory.class);
    private final StoreId storeId = StoreIdTestFactory.newStoreIdForCurrentVersion((long)42L, (long)42L, (long)42L, (long)42L);

    @Test
    public void shouldRestartServicesIfCopyStoreFails() throws Throwable {
        Mockito.when((Object)this.updatePuller.tryPullUpdates()).thenReturn((Object)true);
        PageCache pageCacheMock = (PageCache)Mockito.mock(PageCache.class);
        PagedFile pagedFileMock = (PagedFile)Mockito.mock(PagedFile.class);
        Mockito.when((Object)pagedFileMock.getLastPageId()).thenReturn((Object)1L);
        Mockito.when((Object)pageCacheMock.map((File)Matchers.any(File.class), Matchers.anyInt(), new OpenOption[0])).thenThrow(new Throwable[]{new IOException()}).thenThrow(new Throwable[]{new IOException()}).thenReturn((Object)pagedFileMock);
        StoreCopyClient storeCopyClient = (StoreCopyClient)Mockito.mock(StoreCopyClient.class);
        ((StoreCopyClient)Mockito.doThrow((Throwable)new RuntimeException()).doNothing().when((Object)storeCopyClient)).copyStore((StoreCopyClient.StoreCopyRequester)Matchers.any(StoreCopyClient.StoreCopyRequester.class), (CancellationRequest)Matchers.any(CancellationRequest.class));
        SwitchToSlave switchToSlave = this.newSwitchToSlaveSpy(pageCacheMock, storeCopyClient);
        URI localhost = this.getLocalhostUri();
        try {
            switchToSlave.switchToSlave((LifeSupport)Mockito.mock(LifeSupport.class), localhost, localhost, (CancellationRequest)Mockito.mock(CancellationRequest.class));
            Assert.fail((String)"Should have thrown an Exception");
        }
        catch (RuntimeException e) {
            ((RequestContextFactory)Mockito.verify((Object)this.requestContextFactory, (VerificationMode)Mockito.never())).start();
            ((SwitchToSlave)Mockito.verify((Object)switchToSlave)).cleanStoreDir();
            switchToSlave.switchToSlave((LifeSupport)Mockito.mock(LifeSupport.class), localhost, localhost, (CancellationRequest)Mockito.mock(CancellationRequest.class));
            ((RequestContextFactory)Mockito.verify((Object)this.requestContextFactory)).start();
        }
    }

    @Test
    public void shouldHandleBranchedStoreWhenMyStoreIdDiffersFromMasterStoreId() throws Throwable {
        SwitchToSlave switchToSlave = this.newSwitchToSlaveSpy();
        MasterClient masterClient = (MasterClient)Mockito.mock(MasterClient.class);
        Response response = (Response)Mockito.mock(Response.class);
        Mockito.when((Object)response.response()).thenReturn((Object)new HandshakeResult(1L, 2L));
        Mockito.when((Object)masterClient.handshake(Matchers.anyLong(), (StoreId)Matchers.any(StoreId.class))).thenReturn((Object)response);
        StoreId storeId = StoreIdTestFactory.newStoreIdForCurrentVersion((long)1L, (long)2L, (long)3L, (long)4L);
        TransactionIdStore transactionIdStore = (TransactionIdStore)Mockito.mock(TransactionIdStore.class);
        Mockito.when((Object)transactionIdStore.getLastCommittedTransaction()).thenReturn((Object)new TransactionId(42L, 42L, 42L));
        Mockito.when((Object)transactionIdStore.getLastCommittedTransactionId()).thenReturn((Object)1L);
        try {
            switchToSlave.checkDataConsistency(masterClient, transactionIdStore, storeId, new URI("cluster://localhost?serverId=1"));
            Assert.fail((String)("Should have thrown " + MismatchingStoreIdException.class.getSimpleName() + " exception"));
        }
        catch (MismatchingStoreIdException mismatchingStoreIdException) {
            // empty catch block
        }
        ((SwitchToSlave)Mockito.verify((Object)switchToSlave)).stopServicesAndHandleBranchedStore((BranchedDataPolicy)Matchers.any(BranchedDataPolicy.class));
    }

    @Test
    public void shouldHandleBranchedStoreWhenHandshakeFailsWithBranchedDataException() throws Throwable {
        SwitchToSlave switchToSlave = this.newSwitchToSlaveSpy();
        URI masterUri = new URI("cluster://localhost?serverId=1");
        MasterClient masterClient = (MasterClient)Mockito.mock(MasterClient.class);
        Mockito.when((Object)masterClient.handshake(Matchers.anyLong(), (StoreId)Matchers.any(StoreId.class))).thenThrow(new Throwable[]{new BranchedDataException("")});
        TransactionIdStore transactionIdStore = (TransactionIdStore)Mockito.mock(TransactionIdStore.class);
        Mockito.when((Object)transactionIdStore.getLastCommittedTransaction()).thenReturn((Object)new TransactionId(42L, 42L, 42L));
        Mockito.when((Object)transactionIdStore.getLastCommittedTransactionId()).thenReturn((Object)1L);
        try {
            switchToSlave.checkDataConsistency(masterClient, transactionIdStore, this.storeId, masterUri);
            Assert.fail((String)("Should have thrown " + BranchedDataException.class.getSimpleName() + " exception"));
        }
        catch (BranchedDataException branchedDataException) {
            // empty catch block
        }
        ((SwitchToSlave)Mockito.verify((Object)switchToSlave)).stopServicesAndHandleBranchedStore((BranchedDataPolicy)Matchers.any(BranchedDataPolicy.class));
    }

    @Test
    public void shouldReturnNullIfWhenFailingToPullingUpdatesFromMaster() throws Throwable {
        SwitchToSlave switchToSlave = this.newSwitchToSlaveSpy();
        Mockito.when((Object)this.fs.fileExists((File)Matchers.any(File.class))).thenReturn((Object)true);
        Mockito.when((Object)this.updatePuller.tryPullUpdates()).thenReturn((Object)false);
        URI localhost = this.getLocalhostUri();
        URI uri = switchToSlave.switchToSlave((LifeSupport)Mockito.mock(LifeSupport.class), localhost, localhost, (CancellationRequest)Mockito.mock(CancellationRequest.class));
        Assert.assertNull((Object)uri);
    }

    @Test
    public void updatesPulledAndPullingScheduledOnSwitchToSlave() throws Throwable {
        SwitchToSlave switchToSlave = this.newSwitchToSlaveSpy();
        Mockito.when((Object)this.fs.fileExists((File)Matchers.any(File.class))).thenReturn((Object)true);
        JobScheduler jobScheduler = (JobScheduler)Mockito.mock(JobScheduler.class);
        LifeSupport communicationLife = (LifeSupport)Mockito.mock(LifeSupport.class);
        URI localhost = this.getLocalhostUri();
        final UpdatePullerScheduler pullerScheduler = new UpdatePullerScheduler(jobScheduler, (LogProvider)NullLogProvider.getInstance(), this.updatePuller, 10L);
        Mockito.when((Object)this.pullerFactory.createUpdatePullerScheduler(this.updatePuller)).thenReturn((Object)pullerScheduler);
        ((LifeSupport)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                pullerScheduler.init();
                return null;
            }
        }).when((Object)communicationLife)).start();
        switchToSlave.switchToSlave(communicationLife, localhost, localhost, (CancellationRequest)Mockito.mock(CancellationRequest.class));
        ((UpdatePuller)Mockito.verify((Object)this.updatePuller)).tryPullUpdates();
        ((LifeSupport)Mockito.verify((Object)communicationLife)).add((Lifecycle)pullerScheduler);
        ((JobScheduler)Mockito.verify((Object)jobScheduler)).scheduleRecurring((JobScheduler.Group)Matchers.eq((Object)JobScheduler.Groups.pullUpdates), (Runnable)Matchers.any(Runnable.class), Matchers.eq((long)10L), Matchers.eq((long)10L), (TimeUnit)((Object)Matchers.eq((Object)((Object)TimeUnit.MILLISECONDS))));
    }

    private URI getLocalhostUri() throws URISyntaxException {
        return new URI("cluster://127.0.0.1?serverId=1");
    }

    private SwitchToSlave newSwitchToSlaveSpy() throws IOException {
        PageCache pageCacheMock = (PageCache)Mockito.mock(PageCache.class);
        PagedFile pagedFileMock = (PagedFile)Mockito.mock(PagedFile.class);
        Mockito.when((Object)pagedFileMock.getLastPageId()).thenReturn((Object)1L);
        Mockito.when((Object)pageCacheMock.map((File)Matchers.any(File.class), Matchers.anyInt(), new OpenOption[0])).thenReturn((Object)pagedFileMock);
        return this.newSwitchToSlaveSpy(pageCacheMock, (StoreCopyClient)Mockito.mock(StoreCopyClient.class));
    }

    private SwitchToSlave newSwitchToSlaveSpy(PageCache pageCacheMock, StoreCopyClient storeCopyClient) throws IOException {
        ClusterMembers clusterMembers = (ClusterMembers)Mockito.mock(ClusterMembers.class);
        ClusterMember master = (ClusterMember)Mockito.mock(ClusterMember.class);
        Mockito.when((Object)master.getStoreId()).thenReturn((Object)this.storeId);
        Mockito.when((Object)master.getHARole()).thenReturn((Object)"master");
        Mockito.when((Object)master.hasRole((String)Matchers.eq((Object)"master"))).thenReturn((Object)true);
        Mockito.when((Object)master.getInstanceId()).thenReturn((Object)new InstanceId(1));
        Mockito.when((Object)clusterMembers.getMembers()).thenReturn(Arrays.asList(master));
        Dependencies resolver = new Dependencies();
        resolver.satisfyDependencies(new Object[]{this.requestContextFactory, clusterMembers, Mockito.mock(TransactionObligationFulfiller.class), Mockito.mock(OnlineBackupKernelExtension.class), Mockito.mock(IndexConfigStore.class), Mockito.mock(TransactionCommittingResponseUnpacker.class), Mockito.mock(DataSourceManager.class), Mockito.mock(StoreLockerLifecycleAdapter.class)});
        NeoStoreDataSource dataSource = (NeoStoreDataSource)Mockito.mock(NeoStoreDataSource.class);
        Mockito.when((Object)dataSource.getStoreId()).thenReturn((Object)this.storeId);
        TransactionStats transactionCounters = (TransactionStats)Mockito.mock(TransactionStats.class);
        Mockito.when((Object)transactionCounters.getNumberOfActiveTransactions()).thenReturn((Object)0L);
        Response response = (Response)Mockito.mock(Response.class);
        Mockito.when((Object)response.response()).thenReturn((Object)new HandshakeResult(42L, 2L));
        Mockito.when((Object)this.masterClient.handshake(Matchers.anyLong(), (StoreId)Matchers.any(StoreId.class))).thenReturn((Object)response);
        Mockito.when((Object)this.masterClient.getProtocolVersion()).thenReturn((Object)MasterClient310.PROTOCOL_VERSION);
        TransactionIdStore transactionIdStoreMock = (TransactionIdStore)Mockito.mock(TransactionIdStore.class);
        Mockito.when((Object)transactionIdStoreMock.getLastCommittedTransaction()).thenReturn((Object)new TransactionId(42L, 42L, 42L));
        MasterClientResolver masterClientResolver = (MasterClientResolver)Mockito.mock(MasterClientResolver.class);
        Mockito.when((Object)masterClientResolver.instantiate(Matchers.anyString(), Matchers.anyInt(), Matchers.anyString(), (Monitors)Matchers.any(Monitors.class), (StoreId)Matchers.any(StoreId.class), (LifeSupport)Matchers.any(LifeSupport.class))).thenReturn((Object)this.masterClient);
        return (SwitchToSlave)Mockito.spy((Object)new SwitchToSlave(new File(""), (LogService)NullLogService.getInstance(), this.configMock(), (DependencyResolver)resolver, (HaIdGeneratorFactory)Mockito.mock(HaIdGeneratorFactory.class), (DelegateInvocationHandler)Mockito.mock(DelegateInvocationHandler.class), (ClusterMemberAvailability)Mockito.mock(ClusterMemberAvailability.class), this.requestContextFactory, this.pullerFactory, masterClientResolver, (SwitchToSlave.Monitor)Mockito.mock(SwitchToSlave.Monitor.class), storeCopyClient, Suppliers.singleton((Object)dataSource), Suppliers.singleton((Object)transactionIdStoreMock), slave -> {
            SlaveServer server = (SlaveServer)Mockito.mock(SlaveServer.class);
            InetSocketAddress inetSocketAddress = InetSocketAddress.createUnresolved("localhost", 42);
            Mockito.when((Object)server.getSocketAddress()).thenReturn((Object)inetSocketAddress);
            return server;
        }, this.updatePuller, pageCacheMock, (Monitors)Mockito.mock(Monitors.class), transactionCounters));
    }

    private Config configMock() {
        return new Config(MapUtil.stringMap((String[])new String[]{ClusterSettings.server_id.name(), "1"}));
    }

    private <T> T mockWithLifecycle(Class<T> clazz) {
        return (T)Mockito.mock(clazz, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{Lifecycle.class}));
    }
}

