/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.File;
import java.io.IOException;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.ha.store.StoreUtil;

public enum BranchedDataPolicy {
    keep_all{

        @Override
        public void handle(File storeDir, PageCache pageCache) throws IOException {
            StoreUtil.moveAwayDb(storeDir, StoreUtil.newBranchedDataDir(storeDir), pageCache);
        }
    }
    ,
    keep_last{

        @Override
        public void handle(File storeDir, PageCache pageCache) throws IOException {
            File branchedDataDir = StoreUtil.newBranchedDataDir(storeDir);
            StoreUtil.moveAwayDb(storeDir, branchedDataDir, pageCache);
            for (File file : StoreUtil.getBranchedDataRootDirectory(storeDir).listFiles()) {
                if (!StoreUtil.isBranchedDataDirectory(file) || file.equals(branchedDataDir)) continue;
                StoreUtil.deleteRecursive(file, pageCache);
            }
        }
    }
    ,
    keep_none{

        @Override
        public void handle(File storeDir, PageCache pageCache) throws IOException {
            StoreUtil.cleanStoreDir(storeDir, pageCache);
        }
    };


    public abstract void handle(File var1, PageCache var2) throws IOException;
}

