/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha.cluster;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.time.Clock;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Function;
import java.util.function.Supplier;
import org.neo4j.backup.OnlineBackupKernelExtension;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.InstanceId;
import org.neo4j.cluster.member.ClusterMemberAvailability;
import org.neo4j.com.RequestContext;
import org.neo4j.com.Response;
import org.neo4j.com.Server;
import org.neo4j.com.ServerUtil;
import org.neo4j.com.storecopy.MoveAfterCopy;
import org.neo4j.com.storecopy.StoreCopyClient;
import org.neo4j.com.storecopy.StoreUtil;
import org.neo4j.com.storecopy.StoreWriter;
import org.neo4j.com.storecopy.TransactionCommittingResponseUnpacker;
import org.neo4j.com.storecopy.TransactionObligationFulfiller;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.helpers.CancellationRequest;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.BranchedDataException;
import org.neo4j.kernel.ha.DelegateInvocationHandler;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.PullerFactory;
import org.neo4j.kernel.ha.StoreOutOfDateException;
import org.neo4j.kernel.ha.UpdatePuller;
import org.neo4j.kernel.ha.UpdatePullerScheduler;
import org.neo4j.kernel.ha.cluster.member.ClusterMember;
import org.neo4j.kernel.ha.cluster.member.ClusterMembers;
import org.neo4j.kernel.ha.cluster.modeswitch.HighAvailabilityModeSwitcher;
import org.neo4j.kernel.ha.com.RequestContextFactory;
import org.neo4j.kernel.ha.com.master.HandshakeResult;
import org.neo4j.kernel.ha.com.master.Master;
import org.neo4j.kernel.ha.com.master.Slave;
import org.neo4j.kernel.ha.com.slave.MasterClient;
import org.neo4j.kernel.ha.com.slave.MasterClientResolver;
import org.neo4j.kernel.ha.com.slave.SlaveImpl;
import org.neo4j.kernel.ha.com.slave.SlaveServer;
import org.neo4j.kernel.ha.id.HaIdGeneratorFactory;
import org.neo4j.kernel.ha.store.UnableToCopyStoreFromOldMasterException;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.store.MismatchingStoreIdException;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.store.TransactionId;
import org.neo4j.kernel.impl.transaction.TransactionStats;
import org.neo4j.kernel.impl.transaction.log.MissingLogDataException;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.state.DataSourceManager;
import org.neo4j.kernel.internal.StoreLockerLifecycleAdapter;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;
import org.neo4j.time.Clocks;

public abstract class SwitchToSlave {
    private static final Class<? extends Lifecycle>[] SERVICES_TO_RESTART_FOR_STORE_COPY = new Class[]{StoreLockerLifecycleAdapter.class, DataSourceManager.class, RequestContextFactory.class, TransactionCommittingResponseUnpacker.class, IndexConfigStore.class, OnlineBackupKernelExtension.class};
    private final StoreCopyClient storeCopyClient;
    private final Function<Slave, SlaveServer> slaveServerFactory;
    protected final UpdatePuller updatePuller;
    protected final Monitors monitors;
    final Log userLog;
    final Log msgLog;
    protected final Config config;
    protected final DependencyResolver resolver;
    private final HaIdGeneratorFactory idGeneratorFactory;
    private final DelegateInvocationHandler<Master> masterDelegateHandler;
    private final ClusterMemberAvailability clusterMemberAvailability;
    protected final RequestContextFactory requestContextFactory;
    private final MasterClientResolver masterClientResolver;
    private final PullerFactory updatePullerFactory;
    protected final Monitor monitor;
    protected final File storeDir;
    protected final PageCache pageCache;
    private final Supplier<NeoStoreDataSource> neoDataSourceSupplier;
    private final Supplier<TransactionIdStore> transactionIdStoreSupplier;
    private final TransactionStats transactionCounters;

    SwitchToSlave(HaIdGeneratorFactory idGeneratorFactory, DependencyResolver resolver, Monitors monitors, RequestContextFactory requestContextFactory, DelegateInvocationHandler<Master> masterDelegateHandler, ClusterMemberAvailability clusterMemberAvailability, MasterClientResolver masterClientResolver, Monitor monitor, PullerFactory pullerFactory, UpdatePuller updatePuller, Function<Slave, SlaveServer> slaveServerFactory, Config config, LogService logService, PageCache pageCache, File storeDir, Supplier<TransactionIdStore> transactionIdStoreSupplier, TransactionStats transactionCounters, Supplier<NeoStoreDataSource> neoDataSourceSupplier, StoreCopyClient storeCopyClient) {
        this.idGeneratorFactory = idGeneratorFactory;
        this.resolver = resolver;
        this.monitors = monitors;
        this.requestContextFactory = requestContextFactory;
        this.masterDelegateHandler = masterDelegateHandler;
        this.clusterMemberAvailability = clusterMemberAvailability;
        this.masterClientResolver = masterClientResolver;
        this.userLog = logService.getUserLog(this.getClass());
        this.msgLog = logService.getInternalLog(this.getClass());
        this.monitor = monitor;
        this.updatePullerFactory = pullerFactory;
        this.updatePuller = updatePuller;
        this.slaveServerFactory = slaveServerFactory;
        this.config = config;
        this.pageCache = pageCache;
        this.storeDir = storeDir;
        this.transactionIdStoreSupplier = transactionIdStoreSupplier;
        this.transactionCounters = transactionCounters;
        this.neoDataSourceSupplier = neoDataSourceSupplier;
        this.storeCopyClient = storeCopyClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI switchToSlave(LifeSupport haCommunicationLife, URI me, URI masterUri, CancellationRequest cancellationRequest) throws Throwable {
        URI slaveUri;
        boolean success = false;
        this.monitor.switchToSlaveStarted();
        Clock clock = Clocks.systemClock();
        long deadline = clock.millis() + (Long)this.config.get(HaSettings.internal_state_switch_timeout);
        while (this.transactionCounters.getNumberOfActiveTransactions() > 0L && clock.millis() < deadline) {
            LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(10L));
        }
        try {
            InstanceId myId = (InstanceId)this.config.get(ClusterSettings.server_id);
            this.userLog.info("ServerId %s, moving to slave for master %s", new Object[]{myId, masterUri});
            assert (masterUri != null);
            this.idGeneratorFactory.switchToSlave();
            this.copyStoreFromMasterIfNeeded(masterUri, me, cancellationRequest);
            if (cancellationRequest.cancellationRequested()) {
                this.msgLog.info("Switch to slave cancelled during store copy if no local store is present.");
                URI uRI = null;
                return uRI;
            }
            NeoStoreDataSource neoDataSource = this.neoDataSourceSupplier.get();
            neoDataSource.afterModeSwitch();
            StoreId myStoreId = neoDataSource.getStoreId();
            boolean consistencyChecksExecutedSuccessfully = this.executeConsistencyChecks(this.transactionIdStoreSupplier.get(), masterUri, me, myStoreId, cancellationRequest);
            if (!consistencyChecksExecutedSuccessfully) {
                this.msgLog.info("Switch to slave cancelled due to consistency check failure.");
                URI uRI = null;
                return uRI;
            }
            if (cancellationRequest.cancellationRequested()) {
                this.msgLog.info("Switch to slave cancelled after consistency checks.");
                URI uRI = null;
                return uRI;
            }
            slaveUri = this.startHaCommunication(haCommunicationLife, neoDataSource, me, masterUri, myStoreId, cancellationRequest);
            if (slaveUri == null) {
                this.msgLog.info("Switch to slave unable to connect.");
                URI uRI = null;
                return uRI;
            }
            success = true;
            this.userLog.info("ServerId %s, successfully moved to slave for master %s", new Object[]{myId, masterUri});
        }
        finally {
            this.monitor.switchToSlaveCompleted(success);
        }
        return slaveUri;
    }

    void checkMyStoreIdAndMastersStoreId(StoreId myStoreId, URI masterUri, DependencyResolver resolver) {
        ClusterMembers clusterMembers = (ClusterMembers)resolver.resolveDependency(ClusterMembers.class);
        InstanceId serverId = HighAvailabilityModeSwitcher.getServerId(masterUri);
        Iterable<ClusterMember> members = clusterMembers.getMembers();
        ClusterMember master = (ClusterMember)Iterables.firstOrNull((Iterable)Iterables.filter(ClusterMembers.hasInstanceId(serverId), members));
        if (master == null) {
            throw new IllegalStateException("Cannot find the master among " + members + " with master serverId=" + serverId + " and uri=" + masterUri);
        }
        StoreId masterStoreId = master.getStoreId();
        if (!myStoreId.equals((Object)masterStoreId)) {
            throw new MismatchingStoreIdException(myStoreId, master.getStoreId());
        }
        if (!myStoreId.equalsByUpgradeId(master.getStoreId())) {
            throw new BranchedDataException("My store with " + myStoreId + " was updated independently from master's store " + masterStoreId);
        }
    }

    private URI startHaCommunication(LifeSupport haCommunicationLife, NeoStoreDataSource neoDataSource, URI me, URI masterUri, StoreId storeId, CancellationRequest cancellationRequest) throws IllegalArgumentException, InterruptedException {
        MasterClient master = this.newMasterClient(masterUri, me, neoDataSource.getStoreId(), haCommunicationLife);
        TransactionObligationFulfiller obligationFulfiller = (TransactionObligationFulfiller)this.resolver.resolveDependency(TransactionObligationFulfiller.class);
        UpdatePullerScheduler updatePullerScheduler = this.updatePullerFactory.createUpdatePullerScheduler(this.updatePuller);
        SlaveImpl slaveImpl = new SlaveImpl(obligationFulfiller);
        SlaveServer server = this.slaveServerFactory.apply(slaveImpl);
        if (cancellationRequest.cancellationRequested()) {
            this.msgLog.info("Switch to slave cancelled, unable to start HA-communication");
            return null;
        }
        this.masterDelegateHandler.setDelegate(master);
        haCommunicationLife.add((Lifecycle)updatePullerScheduler);
        haCommunicationLife.add((Lifecycle)server);
        haCommunicationLife.start();
        if (!this.catchUpWithMaster(this.updatePuller)) {
            return null;
        }
        URI slaveHaURI = this.createHaURI(me, server);
        this.clusterMemberAvailability.memberIsAvailable("slave", slaveHaURI, storeId);
        return slaveHaURI;
    }

    private boolean catchUpWithMaster(UpdatePuller updatePuller) throws IllegalArgumentException, InterruptedException {
        this.monitor.catchupStarted();
        RequestContext catchUpRequestContext = this.requestContextFactory.newRequestContext();
        this.userLog.info("Catching up with master. I'm at %s", new Object[]{catchUpRequestContext});
        if (!updatePuller.tryPullUpdates()) {
            return false;
        }
        this.userLog.info("Now caught up with master");
        this.monitor.catchupCompleted();
        return true;
    }

    private URI createHaURI(URI me, Server<?, ?> server) {
        InetSocketAddress serverSocketAddress = server.getSocketAddress();
        String hostString = ServerUtil.getHostString((InetSocketAddress)serverSocketAddress);
        String host = SwitchToSlave.isWildcard(hostString) ? me.getHost() : hostString;
        host = this.ensureWrapForIpv6Uri(host);
        InstanceId serverId = (InstanceId)this.config.get(ClusterSettings.server_id);
        return URI.create("ha://" + host + ":" + serverSocketAddress.getPort() + "?serverId=" + serverId);
    }

    private String ensureWrapForIpv6Uri(String host) {
        if (host.contains(":") && !host.contains("[")) {
            host = "[" + host + "]";
        }
        return host;
    }

    private static boolean isWildcard(String hostString) {
        return hostString.contains("0.0.0.0") || hostString.contains("::") || hostString.contains("0:0:0:0:0:0:0:0");
    }

    MasterClient newMasterClient(URI masterUri, URI me, StoreId storeId, LifeSupport life) {
        return this.masterClientResolver.instantiate(masterUri.getHost(), masterUri.getPort(), me.getHost(), this.monitors, storeId, life);
    }

    private void startServicesAgain() throws Throwable {
        this.msgLog.debug("Starting services again");
        for (Class<? extends Lifecycle> serviceClass : SERVICES_TO_RESTART_FOR_STORE_COPY) {
            ((Lifecycle)this.resolver.resolveDependency(serviceClass)).start();
        }
    }

    void checkDataConsistencyWithMaster(URI availableMasterId, Master master, StoreId storeId, TransactionIdStore transactionIdStore) {
        HandshakeResult handshake;
        TransactionId myLastCommittedTxData = transactionIdStore.getLastCommittedTransaction();
        long myLastCommittedTx = myLastCommittedTxData.transactionId();
        try (Response<HandshakeResult> response = master.handshake(myLastCommittedTx, storeId);){
            handshake = (HandshakeResult)response.response();
            this.requestContextFactory.setEpoch(handshake.epoch());
        }
        catch (BranchedDataException e) {
            throw new BranchedDataException("The database stored on this machine has diverged from that of the master. This will be automatically resolved.", e);
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof MissingLogDataException) {
                throw new StoreOutOfDateException("The master is missing the log required to complete the consistency check", e.getCause());
            }
            throw e;
        }
        long myChecksum = myLastCommittedTxData.checksum();
        if (myChecksum != handshake.txChecksum()) {
            String msg = "The cluster contains two logically different versions of the database.. This will be automatically resolved. Details: I (server_id:" + this.config.get(ClusterSettings.server_id) + ") think checksum for txId (" + myLastCommittedTx + ") is " + myChecksum + ", but master (server_id:" + HighAvailabilityModeSwitcher.getServerId(availableMasterId) + ") says that it's " + handshake.txChecksum() + ", where handshake is " + handshake;
            throw new BranchedDataException(msg);
        }
        this.msgLog.info("Checksum for last committed tx ok with lastTxId=" + myLastCommittedTx + " with checksum=" + myChecksum, new Object[]{true});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyStoreFromMasterIfNeeded(URI masterUri, URI me, CancellationRequest cancellationRequest) throws Throwable {
        if (!NeoStores.isStorePresent((PageCache)this.pageCache, (File)this.storeDir)) {
            boolean success = false;
            this.monitor.storeCopyStarted();
            LifeSupport copyLife = new LifeSupport();
            try {
                boolean masterIsOld;
                MasterClient masterClient = this.newMasterClient(masterUri, me, null, copyLife);
                copyLife.start();
                boolean bl = masterIsOld = MasterClient.CURRENT.compareTo(masterClient.getProtocolVersion()) > 0;
                if (masterIsOld) {
                    throw new UnableToCopyStoreFromOldMasterException(MasterClient.CURRENT.getApplicationProtocol(), masterClient.getProtocolVersion().getApplicationProtocol());
                }
                this.copyStoreFromMaster(masterClient, cancellationRequest, MoveAfterCopy.moveReplaceExisting());
                success = true;
            }
            finally {
                this.monitor.storeCopyCompleted(success);
                copyLife.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeConsistencyChecks(TransactionIdStore txIdStore, URI masterUri, URI me, StoreId storeId, CancellationRequest cancellationRequest) throws Throwable {
        LifeSupport consistencyCheckLife = new LifeSupport();
        try {
            MasterClient masterClient = this.newMasterClient(masterUri, me, storeId, consistencyCheckLife);
            consistencyCheckLife.start();
            if (cancellationRequest.cancellationRequested()) {
                boolean bl = false;
                return bl;
            }
            this.checkDataConsistency(masterClient, txIdStore, storeId, masterUri, me, cancellationRequest);
        }
        finally {
            consistencyCheckLife.shutdown();
        }
        return true;
    }

    abstract void checkDataConsistency(MasterClient var1, TransactionIdStore var2, StoreId var3, URI var4, URI var5, CancellationRequest var6) throws Throwable;

    void cleanStoreDir() throws IOException {
        StoreUtil.cleanStoreDir((File)this.storeDir, (PageCache)this.pageCache);
    }

    void stopServices() throws Exception {
        this.msgLog.debug("Stopping services to handle branched store");
        for (int i = SERVICES_TO_RESTART_FOR_STORE_COPY.length - 1; i >= 0; --i) {
            Class<? extends Lifecycle> serviceClass = SERVICES_TO_RESTART_FOR_STORE_COPY[i];
            try {
                ((Lifecycle)this.resolver.resolveDependency(serviceClass)).stop();
                continue;
            }
            catch (Exception exception) {
                throw exception;
            }
            catch (Throwable throwable) {
                throw new Exception("Unexpected error while stopping services to handle branched data", throwable);
            }
        }
    }

    void copyStoreFromMaster(final MasterClient masterClient, CancellationRequest cancellationRequest, MoveAfterCopy moveAfterCopy) throws Throwable {
        try {
            this.userLog.info("Copying store from master");
            StoreCopyClient.StoreCopyRequester requester = new StoreCopyClient.StoreCopyRequester(){

                public Response<?> copyStore(StoreWriter writer) {
                    return masterClient.copyStore(new RequestContext(0L, ((InstanceId)SwitchToSlave.this.config.get(ClusterSettings.server_id)).toIntegerIndex(), 0, 1L, 0L), writer);
                }

                public void done() {
                }
            };
            MoveAfterCopy moveAfterCopyWithLogging = (moves, fromDirectory, toDirectory) -> {
                this.userLog.info("Copied store from master to " + fromDirectory);
                this.msgLog.info("Starting post copy operation to move store from " + fromDirectory + " to " + this.storeDir);
                moveAfterCopy.move(moves, fromDirectory, toDirectory);
            };
            this.storeCopyClient.copyStore(requester, cancellationRequest, moveAfterCopyWithLogging);
            this.startServicesAgain();
            this.userLog.info("Finished copying store from master");
        }
        catch (Throwable t) {
            this.cleanStoreDir();
            throw t;
        }
    }

    public static interface Monitor {
        public void switchToSlaveStarted();

        public void switchToSlaveCompleted(boolean var1);

        public void storeCopyStarted();

        public void storeCopyCompleted(boolean var1);

        public void catchupStarted();

        public void catchupCompleted();
    }
}

