/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.ha;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.neo4j.cluster.ClusterSettings;
import org.neo4j.cluster.client.Cluster;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.factory.HighlyAvailableGraphDatabaseFactory;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.kernel.impl.util.Listener;
import org.neo4j.test.rule.TestDirectory;

public class ClusterRule
extends ExternalResource
implements ClusterManager.ClusterBuilder<ClusterRule> {
    private static final ClusterManager.StoreDirInitializer defaultStoreDirInitializer = new ClusterManager.StoreDirInitializer(){

        @Override
        public void initializeStoreDir(int serverId, File storeDir) throws IOException {
            File[] files = storeDir.listFiles();
            if (files != null) {
                for (File file : files) {
                    FileUtils.deleteRecursively((File)file);
                }
            }
        }
    };
    private ClusterManager.Builder clusterManagerBuilder;
    private ClusterManager clusterManager;
    private File storeDirectory;
    private final TestDirectory testDirectory;
    private ClusterManager.ManagedCluster cluster;

    public ClusterRule(Class<?> testClass) {
        this.testDirectory = TestDirectory.testDirectory(testClass);
        this.clusterManagerBuilder = ((ClusterManager.Builder)((ClusterManager.Builder)((ClusterManager.Builder)((ClusterManager.Builder)((ClusterManager.Builder)((ClusterManager.Builder)new ClusterManager.Builder().withSharedSetting(GraphDatabaseSettings.store_internal_log_level, "DEBUG")).withSharedSetting(ClusterSettings.default_timeout, "1s")).withSharedSetting(HaSettings.tx_push_factor, "0")).withSharedSetting(GraphDatabaseSettings.pagecache_memory, "8m")).withSharedSetting(ClusterSettings.join_timeout, "60s")).withAvailabilityChecks(new Predicate[]{ClusterManager.allSeesAllAsAvailable()})).withStoreDirInitializer(defaultStoreDirInitializer);
    }

    @Override
    public ClusterRule withRootDirectory(File root) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ClusterRule withSeedDir(File seedDir) {
        return this.set(this.clusterManagerBuilder.withSeedDir(seedDir));
    }

    @Override
    public ClusterRule withStoreDirInitializer(ClusterManager.StoreDirInitializer initializer) {
        return this.set(this.clusterManagerBuilder.withStoreDirInitializer(initializer));
    }

    @Override
    public ClusterRule withDbFactory(HighlyAvailableGraphDatabaseFactory dbFactory) {
        return this.set(this.clusterManagerBuilder.withDbFactory(dbFactory));
    }

    @Override
    public ClusterRule withCluster(Supplier<Cluster> provider) {
        return this.set((ClusterManager.Builder)this.clusterManagerBuilder.withCluster((Supplier)provider));
    }

    @Override
    public ClusterRule withInstanceConfig(Map<String, IntFunction<String>> commonConfig) {
        return this.set((ClusterManager.Builder)this.clusterManagerBuilder.withInstanceConfig((Map)commonConfig));
    }

    @Override
    public ClusterRule withBolt(int port) {
        return this.set(this.clusterManagerBuilder.withBolt(port));
    }

    @Override
    public ClusterRule withInstanceSetting(Setting<?> setting, IntFunction<String> valueFunction) {
        return this.set((ClusterManager.Builder)this.clusterManagerBuilder.withInstanceSetting((Setting)setting, (IntFunction)valueFunction));
    }

    @Override
    public ClusterRule withSharedConfig(Map<String, String> commonConfig) {
        return this.set((ClusterManager.Builder)this.clusterManagerBuilder.withSharedConfig((Map)commonConfig));
    }

    @Override
    public ClusterRule withSharedSetting(Setting<?> setting, String value) {
        return this.set((ClusterManager.Builder)this.clusterManagerBuilder.withSharedSetting((Setting)setting, value));
    }

    @Override
    public ClusterRule withInitialDataset(Listener<GraphDatabaseService> transactor) {
        return this.set((ClusterManager.Builder)this.clusterManagerBuilder.withInitialDataset((Listener)transactor));
    }

    @Override
    @SafeVarargs
    public final ClusterRule withAvailabilityChecks(Predicate<ClusterManager.ManagedCluster> ... checks) {
        return this.set((ClusterManager.Builder)this.clusterManagerBuilder.withAvailabilityChecks((Predicate[])checks));
    }

    @Override
    public final ClusterRule withConsistencyCheckAfterwards() {
        return this.set(this.clusterManagerBuilder.withConsistencyCheckAfterwards());
    }

    @Override
    public ClusterRule withFirstInstanceId(int firstInstanceId) {
        return this.set(this.clusterManagerBuilder.withFirstInstanceId(firstInstanceId));
    }

    private ClusterRule set(ClusterManager.Builder builder) {
        this.clusterManagerBuilder = builder;
        return this;
    }

    public ClusterManager.ManagedCluster startCluster() throws Exception {
        if (this.cluster == null) {
            if (this.clusterManager == null) {
                this.clusterManager = this.clusterManagerBuilder.withRootDirectory(this.storeDirectory).build();
            }
            try {
                this.clusterManager.start();
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
            this.cluster = this.clusterManager.getCluster();
        }
        this.cluster.await(ClusterManager.allSeesAllAsAvailable());
        return this.cluster;
    }

    public Statement apply(final Statement base, final Description description) {
        Statement testMethod = new Statement(){

            public void evaluate() throws Throwable {
                String name = description.getMethodName() != null ? description.getMethodName() : description.getClassName();
                ClusterRule.this.storeDirectory = ClusterRule.this.testDirectory.directory(name);
                base.evaluate();
            }
        };
        Statement testMethodWithBeforeAndAfter = super.apply(testMethod, description);
        return this.testDirectory.apply(testMethodWithBeforeAndAfter, description);
    }

    protected void after() {
        this.shutdownCluster();
    }

    public void shutdownCluster() {
        if (this.clusterManager != null) {
            this.clusterManager.safeShutdown();
            this.cluster = null;
        }
    }

    public File directory(String name) {
        return this.testDirectory.directory(name);
    }

    public File cleanDirectory(String name) throws IOException {
        return this.testDirectory.cleanDirectory(name);
    }

    public static IntFunction<String> constant(String value) {
        return ClusterManager.constant(value);
    }

    public static IntFunction<String> intBase(int oneBasedServerId) {
        return serverId -> String.valueOf(oneBasedServerId + serverId);
    }

    public static IntFunction<String> stringWithIntBase(String prefix, int oneBasedServerId) {
        return serverId -> prefix + (oneBasedServerId + serverId);
    }
}

