/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

import java.io.File;
import java.util.Iterator;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransientTransactionFailureException;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.ConstraintType;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.ha.HaSettings;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.coreapi.schema.NodePropertyExistenceConstraintDefinition;
import org.neo4j.kernel.impl.coreapi.schema.RelationshipPropertyExistenceConstraintDefinition;
import org.neo4j.kernel.impl.coreapi.schema.UniquenessConstraintDefinition;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.test.ha.ClusterRule;

@RunWith(value=Suite.class)
@Suite.SuiteClasses(value={NodePropertyExistenceConstraintHaIT.class, RelationshipPropertyExistenceConstraintHaIT.class, UniquenessConstraintHaIT.class})
public class ConstraintHaIT {

    public static abstract class AbstractConstraintHaIT {
        @Rule
        public ClusterRule clusterRule = new ClusterRule(this.getClass()).withSharedSetting(HaSettings.read_timeout, "4000s");
        private static final String TYPE = "Type";
        private static final String PROPERTY_KEY = "name";

        protected String type(int id) {
            return "Type_" + this.getClass().getSimpleName() + "_" + id;
        }

        protected String key(int id) {
            return "name_" + this.getClass().getSimpleName() + "_" + id;
        }

        protected abstract void createConstraint(GraphDatabaseService var1, String var2, String var3);

        protected abstract ConstraintDefinition getConstraint(GraphDatabaseService var1, String var2, String var3);

        protected abstract IndexDefinition getIndex(GraphDatabaseService var1, String var2, String var3);

        protected abstract void createEntityInTx(GraphDatabaseService var1, String var2, String var3, String var4);

        protected abstract void createConstraintViolation(GraphDatabaseService var1, String var2, String var3, String var4);

        protected abstract void assertConstraintHolds(GraphDatabaseService var1, String var2, String var3, String var4);

        protected abstract Class<? extends ConstraintDefinition> constraintDefinitionClass();

        @Test
        public void shouldCreateConstraintOnMaster() throws Exception {
            ClusterManager.ManagedCluster cluster = this.clusterRule.startCluster();
            HighlyAvailableGraphDatabase master = cluster.getMaster();
            String type = this.type(0);
            String key = this.key(0);
            try (Transaction tx = master.beginTx();){
                this.createConstraint((GraphDatabaseService)master, type, key);
                tx.success();
            }
            cluster.sync(new HighlyAvailableGraphDatabase[0]);
            for (HighlyAvailableGraphDatabase clusterMember : cluster.getAllMembers(new HighlyAvailableGraphDatabase[0])) {
                Transaction tx = clusterMember.beginTx();
                Throwable throwable = null;
                try {
                    ConstraintDefinition constraint = this.getConstraint((GraphDatabaseService)clusterMember, type, key);
                    AbstractConstraintHaIT.validateLabelOrRelationshipType(constraint, type);
                    Assert.assertEquals((Object)key, (Object)Iterables.single((Iterable)constraint.getPropertyKeys()));
                    tx.success();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (tx == null) continue;
                    if (throwable != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    tx.close();
                }
            }
        }

        @Test
        public void shouldNotBePossibleToCreateConstraintsDirectlyOnSlaves() throws Exception {
            ClusterManager.ManagedCluster cluster = this.clusterRule.startCluster();
            HighlyAvailableGraphDatabase slave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
            String type = this.type(1);
            String key = this.key(1);
            try (Transaction ignored = slave.beginTx();){
                this.createConstraint((GraphDatabaseService)slave, type, key);
                Assert.fail((String)"We expected to not be able to create a constraint on a slave in a cluster.");
            }
            catch (QueryExecutionException e) {
                Assert.assertThat((Object)Exceptions.rootCause((Throwable)e), (Matcher)Matchers.instanceOf(InvalidTransactionTypeKernelException.class));
            }
        }

        @Test
        public void shouldRemoveConstraints() throws Exception {
            ClusterManager.ManagedCluster cluster = this.clusterRule.startCluster();
            HighlyAvailableGraphDatabase master = cluster.getMaster();
            String type = this.type(2);
            String key = this.key(2);
            try (Transaction tx = master.beginTx();){
                long constraintCountBefore = Iterables.count((Iterable)master.schema().getConstraints());
                long indexCountBefore = Iterables.count((Iterable)master.schema().getIndexes());
                this.createConstraint((GraphDatabaseService)master, type, key);
                tx.success();
            }
            cluster.sync(new HighlyAvailableGraphDatabase[0]);
            this.createEntityInTx((GraphDatabaseService)cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]), type, key, "Foo");
            tx = master.beginTx();
            var10_6 = null;
            try {
                this.getConstraint((GraphDatabaseService)master, type, key).drop();
                tx.success();
            }
            catch (Throwable throwable) {
                var10_6 = throwable;
                throw throwable;
            }
            finally {
                if (tx != null) {
                    if (var10_6 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var10_6.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
            cluster.sync(new HighlyAvailableGraphDatabase[0]);
            for (HighlyAvailableGraphDatabase clusterMember : cluster.getAllMembers(new HighlyAvailableGraphDatabase[0])) {
                Transaction tx = clusterMember.beginTx();
                Throwable throwable = null;
                try {
                    Assert.assertNull((Object)this.getConstraint((GraphDatabaseService)clusterMember, type, key));
                    Assert.assertNull((Object)this.getIndex((GraphDatabaseService)clusterMember, type, key));
                    this.createConstraintViolation((GraphDatabaseService)clusterMember, type, key, "Foo");
                    tx.success();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (tx == null) continue;
                    if (throwable != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    tx.close();
                }
            }
        }

        @Test
        public void shouldNotAllowOldUncommittedTransactionsToResumeAndViolateConstraint() throws Exception {
            ClusterManager.ManagedCluster cluster = ((ClusterRule)this.clusterRule.withSharedSetting(HaSettings.read_timeout, "4000s")).startCluster();
            HighlyAvailableGraphDatabase slave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
            HighlyAvailableGraphDatabase master = cluster.getMaster();
            String type = this.type(3);
            String key = this.key(3);
            ThreadToStatementContextBridge txBridge = AbstractConstraintHaIT.threadToStatementContextBridge(slave);
            this.createEntityInTx((GraphDatabaseService)master, type, key, "Foo");
            slave.beginTx();
            this.createConstraintViolation((GraphDatabaseService)slave, type, key, "Foo");
            KernelTransaction slaveTx = txBridge.getTopLevelTransactionBoundToThisThread(true);
            txBridge.unbindTransactionFromCurrentThread();
            try (Transaction tx = master.beginTx();){
                this.createConstraint((GraphDatabaseService)master, type, key);
                tx.success();
            }
            txBridge.bindTransactionToCurrentThread(slaveTx);
            try {
                slaveTx.success();
                slaveTx.close();
                Assert.fail((String)"Expected this commit to fail :(");
            }
            catch (org.neo4j.graphdb.TransactionFailureException | TransientTransactionFailureException e) {
                Assert.assertThat((Object)e.getCause().getCause(), (Matcher)Matchers.instanceOf(TransactionFailureException.class));
            }
            this.assertConstraintHolds((GraphDatabaseService)master, type, key, "Foo");
            cluster.sync(new HighlyAvailableGraphDatabase[0]);
            this.assertConstraintHolds((GraphDatabaseService)slave, type, key, "Foo");
            this.createEntityInTx((GraphDatabaseService)slave, type, key, "Bar");
            this.createEntityInTx((GraphDatabaseService)master, type, key, "Baz");
        }

        @Test
        public void newSlaveJoiningClusterShouldNotAcceptOperationsUntilConstraintIsOnline() throws Throwable {
            ClusterManager.ManagedCluster cluster = this.clusterRule.startCluster();
            String type = this.type(4);
            String key = this.key(4);
            HighlyAvailableGraphDatabase master = cluster.getMaster();
            HighlyAvailableGraphDatabase slave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
            File slaveStoreDirectory = cluster.getStoreDir(slave);
            ClusterManager.RepairKit shutdownSlave = cluster.shutdown(slave);
            FileUtils.deleteRecursively((File)slaveStoreDirectory);
            try (Transaction tx = master.beginTx();){
                this.createConstraint((GraphDatabaseService)master, type, key);
                tx.success();
            }
            slave = shutdownSlave.repair();
            var9_9 = null;
            try (Transaction ignored = slave.beginTx();){
                ConstraintDefinition definition = this.getConstraint((GraphDatabaseService)slave, type, key);
                Assert.assertThat((Object)definition, (Matcher)Matchers.instanceOf(this.constraintDefinitionClass()));
                Assert.assertThat((Object)Iterables.single((Iterable)definition.getPropertyKeys()), (Matcher)Matchers.equalTo((Object)key));
                AbstractConstraintHaIT.validateLabelOrRelationshipType(definition, type);
            }
            catch (Throwable throwable) {
                var9_9 = throwable;
                throw throwable;
            }
        }

        private static ThreadToStatementContextBridge threadToStatementContextBridge(HighlyAvailableGraphDatabase db) {
            DependencyResolver dependencyResolver = db.getDependencyResolver();
            return (ThreadToStatementContextBridge)dependencyResolver.resolveDependency(ThreadToStatementContextBridge.class);
        }

        private static void validateLabelOrRelationshipType(ConstraintDefinition constraint, String type) {
            if (constraint.isConstraintType(ConstraintType.RELATIONSHIP_PROPERTY_EXISTENCE)) {
                Assert.assertEquals((Object)type, (Object)constraint.getRelationshipType().name());
            } else {
                Assert.assertEquals((Object)type, (Object)constraint.getLabel().name());
            }
        }
    }

    public static class UniquenessConstraintHaIT
    extends AbstractConstraintHaIT {
        @Override
        protected void createConstraint(GraphDatabaseService db, String type, String value) {
            db.execute(String.format("CREATE CONSTRAINT ON (n:`%s`) ASSERT n.`%s` IS UNIQUE", type, value));
        }

        @Override
        protected ConstraintDefinition getConstraint(GraphDatabaseService db, String type, String value) {
            return (ConstraintDefinition)Iterables.singleOrNull((Iterable)db.schema().getConstraints(DynamicLabel.label((String)type)));
        }

        @Override
        protected IndexDefinition getIndex(GraphDatabaseService db, String type, String value) {
            return (IndexDefinition)Iterables.singleOrNull((Iterable)db.schema().getIndexes(DynamicLabel.label((String)type)));
        }

        @Override
        protected void createEntityInTx(GraphDatabaseService db, String type, String propertyKey, String value) {
            try (Transaction tx = db.beginTx();){
                db.createNode(new Label[]{DynamicLabel.label((String)type)}).setProperty(propertyKey, (Object)value);
                tx.success();
            }
        }

        @Override
        protected void createConstraintViolation(GraphDatabaseService db, String type, String propertyKey, String value) {
            db.createNode(new Label[]{DynamicLabel.label((String)type)}).setProperty(propertyKey, (Object)value);
        }

        @Override
        protected void assertConstraintHolds(GraphDatabaseService db, String type, String propertyKey, String value) {
            try (Transaction tx = db.beginTx();){
                Assert.assertEquals((long)1L, (long)Iterators.asList((Iterator)db.findNodes(DynamicLabel.label((String)type), propertyKey, (Object)value)).size());
                tx.success();
            }
        }

        @Override
        protected Class<? extends ConstraintDefinition> constraintDefinitionClass() {
            return UniquenessConstraintDefinition.class;
        }
    }

    public static class RelationshipPropertyExistenceConstraintHaIT
    extends AbstractConstraintHaIT {
        @Override
        protected void createConstraint(GraphDatabaseService db, String type, String value) {
            db.execute(String.format("CREATE CONSTRAINT ON ()-[r:`%s`]-() ASSERT exists(r.`%s`)", type, value));
        }

        @Override
        protected ConstraintDefinition getConstraint(GraphDatabaseService db, String type, String value) {
            return (ConstraintDefinition)Iterables.singleOrNull((Iterable)db.schema().getConstraints((RelationshipType)DynamicRelationshipType.withName((String)type)));
        }

        @Override
        protected IndexDefinition getIndex(GraphDatabaseService db, String type, String value) {
            return null;
        }

        @Override
        protected void createEntityInTx(GraphDatabaseService db, String type, String propertyKey, String value) {
            try (Transaction tx = db.beginTx();){
                Node start = db.createNode();
                Node end = db.createNode();
                Relationship relationship = start.createRelationshipTo(end, (RelationshipType)DynamicRelationshipType.withName((String)type));
                relationship.setProperty(propertyKey, (Object)value);
                tx.success();
            }
        }

        @Override
        protected void createConstraintViolation(GraphDatabaseService db, String type, String propertyKey, String value) {
            Node start = db.createNode();
            Node end = db.createNode();
            start.createRelationshipTo(end, (RelationshipType)DynamicRelationshipType.withName((String)type));
        }

        @Override
        protected void assertConstraintHolds(GraphDatabaseService db, String type, String propertyKey, String value) {
            try (Transaction tx = db.beginTx();){
                for (Relationship relationship : db.getAllRelationships()) {
                    if (!relationship.isType((RelationshipType)DynamicRelationshipType.withName((String)type))) continue;
                    Assert.assertTrue((boolean)relationship.hasProperty(propertyKey));
                }
                tx.success();
            }
        }

        @Override
        protected Class<? extends ConstraintDefinition> constraintDefinitionClass() {
            return RelationshipPropertyExistenceConstraintDefinition.class;
        }
    }

    public static class NodePropertyExistenceConstraintHaIT
    extends AbstractConstraintHaIT {
        @Override
        protected void createConstraint(GraphDatabaseService db, String type, String value) {
            db.execute(String.format("CREATE CONSTRAINT ON (n:`%s`) ASSERT exists(n.`%s`)", type, value));
        }

        @Override
        protected ConstraintDefinition getConstraint(GraphDatabaseService db, String type, String value) {
            return (ConstraintDefinition)Iterables.singleOrNull((Iterable)db.schema().getConstraints(DynamicLabel.label((String)type)));
        }

        @Override
        protected IndexDefinition getIndex(GraphDatabaseService db, String type, String value) {
            return null;
        }

        @Override
        protected void createEntityInTx(GraphDatabaseService db, String type, String propertyKey, String value) {
            try (Transaction tx = db.beginTx();){
                db.createNode(new Label[]{DynamicLabel.label((String)type)}).setProperty(propertyKey, (Object)value);
                tx.success();
            }
        }

        @Override
        protected void createConstraintViolation(GraphDatabaseService db, String type, String propertyKey, String value) {
            db.createNode(new Label[]{DynamicLabel.label((String)type)});
        }

        @Override
        protected void assertConstraintHolds(GraphDatabaseService db, String type, String propertyKey, String value) {
            try (Transaction tx = db.beginTx();){
                ResourceIterator nodes = db.findNodes(DynamicLabel.label((String)type));
                while (nodes.hasNext()) {
                    Node node = (Node)nodes.next();
                    Assert.assertTrue((boolean)node.hasProperty(propertyKey));
                }
                tx.success();
            }
        }

        @Override
        protected Class<? extends ConstraintDefinition> constraintDefinitionClass() {
            return NodePropertyExistenceConstraintDefinition.class;
        }
    }
}

